/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.commons.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.itextpdf.commons.json.JsonArray;
import com.itextpdf.commons.json.JsonBoolean;
import com.itextpdf.commons.json.JsonNull;
import com.itextpdf.commons.json.JsonNumber;
import com.itextpdf.commons.json.JsonObject;
import com.itextpdf.commons.json.JsonString;
import com.itextpdf.commons.json.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;

class JsonValueDeserializer
extends JsonDeserializer<JsonValue> {
    JsonValueDeserializer() {
    }

    public JsonValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.readValue(p);
    }

    private JsonValue readValue(JsonParser p) throws IOException {
        JsonToken t = p.currentToken();
        if (t == null) {
            t = p.nextToken();
        }
        switch (t) {
            case VALUE_STRING: {
                return new JsonString(p.getValueAsString());
            }
            case VALUE_NUMBER_INT: {
                return new JsonNumber(p.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                return new JsonNumber(p.getDoubleValue());
            }
            case VALUE_TRUE: {
                return JsonBoolean.of(true);
            }
            case VALUE_FALSE: {
                return JsonBoolean.of(false);
            }
            case VALUE_NULL: {
                return JsonNull.JSON_NULL;
            }
            case START_ARRAY: {
                return this.readArray(p);
            }
            case START_OBJECT: {
                return this.readObject(p);
            }
        }
        throw new IOException("Unexpected token: " + t);
    }

    private JsonValue readArray(JsonParser p) throws IOException {
        JsonToken t;
        ArrayList<JsonValue> list = new ArrayList<JsonValue>();
        while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
            list.add(this.readValue(p));
        }
        return new JsonArray(list);
    }

    private JsonValue readObject(JsonParser p) throws IOException {
        JsonToken t;
        LinkedHashMap<String, JsonValue> map = new LinkedHashMap<String, JsonValue>();
        while ((t = p.nextToken()) != JsonToken.END_OBJECT) {
            if (t != JsonToken.FIELD_NAME) {
                throw new IOException("Expected field name, got: " + t);
            }
            String field = p.currentName();
            p.nextToken();
            map.put(field, this.readValue(p));
        }
        return new JsonObject(map);
    }
}

