/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup.autosweep;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfRedactAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.parser.PdfDocumentContentParser;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IEventListener;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IPdfTextLocation;
import com.itextpdf.pdfcleanup.PdfCleanUpLocation;
import com.itextpdf.pdfcleanup.autosweep.ICleanupStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PdfAutoSweepTools {
    private ICleanupStrategy strategy;
    private int annotationNumber = 1;

    public PdfAutoSweepTools(ICleanupStrategy strategy) {
        this.strategy = strategy;
    }

    public void highlight(PdfDocument pdfDocument) {
        for (int i = 1; i <= pdfDocument.getNumberOfPages(); ++i) {
            this.highlight(pdfDocument.getPage(i));
        }
    }

    public void highlight(PdfPage pdfPage) {
        List<PdfCleanUpLocation> cleanUpLocations = this.getPdfCleanUpLocations(pdfPage);
        for (PdfCleanUpLocation loc : cleanUpLocations) {
            PdfCanvas canvas = new PdfCanvas(pdfPage);
            canvas.setColor(loc.getCleanUpColor(), true);
            canvas.rectangle(loc.getRegion());
            canvas.fill();
        }
    }

    public void tentativeCleanUp(PdfDocument pdfDocument) {
        this.annotationNumber = 1;
        for (int i = 1; i <= pdfDocument.getNumberOfPages(); ++i) {
            this.tentativeCleanUp(pdfDocument.getPage(i));
        }
    }

    public void tentativeCleanUp(PdfPage pdfPage) {
        List<PdfCleanUpLocation> cleanUpLocations = this.getPdfCleanUpLocations(pdfPage);
        for (PdfCleanUpLocation loc : cleanUpLocations) {
            PdfString title = new PdfString("Annotation:" + this.annotationNumber);
            ++this.annotationNumber;
            float[] color = loc.getCleanUpColor().getColorValue();
            PdfAnnotation redact = new PdfRedactAnnotation(loc.getRegion()).setDefaultAppearance(new PdfString("Helvetica 12 Tf 0 g")).setTitle(title).put(PdfName.Subj, (PdfObject)PdfName.Redact).put(PdfName.IC, (PdfObject)new PdfArray(new float[]{0.0f, 0.0f, 0.0f})).put(PdfName.OC, (PdfObject)new PdfArray(color));
            pdfPage.addAnnotation(redact);
        }
    }

    public List<PdfCleanUpLocation> getPdfCleanUpLocations(PdfPage page) {
        PdfDocument doc = page.getDocument();
        PdfDocumentContentParser parser = new PdfDocumentContentParser(doc);
        int pageNr = doc.getPageNumber(page);
        ArrayList<PdfCleanUpLocation> toClean = new ArrayList<PdfCleanUpLocation>();
        parser.processContent(pageNr, (IEventListener)this.strategy);
        for (IPdfTextLocation rect : this.strategy.getResultantLocations()) {
            if (rect == null) continue;
            toClean.add(new PdfCleanUpLocation(pageNr, rect.getRectangle(), this.strategy.getRedactionColor(rect)));
        }
        this.resetStrategy();
        return toClean;
    }

    public List<PdfCleanUpLocation> getPdfCleanUpLocations(PdfDocument doc) {
        PdfDocumentContentParser parser = new PdfDocumentContentParser(doc);
        ArrayList<PdfCleanUpLocation> toClean = new ArrayList<PdfCleanUpLocation>();
        for (int pageNr = 1; pageNr <= doc.getNumberOfPages(); ++pageNr) {
            parser.processContent(pageNr, (IEventListener)this.strategy);
            for (IPdfTextLocation rect : this.strategy.getResultantLocations()) {
                if (rect == null) continue;
                toClean.add(new PdfCleanUpLocation(pageNr, rect.getRectangle(), this.strategy.getRedactionColor(rect)));
            }
            this.resetStrategy();
        }
        Collections.sort(toClean, new Comparator<PdfCleanUpLocation>(){

            @Override
            public int compare(PdfCleanUpLocation o1, PdfCleanUpLocation o2) {
                if (o1.getPage() != o2.getPage()) {
                    return o1.getPage() < o2.getPage() ? -1 : 1;
                }
                Rectangle r1 = o1.getRegion();
                Rectangle r2 = o2.getRegion();
                if (r1.getY() == r2.getY()) {
                    return r1.getX() == r2.getX() ? 0 : (r1.getX() < r2.getX() ? -1 : 1);
                }
                return r1.getY() < r2.getY() ? -1 : 1;
            }
        });
        return toClean;
    }

    private void resetStrategy() {
        this.strategy = this.strategy.reset();
    }
}

