/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup;

import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfTextArray;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.pdfcleanup.PdfCleanUpProcessor;
import java.util.ArrayList;
import java.util.List;

class TextPositioning {
    private String prevOperator;
    private Float removedTextShift;
    private List<PdfObject> firstPositioningOperands;
    private float[] tdShift;
    private Matrix tmShift;
    private float currLeading = 0.0f;

    TextPositioning() {
    }

    float getCurrLeading() {
        return this.currLeading;
    }

    void appendPositioningOperator(String operator, List<PdfObject> operands) {
        if (this.firstPositioningOperands != null) {
            this.storePositioningInfoInShiftFields();
        }
        if ("TD".equals(operator)) {
            this.currLeading = -((PdfNumber)operands.get(1)).floatValue();
        } else if ("TL".equals(operator)) {
            this.currLeading = ((PdfNumber)operands.get(0)).floatValue();
            return;
        }
        this.removedTextShift = null;
        if (this.prevOperator == null) {
            this.firstPositioningOperands = new ArrayList<PdfObject>(operands);
            this.prevOperator = operator;
        } else if ("Tm".equals(operator)) {
            this.clear();
            this.firstPositioningOperands = new ArrayList<PdfObject>(operands);
            this.prevOperator = operator;
        } else {
            float ty;
            float tx;
            if ("T*".equals(operator)) {
                tx = 0.0f;
                ty = -this.getCurrLeading();
            } else {
                tx = ((PdfNumber)operands.get(0)).floatValue();
                ty = ((PdfNumber)operands.get(1)).floatValue();
            }
            if ("Tm".equals(this.prevOperator)) {
                this.tmShift = new Matrix(tx, ty).multiply(this.tmShift);
            } else {
                this.tdShift[0] = this.tdShift[0] + tx;
                this.tdShift[1] = this.tdShift[1] + ty;
                this.prevOperator = "Td";
            }
        }
    }

    private void storePositioningInfoInShiftFields() {
        if ("Tm".equals(this.prevOperator)) {
            this.tmShift = PdfCleanUpProcessor.operandsToMatrix(this.firstPositioningOperands);
        } else if ("T*".equals(this.prevOperator)) {
            this.tdShift = new float[]{0.0f, -this.getCurrLeading()};
        } else {
            this.tdShift = new float[2];
            this.tdShift[0] = ((PdfNumber)this.firstPositioningOperands.get(0)).floatValue();
            this.tdShift[1] = ((PdfNumber)this.firstPositioningOperands.get(1)).floatValue();
        }
        this.firstPositioningOperands = null;
    }

    void appendTjArrayWithSingleNumber(PdfArray tjArray, float fontSize, float scaling) {
        if (this.removedTextShift == null) {
            this.removedTextShift = Float.valueOf(0.0f);
        }
        float shift = tjArray.getAsNumber(0).floatValue();
        this.removedTextShift = Float.valueOf(this.removedTextShift.floatValue() + shift * fontSize * (scaling / 100.0f) / 1000.0f);
    }

    void clear() {
        this.firstPositioningOperands = null;
        this.prevOperator = null;
        this.removedTextShift = null;
        this.tdShift = null;
        this.tmShift = null;
    }

    void writePositionedText(String operator, List<PdfObject> operands, PdfArray cleanedText, PdfCanvas canvas) {
        this.writePositioningOperator(canvas);
        this.writeText(operator, operands, cleanedText, canvas);
        this.clear();
    }

    private void writePositioningOperator(PdfCanvas canvas) {
        if (this.firstPositioningOperands != null) {
            if ("T*".equals(this.prevOperator) && canvas.getGraphicsState().getLeading() != this.currLeading) {
                canvas.setLeading(this.currLeading);
            }
            PdfCleanUpProcessor.writeOperands(canvas, this.firstPositioningOperands);
        } else if (this.tdShift != null) {
            canvas.moveText((double)this.tdShift[0], (double)this.tdShift[1]);
        } else if (this.tmShift != null) {
            canvas.setTextMatrix(this.tmShift.get(0), this.tmShift.get(1), this.tmShift.get(3), this.tmShift.get(4), this.tmShift.get(6), this.tmShift.get(7));
        }
    }

    private void writeText(String operator, List<PdfObject> operands, PdfArray cleanedText, PdfCanvas canvas) {
        boolean newLineShowText;
        CanvasGraphicsState canvasGs = canvas.getGraphicsState();
        boolean bl = newLineShowText = "'".equals(operator) || "\"".equals(operator);
        if (newLineShowText) {
            if (canvasGs.getLeading() != this.currLeading) {
                canvas.setLeading(this.currLeading);
            }
            this.removedTextShift = null;
        }
        PdfTextArray tjShiftArray = null;
        if (this.removedTextShift != null) {
            float tjShift = this.removedTextShift.floatValue() * 1000.0f / (canvasGs.getFontSize() * canvasGs.getHorizontalScaling() / 100.0f);
            tjShiftArray = new PdfTextArray();
            tjShiftArray.add((PdfObject)new PdfNumber((double)tjShift));
        }
        if (cleanedText != null) {
            if (newLineShowText) {
                canvas.newlineText();
            }
            if (this.removedTextShift != null) {
                tjShiftArray.addAll(cleanedText);
                cleanedText = tjShiftArray;
            }
            canvas.showText(cleanedText);
        } else {
            if (this.removedTextShift != null) {
                canvas.showText(tjShiftArray);
            }
            PdfCleanUpProcessor.writeOperands(canvas, operands);
        }
    }
}

