/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi.util;

import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Future<T> {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private Handler callbackHandler;
    private final List<SuccessCallback<T>> successCallbacks = new ArrayList<SuccessCallback<T>>();
    private final List<FailureCallback> failureCallbacks = new ArrayList<FailureCallback>();

    public static <T> Future<T> runAsync(Callable<T> callable) {
        return new Future<T>(callable);
    }

    private Future(final Callable<T> callable) {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        this.callbackHandler = new Handler(looper);
        EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result = callable.call();
                    Future.this.handleSuccess(result);
                }
                catch (Exception e) {
                    Future.this.handleFailure(e);
                }
            }
        });
    }

    private void handleSuccess(final T result) {
        this.callbackHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList callbacks;
                List list = Future.this.successCallbacks;
                synchronized (list) {
                    callbacks = new ArrayList(Future.this.successCallbacks);
                }
                for (SuccessCallback callback : callbacks) {
                    if (callback == null) continue;
                    callback.onSuccess(result);
                }
            }
        });
    }

    private void handleFailure(final Throwable t) {
        this.callbackHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList callbacks;
                List list = Future.this.failureCallbacks;
                synchronized (list) {
                    callbacks = new ArrayList(Future.this.failureCallbacks);
                }
                for (FailureCallback callback : callbacks) {
                    if (callback == null) continue;
                    callback.onFailure(t);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<T> onSuccess(SuccessCallback<T> successCallback) {
        List<SuccessCallback<T>> list = this.successCallbacks;
        synchronized (list) {
            this.successCallbacks.add(successCallback);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<T> onFailure(FailureCallback failureCallback) {
        List<FailureCallback> list = this.failureCallbacks;
        synchronized (list) {
            this.failureCallbacks.add(failureCallback);
        }
        return this;
    }

    public static interface FailureCallback {
        public void onFailure(Throwable var1);
    }

    public static interface SuccessCallback<T> {
        public void onSuccess(T var1);
    }
}

