/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi.ddl;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.RestrictTo;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DeviceInfo {
    private static final String MOBILE_DEVICE_TYPE = "Android";
    private DeviceFp deviceFp;

    private DeviceInfo(DeviceFp deviceFp) {
        this.deviceFp = deviceFp;
    }

    public static DeviceInfo createDeviceInfo(Context context) {
        return new DeviceInfo(DeviceInfo.createDeviceFp(context));
    }

    private static DeviceFp createDeviceFp(Context context) {
        DeviceFp fp = new DeviceFp();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(displayMetrics);
        } else {
            display.getMetrics(displayMetrics);
        }
        fp.screenWidth = Long.toString(Math.round(Math.ceil((float)displayMetrics.widthPixels / displayMetrics.density)));
        fp.screenHeight = Long.toString(Math.round(Math.ceil((float)displayMetrics.heightPixels / displayMetrics.density)));
        fp.screenScale = Float.toString(displayMetrics.density);
        fp.version = Build.VERSION.RELEASE;
        TimeZone timezone = TimeZone.getDefault();
        int seconds = -1 * timezone.getOffset(new Date().getTime()) / 1000;
        int offsetMinutes = seconds / 60;
        fp.timezoneOffsetMinutes = Integer.toString(offsetMinutes);
        String countryCode = Locale.getDefault().getCountry();
        String languageCode = Locale.getDefault().getLanguage();
        fp.language = languageCode + "_" + countryCode;
        return fp;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("mobileDeviceType", (Object)MOBILE_DEVICE_TYPE);
        json.put("deviceFp", (Object)this.deviceFp.toJSONObject());
        return json;
    }

    static class DeviceFp {
        String screenWidth;
        String screenHeight;
        String screenScale;
        String version;
        String timezoneOffsetMinutes;
        String language;

        DeviceFp() {
        }

        JSONObject toJSONObject() throws JSONException {
            JSONObject json = new JSONObject();
            json.putOpt("screenWidth", (Object)this.screenWidth);
            json.putOpt("screenHeight", (Object)this.screenHeight);
            json.putOpt("screenScale", (Object)this.screenScale);
            json.putOpt("version", (Object)this.version);
            json.putOpt("timezoneOffsetMinutes", (Object)this.timezoneOffsetMinutes);
            json.putOpt("language", (Object)this.language);
            return json;
        }
    }
}

