/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.iterable.iterableapi.IterableApiRequest;
import com.iterable.iterableapi.IterableApiResponse;
import com.iterable.iterableapi.IterableHelper;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableRequestTask;
import com.iterable.iterableapi.IterableTaskRunner;
import com.iterable.iterableapi.IterableTaskStorage;
import com.iterable.iterableapi.IterableTaskType;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

class TaskScheduler
implements IterableTaskRunner.TaskCompletedListener {
    static HashMap<String, IterableHelper.SuccessHandler> successCallbackMap = new HashMap();
    static HashMap<String, IterableHelper.FailureHandler> failureCallbackMap = new HashMap();
    private final IterableTaskStorage taskStorage;
    private final IterableTaskRunner taskRunner;

    TaskScheduler(IterableTaskStorage taskStorage, IterableTaskRunner taskRunner) {
        this.taskStorage = taskStorage;
        this.taskRunner = taskRunner;
        taskRunner.addTaskCompletedListener(this);
    }

    void scheduleTask(IterableApiRequest request, @Nullable IterableHelper.SuccessHandler onSuccess, @Nullable IterableHelper.FailureHandler onFailure) {
        JSONObject serializedRequest = null;
        try {
            serializedRequest = request.toJSONObject();
        }
        catch (JSONException e) {
            IterableLogger.e("RequestProcessor", "Failed serializing the request for offline execution. Attempting to request the request now...");
            new IterableRequestTask().execute(new IterableApiRequest[]{request});
            return;
        }
        String taskId = this.taskStorage.createTask(request.resourcePath, IterableTaskType.API, serializedRequest.toString());
        if (taskId == null) {
            new IterableRequestTask().execute(new IterableApiRequest[]{request});
            return;
        }
        successCallbackMap.put(taskId, onSuccess);
        failureCallbackMap.put(taskId, onFailure);
    }

    @Override
    @MainThread
    public void onTaskCompleted(String taskId, IterableTaskRunner.TaskResult result, IterableApiResponse response) {
        IterableHelper.SuccessHandler onSuccess = successCallbackMap.get(taskId);
        IterableHelper.FailureHandler onFailure = failureCallbackMap.get(taskId);
        successCallbackMap.remove(taskId);
        failureCallbackMap.remove(taskId);
        if (response.success) {
            if (onSuccess != null) {
                onSuccess.onSuccess(response.responseJson);
            }
        } else if (onFailure != null) {
            onFailure.onFailure(response.errorMessage, response.responseJson);
        }
    }
}

