/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.iterable.iterableapi.IterableApiRequest;
import com.iterable.iterableapi.IterableHelper;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableRequestTask;
import com.iterable.iterableapi.RequestProcessor;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

class OnlineRequestProcessor
implements RequestProcessor {
    private static final String TAG = "OnlineRequestProcessor";

    OnlineRequestProcessor() {
    }

    @Override
    public void processGetRequest(@Nullable String apiKey, @NonNull String resourcePath, @NonNull JSONObject json, String authToken, @Nullable IterableHelper.IterableActionHandler onCallback) {
        IterableApiRequest request = new IterableApiRequest(apiKey, resourcePath, this.addCreatedAtToJson(json), "GET", authToken, onCallback);
        new IterableRequestTask().execute(new IterableApiRequest[]{request});
    }

    @Override
    public void processPostRequest(@Nullable String apiKey, @NonNull String resourcePath, @NonNull JSONObject json, String authToken, @Nullable IterableHelper.SuccessHandler onSuccess, @Nullable IterableHelper.FailureHandler onFailure) {
        IterableApiRequest request = new IterableApiRequest(apiKey, resourcePath, this.addCreatedAtToJson(json), "POST", authToken, onSuccess, onFailure);
        new IterableRequestTask().execute(new IterableApiRequest[]{request});
    }

    @Override
    public void onLogout(Context context) {
    }

    JSONObject addCreatedAtToJson(JSONObject jsonObject) {
        try {
            jsonObject.put("createdAt", new Date().getTime() / 1000L);
        }
        catch (JSONException e) {
            IterableLogger.e(TAG, "Could not add createdAt timestamp to json object");
        }
        return jsonObject;
    }
}

