/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.iterable.iterableapi.HealthMonitor;
import com.iterable.iterableapi.IterableActivityMonitor;
import com.iterable.iterableapi.IterableApiRequest;
import com.iterable.iterableapi.IterableHelper;
import com.iterable.iterableapi.IterableNetworkConnectivityManager;
import com.iterable.iterableapi.IterableRequestTask;
import com.iterable.iterableapi.IterableTaskRunner;
import com.iterable.iterableapi.IterableTaskStorage;
import com.iterable.iterableapi.RequestProcessor;
import com.iterable.iterableapi.TaskScheduler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;

class OfflineRequestProcessor
implements RequestProcessor {
    private TaskScheduler taskScheduler;
    private IterableTaskRunner taskRunner;
    private IterableTaskStorage taskStorage;
    private HealthMonitor healthMonitor;
    private static final Set<String> offlineApiSet = new HashSet<String>(Arrays.asList("events/track", "events/trackPushOpen", "commerce/trackPurchase", "events/trackInAppOpen", "events/trackInAppClick", "events/trackInAppClose", "events/trackInboxSession", "events/trackInAppDelivery", "events/inAppConsume"));

    OfflineRequestProcessor(Context context) {
        IterableNetworkConnectivityManager networkConnectivityManager = IterableNetworkConnectivityManager.sharedInstance(context);
        this.taskStorage = IterableTaskStorage.sharedInstance(context);
        this.healthMonitor = new HealthMonitor(this.taskStorage);
        this.taskRunner = new IterableTaskRunner(this.taskStorage, IterableActivityMonitor.getInstance(), networkConnectivityManager, this.healthMonitor);
        this.taskScheduler = new TaskScheduler(this.taskStorage, this.taskRunner);
    }

    @VisibleForTesting
    OfflineRequestProcessor(TaskScheduler scheduler, IterableTaskRunner iterableTaskRunner, IterableTaskStorage storage, HealthMonitor mockHealthMonitor) {
        this.taskRunner = iterableTaskRunner;
        this.taskScheduler = scheduler;
        this.taskStorage = storage;
        this.healthMonitor = mockHealthMonitor;
    }

    @Override
    public void processGetRequest(@Nullable String apiKey, @NonNull String resourcePath, @NonNull JSONObject json, String authToken, @Nullable IterableHelper.IterableActionHandler onCallback) {
        IterableApiRequest request = new IterableApiRequest(apiKey, resourcePath, json, "GET", authToken, onCallback);
        new IterableRequestTask().execute(new IterableApiRequest[]{request});
    }

    @Override
    public void processPostRequest(@Nullable String apiKey, @NonNull String resourcePath, @NonNull JSONObject json, String authToken, @Nullable IterableHelper.SuccessHandler onSuccess, @Nullable IterableHelper.FailureHandler onFailure) {
        IterableApiRequest request = new IterableApiRequest(apiKey, resourcePath, json, "POST", authToken, onSuccess, onFailure);
        if (this.isRequestOfflineCompatible(request.resourcePath) && this.healthMonitor.canSchedule()) {
            request.setProcessorType(IterableApiRequest.ProcessorType.OFFLINE);
            this.taskScheduler.scheduleTask(request, onSuccess, onFailure);
        } else {
            new IterableRequestTask().execute(new IterableApiRequest[]{request});
        }
    }

    @Override
    public void onLogout(Context context) {
        this.taskStorage.deleteAllTasks();
    }

    boolean isRequestOfflineCompatible(String baseUrl) {
        return offlineApiSet.contains(baseUrl);
    }
}

