/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.iterable.iterableapi.IterableDatabaseManager;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableTask;
import com.iterable.iterableapi.IterableTaskType;
import java.util.ArrayList;
import java.util.Date;

class IterableTaskStorage {
    private static IterableTaskStorage sharedInstance;
    private static final String TAG = "IterableTaskStorage";
    static final String ITERABLE_TASK_TABLE_NAME = "OfflineTask";
    static final String TASK_ID = "task_id";
    static final String NAME = "name";
    static final String ATTEMPTS = "attempts";
    static final String TYPE = "type";
    static final String ERROR = "error";
    static final String DATA = "data";
    static final String BLOCKING = "blocking";
    static final String FAILED = "failed";
    static final String PROCESSING = "processing";
    static final String REQUESTED_AT = "requested";
    static final String SCHEDULED_AT = "scheduled";
    static final String LAST_ATTEMPTED_AT = "last_attempt";
    static final String MODIFIED_AT = "modified";
    static final String CREATED_AT = "created";
    static final String VERSION = "version";
    static final String OFFLINE_TASK_COLUMN_DATA = " (task_id TEXT PRIMARY KEY,name TEXT,version INTEGER,created BIGINT,modified BIGINT,last_attempt BIGINT,scheduled BIGINT,requested BIGINT,processing BOOLEAN,failed BOOLEAN,blocking BOOLEAN,data TEXT,error TEXT,type TEXT,attempts INTEGER)";
    private static final String QUERY_GET_TASK_BY_ID = "select * from OfflineTask where task_id = ?";
    private SQLiteDatabase database;
    private IterableDatabaseManager databaseManager;
    private ArrayList<TaskCreatedListener> taskCreatedListeners = new ArrayList();
    private ArrayList<IterableDatabaseStatusListeners> databaseStatusListeners = new ArrayList();

    private IterableTaskStorage(Context context) {
        try {
            if (context == null) {
                return;
            }
            if (this.databaseManager == null) {
                this.databaseManager = new IterableDatabaseManager(context);
            }
            this.database = this.databaseManager.getWritableDatabase();
        }
        catch (SQLException e) {
            IterableLogger.e(TAG, "Database cannot be opened for writing");
        }
    }

    static IterableTaskStorage sharedInstance(Context context) {
        if (sharedInstance == null) {
            sharedInstance = new IterableTaskStorage(context);
        }
        return sharedInstance;
    }

    void addTaskCreatedListener(TaskCreatedListener listener) {
        this.taskCreatedListeners.add(listener);
    }

    void removeDatabaseStatusListener(TaskCreatedListener listener) {
        this.taskCreatedListeners.remove(listener);
    }

    @Nullable
    String createTask(String name, IterableTaskType type, String data) {
        if (!this.isDatabaseReady()) {
            return null;
        }
        ContentValues contentValues = new ContentValues();
        final IterableTask iterableTask = new IterableTask(name, IterableTaskType.API, data);
        contentValues.put(TASK_ID, iterableTask.id);
        contentValues.put(NAME, iterableTask.name);
        contentValues.put(VERSION, Integer.valueOf(iterableTask.version));
        contentValues.put(CREATED_AT, Long.valueOf(iterableTask.createdAt));
        if (iterableTask.modifiedAt != 0L) {
            contentValues.put(MODIFIED_AT, Long.valueOf(iterableTask.modifiedAt));
        }
        if (iterableTask.lastAttemptedAt != 0L) {
            contentValues.put(LAST_ATTEMPTED_AT, Long.valueOf(iterableTask.lastAttemptedAt));
        }
        if (iterableTask.scheduledAt != 0L) {
            contentValues.put(SCHEDULED_AT, Long.valueOf(iterableTask.scheduledAt));
        }
        if (iterableTask.requestedAt != 0L) {
            contentValues.put(REQUESTED_AT, Long.valueOf(iterableTask.requestedAt));
        }
        contentValues.put(PROCESSING, Boolean.valueOf(iterableTask.processing));
        contentValues.put(FAILED, Boolean.valueOf(iterableTask.failed));
        contentValues.put(BLOCKING, Boolean.valueOf(iterableTask.blocking));
        if (iterableTask.data != null) {
            contentValues.put(DATA, iterableTask.data);
        }
        if (iterableTask.taskFailureData != null) {
            contentValues.put(ERROR, iterableTask.taskFailureData);
        }
        contentValues.put(TYPE, iterableTask.taskType.toString());
        contentValues.put(ATTEMPTS, Integer.valueOf(iterableTask.attempts));
        long rowId = this.database.insert(ITERABLE_TASK_TABLE_NAME, null, contentValues);
        if (rowId == -1L) {
            this.notifyDBError();
            return null;
        }
        contentValues.clear();
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                for (TaskCreatedListener listener : IterableTaskStorage.this.taskCreatedListeners) {
                    listener.onTaskCreated(iterableTask);
                }
            }
        });
        return iterableTask.id;
    }

    @Nullable
    IterableTask getTask(String id2) {
        if (!this.isDatabaseReady()) {
            return null;
        }
        Cursor cursor = this.database.rawQuery(QUERY_GET_TASK_BY_ID, new String[]{id2});
        if (!cursor.moveToFirst()) {
            IterableLogger.d(TAG, "No record found");
            return null;
        }
        IterableTask task = this.createTaskFromCursor(cursor);
        IterableLogger.v(TAG, "Found " + cursor.getColumnCount() + "columns");
        cursor.close();
        return task;
    }

    private IterableTask createTaskFromCursor(Cursor cursor) {
        IterableTaskType type = null;
        int version = 1;
        int attempts = 0;
        long dateCreated = 0L;
        long dateModified = 0L;
        long dateLastAttempted = 0L;
        long dateScheduled = 0L;
        long dateRequested = 0L;
        boolean processing = false;
        boolean failed = false;
        boolean blocking = false;
        String data = null;
        String error = null;
        String id2 = cursor.getString(cursor.getColumnIndex(TASK_ID));
        String name = cursor.getString(cursor.getColumnIndex(NAME));
        version = cursor.getInt(cursor.getColumnIndex(VERSION));
        dateCreated = cursor.getLong(cursor.getColumnIndex(CREATED_AT));
        if (!cursor.isNull(cursor.getColumnIndex(MODIFIED_AT))) {
            dateModified = cursor.getLong(cursor.getColumnIndex(MODIFIED_AT));
        }
        if (!cursor.isNull(cursor.getColumnIndex(LAST_ATTEMPTED_AT))) {
            dateLastAttempted = cursor.getLong(cursor.getColumnIndex(LAST_ATTEMPTED_AT));
        }
        if (!cursor.isNull(cursor.getColumnIndex(SCHEDULED_AT))) {
            dateScheduled = cursor.getLong(cursor.getColumnIndex(SCHEDULED_AT));
        }
        if (!cursor.isNull(cursor.getColumnIndex(REQUESTED_AT))) {
            dateRequested = cursor.getLong(cursor.getColumnIndex(REQUESTED_AT));
        }
        if (!cursor.isNull(cursor.getColumnIndex(PROCESSING))) {
            boolean bl = processing = cursor.getInt(cursor.getColumnIndex(PROCESSING)) > 0;
        }
        if (!cursor.isNull(cursor.getColumnIndex(FAILED))) {
            boolean bl = failed = cursor.getInt(cursor.getColumnIndex(FAILED)) > 0;
        }
        if (!cursor.isNull(cursor.getColumnIndex(BLOCKING))) {
            boolean bl = blocking = cursor.getInt(cursor.getColumnIndex(BLOCKING)) > 0;
        }
        if (!cursor.isNull(cursor.getColumnIndex(DATA))) {
            data = cursor.getString(cursor.getColumnIndex(DATA));
        }
        if (!cursor.isNull(cursor.getColumnIndex(ERROR))) {
            error = cursor.getString(cursor.getColumnIndex(ERROR));
        }
        if (!cursor.isNull(cursor.getColumnIndex(TYPE))) {
            type = IterableTaskType.valueOf(cursor.getString(cursor.getColumnIndex(TYPE)));
        }
        if (!cursor.isNull(cursor.getColumnIndex(ATTEMPTS))) {
            attempts = cursor.getInt(cursor.getColumnIndex(ATTEMPTS));
        }
        return new IterableTask(id2, name, version, dateCreated, dateModified, dateLastAttempted, dateScheduled, dateRequested, processing, failed, blocking, data, error, type, attempts);
    }

    @NonNull
    ArrayList<String> getAllTaskIds() {
        ArrayList<String> taskIds = new ArrayList<String>();
        if (!this.isDatabaseReady()) {
            return taskIds;
        }
        Cursor cursor = this.database.rawQuery("SELECT task_id FROM OfflineTask", null);
        if (cursor.moveToFirst()) {
            do {
                taskIds.add(cursor.getString(0));
            } while (cursor.moveToNext());
        }
        IterableLogger.v(TAG, "Found " + cursor.getColumnCount() + " columns");
        cursor.close();
        return taskIds;
    }

    long getNumberOfTasks() throws IllegalStateException {
        if (!this.isDatabaseReady()) {
            throw new IllegalStateException("Database is not ready");
        }
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)ITERABLE_TASK_TABLE_NAME);
    }

    @Nullable
    IterableTask getNextScheduledTask() {
        if (!this.isDatabaseReady()) {
            return null;
        }
        Cursor cursor = this.database.rawQuery("select * from OfflineTask order by scheduled limit 1", null);
        IterableTask task = null;
        if (cursor.moveToFirst()) {
            task = this.createTaskFromCursor(cursor);
        }
        cursor.close();
        return task;
    }

    void deleteAllTasks() {
        if (!this.isDatabaseReady()) {
            return;
        }
        int numberOfRowsDeleted = this.database.delete(ITERABLE_TASK_TABLE_NAME, null, null);
        IterableLogger.v(TAG, "Deleted " + numberOfRowsDeleted + " offline tasks");
    }

    boolean deleteTask(String id2) {
        if (!this.isDatabaseReady()) {
            return false;
        }
        int numberOfEntriesDeleted = this.database.delete(ITERABLE_TASK_TABLE_NAME, "task_id =?", new String[]{id2});
        IterableLogger.v(TAG, "Deleted entry - " + numberOfEntriesDeleted);
        return true;
    }

    boolean updateModifiedAt(String id2, Date date) {
        if (!this.isDatabaseReady()) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(MODIFIED_AT, date.toString());
        return this.updateTaskWithContentValues(id2, contentValues);
    }

    boolean updateLastAttemptedAt(String id2, Date date) {
        if (!this.isDatabaseReady()) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(LAST_ATTEMPTED_AT, date.toString());
        return this.updateTaskWithContentValues(id2, contentValues);
    }

    boolean updateRequestedAt(String id2, Date date) {
        if (!this.isDatabaseReady()) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(REQUESTED_AT, date.toString());
        return this.updateTaskWithContentValues(id2, contentValues);
    }

    boolean updateScheduledAt(String id2, Date date) {
        if (this.isDatabaseReady()) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(SCHEDULED_AT, date.toString());
        return this.updateTaskWithContentValues(id2, contentValues);
    }

    boolean updateIsProcessing(String id2, Boolean state) {
        if (!this.isDatabaseReady()) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(PROCESSING, state);
        return this.updateTaskWithContentValues(id2, contentValues);
    }

    boolean updateHasFailed(String id2, boolean state) {
        if (!this.isDatabaseReady()) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(FAILED, Boolean.valueOf(state));
        return this.updateTaskWithContentValues(id2, contentValues);
    }

    boolean incrementAttempts(String id2, int attempt) {
        if (!this.isDatabaseReady()) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(ATTEMPTS, Integer.valueOf(attempt));
        return this.updateTaskWithContentValues(id2, contentValues);
    }

    boolean incrementAttempts(String id2) {
        if (!this.isDatabaseReady()) {
            return false;
        }
        IterableTask task = this.getTask(id2);
        if (task == null) {
            IterableLogger.e(TAG, "No task found for id " + id2);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(ATTEMPTS, Integer.valueOf(task.attempts + 1));
        return this.updateTaskWithContentValues(id2, contentValues);
    }

    boolean updateError(String id2, String errorData) {
        if (!this.isDatabaseReady()) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(ERROR, errorData);
        return this.updateTaskWithContentValues(id2, contentValues);
    }

    boolean updateData(String id2, String data) {
        if (!this.isDatabaseReady()) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(DATA, data);
        return this.updateTaskWithContentValues(id2, contentValues);
    }

    private boolean updateTaskWithContentValues(String id2, ContentValues contentValues) {
        return 0 > this.database.update(ITERABLE_TASK_TABLE_NAME, contentValues, "task_id=?", new String[]{id2});
    }

    private boolean isDatabaseReady() {
        if (this.database == null || !this.database.isOpen()) {
            this.notifyDBError();
            IterableLogger.e(TAG, "Database not initialized or is closed");
            return false;
        }
        return true;
    }

    void addDatabaseStatusListener(IterableDatabaseStatusListeners listener) {
        if (this.isDatabaseReady()) {
            listener.isReady();
        } else {
            listener.onDBError();
        }
        this.databaseStatusListeners.add(listener);
    }

    void removeDatabaseStatusListener(IterableDatabaseStatusListeners listener) {
        this.databaseStatusListeners.remove(listener);
    }

    private void notifyDBError() {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                for (IterableDatabaseStatusListeners listener : IterableTaskStorage.this.databaseStatusListeners) {
                    listener.onDBError();
                }
            }
        });
    }

    public static interface IterableDatabaseStatusListeners {
        public void onDBError();

        public void isReady();
    }

    static interface TaskCreatedListener {
        public void onTaskCreated(IterableTask var1);
    }
}

