/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.iterable.iterableapi.HealthMonitor;
import com.iterable.iterableapi.IterableActivityMonitor;
import com.iterable.iterableapi.IterableApiRequest;
import com.iterable.iterableapi.IterableApiResponse;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableNetworkConnectivityManager;
import com.iterable.iterableapi.IterableRequestTask;
import com.iterable.iterableapi.IterableTask;
import com.iterable.iterableapi.IterableTaskStorage;
import com.iterable.iterableapi.IterableTaskType;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

class IterableTaskRunner
implements IterableTaskStorage.TaskCreatedListener,
Handler.Callback,
IterableNetworkConnectivityManager.IterableNetworkMonitorListener,
IterableActivityMonitor.AppStateCallback {
    private static final String TAG = "IterableTaskRunner";
    private IterableTaskStorage taskStorage;
    private IterableActivityMonitor activityMonitor;
    private IterableNetworkConnectivityManager networkConnectivityManager;
    private HealthMonitor healthMonitor;
    private static final int RETRY_INTERVAL_SECONDS = 60;
    private static final int OPERATION_PROCESS_TASKS = 100;
    private final HandlerThread networkThread = new HandlerThread("NetworkThread");
    Handler handler;
    private ArrayList<TaskCompletedListener> taskCompletedListeners = new ArrayList();

    IterableTaskRunner(IterableTaskStorage taskStorage, IterableActivityMonitor activityMonitor, IterableNetworkConnectivityManager networkConnectivityManager, HealthMonitor healthMonitor) {
        this.taskStorage = taskStorage;
        this.activityMonitor = activityMonitor;
        this.networkConnectivityManager = networkConnectivityManager;
        this.healthMonitor = healthMonitor;
        this.networkThread.start();
        this.handler = new Handler(this.networkThread.getLooper(), (Handler.Callback)this);
        taskStorage.addTaskCreatedListener(this);
        networkConnectivityManager.addNetworkListener(this);
        activityMonitor.addCallback(this);
    }

    void addTaskCompletedListener(TaskCompletedListener listener) {
        this.taskCompletedListeners.add(listener);
    }

    void removeTaskCompletedListener(TaskCompletedListener listener) {
        this.taskCompletedListeners.remove(listener);
    }

    @Override
    public void onTaskCreated(IterableTask iterableTask) {
        this.runNow();
    }

    @Override
    public void onNetworkConnected() {
        this.runNow();
    }

    @Override
    public void onNetworkDisconnected() {
    }

    @Override
    public void onSwitchToForeground() {
        this.runNow();
    }

    @Override
    public void onSwitchToBackground() {
    }

    private void runNow() {
        this.handler.removeMessages(100);
        this.handler.sendEmptyMessage(100);
    }

    private void scheduleRetry() {
        this.handler.removeCallbacksAndMessages((Object)100);
        this.handler.sendEmptyMessageDelayed(100, 60000L);
    }

    @WorkerThread
    public boolean handleMessage(@NonNull Message msg) {
        if (msg.what == 100) {
            this.processTasks();
            return true;
        }
        return false;
    }

    @WorkerThread
    private void processTasks() {
        if (!this.activityMonitor.isInForeground()) {
            IterableLogger.d(TAG, "App not in foreground, skipping processing tasks");
            return;
        }
        if (!this.healthMonitor.canProcess()) {
            return;
        }
        while (this.networkConnectivityManager.isConnected()) {
            IterableTask task = this.taskStorage.getNextScheduledTask();
            if (task == null) {
                return;
            }
            boolean proceed = this.processTask(task);
            if (proceed) continue;
            this.scheduleRetry();
            return;
        }
    }

    @WorkerThread
    private boolean processTask(@NonNull IterableTask task) {
        if (task.taskType == IterableTaskType.API) {
            IterableApiResponse response = null;
            TaskResult result = TaskResult.FAILURE;
            try {
                IterableApiRequest request = IterableApiRequest.fromJSON(this.getTaskDataWithDate(task), null, null);
                request.setProcessorType(IterableApiRequest.ProcessorType.OFFLINE);
                response = IterableRequestTask.executeApiRequest(request);
            }
            catch (Exception e) {
                IterableLogger.e(TAG, "Error while processing request task", e);
                this.healthMonitor.onDBError();
            }
            if (response != null) {
                result = response.success ? TaskResult.SUCCESS : (this.isRetriableError(response.errorMessage) ? TaskResult.RETRY : TaskResult.FAILURE);
            }
            this.callTaskCompletedListeners(task.id, result, response);
            if (result == TaskResult.RETRY) {
                return false;
            }
            this.taskStorage.deleteTask(task.id);
            return true;
        }
        return false;
    }

    JSONObject getTaskDataWithDate(IterableTask task) {
        try {
            JSONObject jsonData = new JSONObject(task.data);
            jsonData.getJSONObject("data").put("createdAt", task.createdAt / 1000L);
            return jsonData;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isRetriableError(String errorMessage) {
        return errorMessage.contains("failed to connect");
    }

    @WorkerThread
    private void callTaskCompletedListeners(final String taskId, final TaskResult result, final IterableApiResponse response) {
        for (final TaskCompletedListener listener : this.taskCompletedListeners) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    listener.onTaskCompleted(taskId, result, response);
                }
            });
        }
    }

    static enum TaskResult {
        SUCCESS,
        FAILURE,
        RETRY;

    }

    static interface TaskCompletedListener {
        @MainThread
        public void onTaskCompleted(String var1, TaskResult var2, IterableApiResponse var3);
    }
}

