/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import androidx.annotation.WorkerThread;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableApiRequest;
import com.iterable.iterableapi.IterableApiResponse;
import com.iterable.iterableapi.IterableLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class IterableRequestTask
extends AsyncTask<IterableApiRequest, Void, IterableApiResponse> {
    static final String TAG = "IterableRequest";
    static final String ITERABLE_BASE_URL = "https://api.iterable.com/api/";
    static String overrideUrl;
    static final int POST_REQUEST_DEFAULT_TIMEOUT_MS = 3000;
    static final int GET_REQUEST_DEFAULT_TIMEOUT_MS = 10000;
    static final long RETRY_DELAY_MS = 2000L;
    static final int MAX_RETRY_COUNT = 5;
    static final String ERROR_CODE_INVALID_JWT_PAYLOAD = "InvalidJwtPayload";
    int retryCount = 0;
    IterableApiRequest iterableApiRequest;

    IterableRequestTask() {
    }

    protected IterableApiResponse doInBackground(IterableApiRequest ... params) {
        if (params != null && params.length > 0) {
            this.iterableApiRequest = params[0];
        }
        return IterableRequestTask.executeApiRequest(this.iterableApiRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static IterableApiResponse executeApiRequest(IterableApiRequest iterableApiRequest) {
        IterableApiResponse apiResponse = null;
        String requestResult = null;
        if (iterableApiRequest != null) {
            HttpURLConnection urlConnection = null;
            IterableLogger.v(TAG, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
            String baseUrl = iterableApiRequest.baseUrl != null && !iterableApiRequest.baseUrl.isEmpty() ? iterableApiRequest.baseUrl : ITERABLE_BASE_URL;
            try {
                URL url;
                if (overrideUrl != null && !overrideUrl.isEmpty()) {
                    baseUrl = overrideUrl;
                }
                if (iterableApiRequest.requestType == "GET") {
                    Uri.Builder builder = Uri.parse((String)(baseUrl + iterableApiRequest.resourcePath)).buildUpon();
                    Iterator keys = iterableApiRequest.json.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        builder.appendQueryParameter(key, iterableApiRequest.json.getString(key));
                    }
                    url = new URL(builder.build().toString());
                    urlConnection = (HttpURLConnection)url.openConnection();
                    urlConnection.setReadTimeout(10000);
                    urlConnection.setConnectTimeout(10000);
                    urlConnection.setRequestProperty("Api-Key", iterableApiRequest.apiKey);
                    urlConnection.setRequestProperty("SDK-Platform", "Android");
                    urlConnection.setRequestProperty("SDK-Version", "3.4.0");
                    urlConnection.setRequestProperty("Sent-At", String.valueOf(new Date().getTime() / 1000L));
                    urlConnection.setRequestProperty("SDK-Request-Processor", iterableApiRequest.getProcessorType().toString());
                    if (iterableApiRequest.authToken != null) {
                        urlConnection.setRequestProperty("Authorization", "Bearer " + iterableApiRequest.authToken);
                    }
                    IterableLogger.v(TAG, "GET Request \nURI : " + baseUrl + iterableApiRequest.resourcePath + IterableRequestTask.buildHeaderString(urlConnection) + "\n body : \n" + iterableApiRequest.json.toString(2));
                } else {
                    url = new URL(baseUrl + iterableApiRequest.resourcePath);
                    urlConnection = (HttpURLConnection)url.openConnection();
                    urlConnection.setDoOutput(true);
                    urlConnection.setRequestMethod(iterableApiRequest.requestType);
                    urlConnection.setReadTimeout(3000);
                    urlConnection.setConnectTimeout(3000);
                    urlConnection.setRequestProperty("Accept", "application/json");
                    urlConnection.setRequestProperty("Content-Type", "application/json");
                    urlConnection.setRequestProperty("Api-Key", iterableApiRequest.apiKey);
                    urlConnection.setRequestProperty("SDK-Platform", "Android");
                    urlConnection.setRequestProperty("SDK-Version", "3.4.0");
                    urlConnection.setRequestProperty("Sent-At", String.valueOf(new Date().getTime() / 1000L));
                    urlConnection.setRequestProperty("SDK-Request-Processor", iterableApiRequest.getProcessorType().toString());
                    if (iterableApiRequest.authToken != null) {
                        urlConnection.setRequestProperty("Authorization", "Bearer " + iterableApiRequest.authToken);
                    }
                    IterableLogger.v(TAG, "POST Request \nURI : " + baseUrl + iterableApiRequest.resourcePath + IterableRequestTask.buildHeaderString(urlConnection) + "\n body : \n" + iterableApiRequest.json.toString(2));
                    OutputStream os = urlConnection.getOutputStream();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                    writer.write(iterableApiRequest.json.toString());
                    writer.close();
                    os.close();
                }
                IterableLogger.v(TAG, "======================================");
                int responseCode = urlConnection.getResponseCode();
                String error = null;
                try {
                    String inputLine;
                    BufferedReader in = responseCode < 400 ? new BufferedReader(new InputStreamReader(urlConnection.getInputStream())) : new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
                    StringBuffer response = new StringBuffer();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                    requestResult = response.toString();
                }
                catch (IOException e) {
                    IterableRequestTask.logError(iterableApiRequest, baseUrl, e);
                    error = e.getMessage();
                }
                JSONObject jsonResponse = null;
                String jsonError = null;
                try {
                    jsonResponse = new JSONObject(requestResult);
                    IterableLogger.v(TAG, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\nResponse from : " + baseUrl + iterableApiRequest.resourcePath);
                    IterableLogger.v(TAG, jsonResponse.toString(2));
                }
                catch (Exception e) {
                    IterableRequestTask.logError(iterableApiRequest, baseUrl, e);
                    jsonError = e.getMessage();
                }
                if (responseCode == 401) {
                    apiResponse = IterableRequestTask.matchesErrorCode(jsonResponse, ERROR_CODE_INVALID_JWT_PAYLOAD) ? IterableApiResponse.failure(responseCode, requestResult, jsonResponse, "JWT Authorization header error") : IterableApiResponse.failure(responseCode, requestResult, jsonResponse, "Invalid API Key");
                } else if (responseCode >= 400) {
                    String errorMessage = "Invalid Request";
                    if (jsonResponse != null && jsonResponse.has("msg")) {
                        errorMessage = jsonResponse.getString("msg");
                    } else if (responseCode >= 500) {
                        errorMessage = "Internal Server Error";
                    }
                    apiResponse = IterableApiResponse.failure(responseCode, requestResult, jsonResponse, errorMessage);
                } else if (responseCode == 200) {
                    if (error == null && requestResult.length() > 0) {
                        apiResponse = jsonError != null ? IterableApiResponse.failure(responseCode, requestResult, jsonResponse, "Could not parse json: " + jsonError) : (jsonResponse != null ? IterableApiResponse.success(responseCode, requestResult, jsonResponse) : IterableApiResponse.failure(responseCode, requestResult, jsonResponse, "Response is not a JSON object"));
                    } else if (error == null && requestResult.length() == 0) {
                        apiResponse = IterableApiResponse.failure(responseCode, requestResult, jsonResponse, "No data received");
                    } else if (error != null) {
                        apiResponse = IterableApiResponse.failure(responseCode, requestResult, jsonResponse, error);
                    }
                } else {
                    apiResponse = IterableApiResponse.failure(responseCode, requestResult, jsonResponse, "Received non-200 response: " + responseCode);
                }
            }
            catch (JSONException e) {
                IterableRequestTask.logError(iterableApiRequest, baseUrl, (Exception)((Object)e));
                apiResponse = IterableApiResponse.failure(0, requestResult, null, e.getMessage());
            }
            catch (IOException e) {
                IterableRequestTask.logError(iterableApiRequest, baseUrl, e);
                apiResponse = IterableApiResponse.failure(0, requestResult, null, e.getMessage());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                IterableRequestTask.logError(iterableApiRequest, baseUrl, e);
                apiResponse = IterableApiResponse.failure(0, requestResult, null, e.getMessage());
            }
            catch (Exception e) {
                IterableRequestTask.logError(iterableApiRequest, baseUrl, e);
                apiResponse = IterableApiResponse.failure(0, requestResult, null, e.getMessage());
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
            IterableLogger.v(TAG, "======================================");
        }
        return apiResponse;
    }

    private static boolean matchesErrorCode(JSONObject jsonResponse, String errorCode) {
        try {
            return jsonResponse != null && jsonResponse.has("code") && jsonResponse.getString("code").equals(errorCode);
        }
        catch (JSONException e) {
            return false;
        }
    }

    private static void logError(IterableApiRequest iterableApiRequest, String baseUrl, Exception e) {
        IterableLogger.e(TAG, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\nException occurred for : " + baseUrl + iterableApiRequest.resourcePath);
        IterableLogger.e(TAG, e.getMessage(), e);
    }

    private static String buildHeaderString(HttpURLConnection urlConnection) {
        StringBuilder headerString = new StringBuilder();
        headerString.append("\nHeaders { \n");
        for (String key : urlConnection.getRequestProperties().keySet()) {
            if (IterableRequestTask.isSensitive(key)) continue;
            headerString.append(key).append(" : ").append(urlConnection.getRequestProperties().get(key)).append("\n");
        }
        headerString.append("}");
        return headerString.toString();
    }

    private static boolean isSensitive(String key) {
        return key.equals("Api-Key") || key.equals("Authorization");
    }

    protected void onPostExecute(IterableApiResponse response) {
        boolean retryRequest;
        boolean bl = retryRequest = !response.success && response.responseCode >= 500;
        if (retryRequest && this.retryCount <= 5) {
            final IterableRequestTask requestTask = new IterableRequestTask();
            requestTask.setRetryCount(this.retryCount + 1);
            long delay = 0L;
            if (this.retryCount > 2) {
                delay = 2000L * (long)this.retryCount;
            }
            Handler handler = new Handler();
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    requestTask.execute(new IterableApiRequest[]{IterableRequestTask.this.iterableApiRequest});
                }
            }, delay);
            return;
        }
        if (response.success) {
            IterableApi.getInstance().getAuthManager().resetFailedAuth();
            if (this.iterableApiRequest.successCallback != null) {
                this.iterableApiRequest.successCallback.onSuccess(response.responseJson);
            }
        } else {
            if (IterableRequestTask.matchesErrorCode(response.responseJson, ERROR_CODE_INVALID_JWT_PAYLOAD)) {
                IterableApi.getInstance().getAuthManager().requestNewAuthToken(true);
            }
            if (this.iterableApiRequest.failureCallback != null) {
                this.iterableApiRequest.failureCallback.onFailure(response.errorMessage, response.responseJson);
            }
        }
        if (this.iterableApiRequest.legacyCallback != null) {
            this.iterableApiRequest.legacyCallback.execute(response.responseBody);
        }
        super.onPostExecute((Object)response);
    }

    protected void setRetryCount(int count) {
        this.retryCount = count;
    }
}

