/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.content.Context;
import android.os.AsyncTask;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableFirebaseMessagingService;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterablePushRegistrationData;

class IterablePushRegistrationTask
extends AsyncTask<IterablePushRegistrationData, Void, Void> {
    static final String TAG = "IterablePushRegistration";
    IterablePushRegistrationData iterablePushRegistrationData;

    IterablePushRegistrationTask() {
    }

    protected Void doInBackground(IterablePushRegistrationData ... params) {
        this.iterablePushRegistrationData = params[0];
        if (this.iterablePushRegistrationData.pushIntegrationName != null) {
            PushRegistrationObject pushRegistrationObject = this.getDeviceToken();
            if (pushRegistrationObject != null) {
                if (this.iterablePushRegistrationData.pushRegistrationAction == IterablePushRegistrationData.PushRegistrationAction.ENABLE) {
                    IterableApi.sharedInstance.registerDeviceToken(this.iterablePushRegistrationData.email, this.iterablePushRegistrationData.userId, this.iterablePushRegistrationData.authToken, this.iterablePushRegistrationData.pushIntegrationName, pushRegistrationObject.token, IterableApi.getInstance().getDeviceAttributes());
                } else if (this.iterablePushRegistrationData.pushRegistrationAction == IterablePushRegistrationData.PushRegistrationAction.DISABLE) {
                    IterableApi.sharedInstance.disableToken(this.iterablePushRegistrationData.email, this.iterablePushRegistrationData.userId, this.iterablePushRegistrationData.authToken, pushRegistrationObject.token, null, null);
                }
            }
        } else {
            IterableLogger.e("IterablePush", "iterablePushRegistrationData has not been specified");
        }
        return null;
    }

    PushRegistrationObject getDeviceToken() {
        try {
            Context applicationContext = IterableApi.sharedInstance.getMainActivityContext();
            if (applicationContext == null) {
                IterableLogger.e(TAG, "MainActivity Context is null");
                return null;
            }
            String senderId = Util.getSenderId(applicationContext);
            if (senderId == null) {
                IterableLogger.e(TAG, "Could not find gcm_defaultSenderId, please check that Firebase SDK is set up properly");
                return null;
            }
            return new PushRegistrationObject(Util.getFirebaseToken());
        }
        catch (Exception e) {
            IterableLogger.e(TAG, "Exception while retrieving the device token: check that firebase is added to the build dependencies", e);
            return null;
        }
    }

    static class PushRegistrationObject {
        String token;
        String messagingPlatform;

        PushRegistrationObject(String token) {
            this.token = token;
            this.messagingPlatform = "FCM";
        }
    }

    static class Util {
        static UtilImpl instance = new UtilImpl();

        Util() {
        }

        static String getFirebaseToken() {
            return instance.getFirebaseToken();
        }

        static String getSenderId(Context applicationContext) {
            return instance.getSenderId(applicationContext);
        }

        static class UtilImpl {
            UtilImpl() {
            }

            String getFirebaseToken() {
                return IterableFirebaseMessagingService.getFirebaseToken();
            }

            String getSenderId(Context applicationContext) {
                int resId = applicationContext.getResources().getIdentifier("gcm_defaultSenderId", "string", applicationContext.getPackageName());
                if (resId != 0) {
                    return applicationContext.getResources().getString(resId);
                }
                return null;
            }
        }
    }
}

