/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.core.app.RemoteInput;
import com.iterable.iterableapi.IterableAction;
import com.iterable.iterableapi.IterableActionRunner;
import com.iterable.iterableapi.IterableActionSource;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableNotificationData;
import com.iterable.iterableapi.IterableNotificationHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class IterablePushActionReceiver
extends BroadcastReceiver {
    private static final String TAG = "IterablePushActionReceiver";
    private static PendingAction pendingAction = null;

    public void onReceive(Context context, Intent intent) {
        int requestCode = intent.getIntExtra("requestCode", 0);
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        mNotificationManager.cancel(requestCode);
        try {
            context.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
        }
        catch (SecurityException e) {
            IterableLogger.w(TAG, e.getLocalizedMessage());
        }
        String actionName = intent.getAction();
        if ("com.iterable.push.ACTION_PUSH_ACTION".equalsIgnoreCase(actionName)) {
            IterablePushActionReceiver.handlePushAction(context, intent);
        }
    }

    static boolean processPendingAction(Context context) {
        boolean handled = false;
        if (pendingAction != null) {
            handled = IterablePushActionReceiver.executeAction(context, pendingAction);
            pendingAction = null;
        }
        return handled;
    }

    private static void handlePushAction(Context context, Intent intent) {
        if (intent.getExtras() == null) {
            IterableLogger.e(TAG, "handlePushAction: extras == null, can't handle push action");
            return;
        }
        IterableNotificationData notificationData = new IterableNotificationData(intent.getExtras());
        String actionIdentifier = intent.getStringExtra("actionIdentifier");
        IterableAction action = null;
        JSONObject dataFields = new JSONObject();
        boolean openApp = true;
        if (actionIdentifier != null) {
            try {
                if (actionIdentifier.equals("default")) {
                    dataFields.put("actionIdentifier", (Object)"default");
                    action = notificationData.getDefaultAction();
                    if (action == null) {
                        action = IterablePushActionReceiver.getLegacyDefaultActionFromPayload(intent.getExtras());
                    }
                } else {
                    String userInput;
                    Bundle results;
                    dataFields.put("actionIdentifier", (Object)actionIdentifier);
                    IterableNotificationData.Button button = notificationData.getActionButton(actionIdentifier);
                    action = button.action;
                    openApp = button.openApp;
                    if (button.buttonType.equals("textInput") && (results = RemoteInput.getResultsFromIntent((Intent)intent)) != null && (userInput = results.getString("userInput")) != null) {
                        dataFields.putOpt("userText", (Object)userInput);
                        action.userInput = userInput;
                    }
                }
            }
            catch (JSONException e) {
                IterableLogger.e(TAG, "Encountered an exception while trying to handle the push action", e);
            }
        }
        pendingAction = new PendingAction(intent, notificationData, action, openApp, dataFields);
        boolean handled = false;
        if (IterableApi.getInstance().getMainActivityContext() != null) {
            handled = IterablePushActionReceiver.processPendingAction(context);
        }
        if (openApp && !handled) {
            Intent launcherIntent = IterableNotificationHelper.getMainActivityIntent(context);
            launcherIntent.setFlags(0x34000000);
            if (launcherIntent.resolveActivity(context.getPackageManager()) != null) {
                context.startActivity(launcherIntent);
            }
        }
    }

    private static boolean executeAction(Context context, PendingAction action) {
        IterableApi.sharedInstance.setPayloadData(action.intent);
        IterableApi.sharedInstance.setNotificationData(action.notificationData);
        IterableApi.sharedInstance.trackPushOpen(action.notificationData.getCampaignId(), action.notificationData.getTemplateId(), action.notificationData.getMessageId(), action.dataFields);
        return IterableActionRunner.executeAction(context, action.iterableAction, IterableActionSource.PUSH);
    }

    private static IterableAction getLegacyDefaultActionFromPayload(Bundle extras) {
        try {
            if (extras.containsKey("uri")) {
                JSONObject actionJson = new JSONObject();
                actionJson.put("type", (Object)"openUrl");
                actionJson.put("data", (Object)extras.getString("uri"));
                return IterableAction.from(actionJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static class PendingAction {
        Intent intent;
        IterableNotificationData notificationData;
        IterableAction iterableAction;
        boolean openApp;
        JSONObject dataFields;

        PendingAction(Intent intent, IterableNotificationData notificationData, IterableAction iterableAction, boolean openApp, JSONObject dataFields) {
            this.intent = intent;
            this.notificationData = notificationData;
            this.iterableAction = iterableAction;
            this.openApp = openApp;
            this.dataFields = dataFields;
        }
    }
}

