/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableNotificationBuilder;
import com.iterable.iterableapi.IterableNotificationData;
import com.iterable.iterableapi.IterablePushActionReceiver;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class IterableNotificationHelper {
    private static final String DEFAULT_CHANNEL_NAME = "iterable channel";
    @VisibleForTesting
    static IterableNotificationHelperImpl instance = new IterableNotificationHelperImpl();

    IterableNotificationHelper() {
    }

    public static IterableNotificationBuilder createNotification(Context context, Bundle extras) {
        return instance.createNotification(context, extras);
    }

    public static void postNotificationOnDevice(Context context, IterableNotificationBuilder iterableNotificationBuilder) {
        instance.postNotificationOnDevice(context, iterableNotificationBuilder);
    }

    public static Intent getMainActivityIntent(Context context) {
        return instance.getMainActivityIntent(context);
    }

    static boolean isIterablePush(Bundle extras) {
        return instance.isIterablePush(extras);
    }

    static boolean isGhostPush(Bundle extras) {
        return instance.isGhostPush(extras);
    }

    static boolean isEmptyBody(Bundle extras) {
        return instance.isEmptyBody(extras);
    }

    static Bundle mapToBundle(Map<String, String> map) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    static class IterableNotificationHelperImpl {
        IterableNotificationHelperImpl() {
        }

        public IterableNotificationBuilder createNotification(Context context, Bundle extras) {
            Notification notifPermissions;
            IterableNotificationBuilder notificationBuilder;
            block18: {
                IterableNotificationData notificationData;
                String applicationName = context.getApplicationInfo().loadLabel(context.getPackageManager()).toString();
                String title = null;
                String notificationBody = null;
                String soundName = null;
                String messageId = null;
                String pushImage = null;
                String channelName = this.getChannelName(context);
                String channelId = context.getPackageName();
                String channelDescription = "";
                if (!extras.containsKey("itbl")) {
                    IterableLogger.w("IterableNotification", "Notification doesn't have an Iterable payload. Skipping.");
                    return null;
                }
                if (this.isGhostPush(extras)) {
                    IterableLogger.w("IterableNotification", "Received a ghost push notification. Skipping.");
                    return null;
                }
                this.registerChannelIfEmpty(context, channelId, channelName, channelDescription);
                notificationBuilder = new IterableNotificationBuilder(context, context.getPackageName());
                JSONObject iterableJson = null;
                title = extras.getString("title", applicationName);
                notificationBody = extras.getString("body");
                soundName = extras.getString("sound");
                String iterableData = extras.getString("itbl");
                try {
                    iterableJson = new JSONObject(iterableData);
                    if (iterableJson.has("attachment-url")) {
                        pushImage = iterableJson.getString("attachment-url");
                    }
                }
                catch (JSONException e) {
                    IterableLogger.w("IterableNotification", e.toString());
                }
                notificationBuilder.iterableNotificationData = notificationData = new IterableNotificationData(iterableData);
                messageId = notificationBuilder.iterableNotificationData.getMessageId();
                notifPermissions = new Notification();
                notifPermissions.defaults |= 4;
                notificationBuilder.setSmallIcon(this.getIconId(context)).setTicker((CharSequence)applicationName).setAutoCancel(true).setContentTitle((CharSequence)title).setPriority(1).setContentText((CharSequence)notificationBody);
                if (Build.VERSION.SDK_INT >= 17) {
                    notificationBuilder.setShowWhen(true);
                }
                notificationBuilder.setImageUrl(pushImage);
                notificationBuilder.setExpandedContent(notificationBody);
                if (soundName != null) {
                    String[] soundFile = soundName.split("\\.");
                    if (!(soundName = soundFile[0]).equalsIgnoreCase("default")) {
                        int soundID = context.getResources().getIdentifier(soundName, "raw", context.getPackageName());
                        Uri soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/" + soundID));
                        notificationBuilder.setSound(soundUri);
                    } else {
                        notifPermissions.defaults |= 1;
                    }
                } else {
                    notifPermissions.defaults |= 1;
                }
                notificationBuilder.requestCode = Math.abs((int)System.currentTimeMillis());
                IterableLogger.d("IterableNotification", "Request code = " + notificationBuilder.requestCode);
                if (messageId != null) {
                    notificationBuilder.requestCode = Math.abs(messageId.hashCode());
                    IterableLogger.d("IterableNotification", "Request code = " + notificationBuilder.requestCode);
                }
                Intent pushContentIntent = new Intent("com.iterable.push.ACTION_PUSH_ACTION");
                pushContentIntent.setClass(context, IterablePushActionReceiver.class);
                pushContentIntent.putExtras(extras);
                pushContentIntent.putExtra("actionIdentifier", "default");
                if (notificationData.getActionButtons() != null) {
                    int buttonCount = 0;
                    for (IterableNotificationData.Button button : notificationData.getActionButtons()) {
                        notificationBuilder.createNotificationActionButton(context, button, extras);
                        if (++buttonCount != 3) continue;
                        break;
                    }
                }
                PendingIntent notificationClickedIntent = PendingIntent.getBroadcast((Context)context, (int)notificationBuilder.requestCode, (Intent)pushContentIntent, (int)0x8000000);
                notificationBuilder.setContentIntent(notificationClickedIntent);
                notificationBuilder.setIsGhostPush(this.isGhostPush(extras));
                try {
                    ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                    if (info.metaData == null) break block18;
                    int color = info.metaData.getInt("iterable_notification_color");
                    try {
                        color = context.getResources().getColor(color);
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        // empty catch block
                    }
                    notificationBuilder.setColor(color);
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            }
            PackageManager pm = context.getPackageManager();
            if (pm.checkPermission("android.permission.VIBRATE", context.getPackageName()) == 0) {
                notifPermissions.defaults |= 2;
            }
            notificationBuilder.setDefaults(notifPermissions.defaults);
            return notificationBuilder;
        }

        public Intent getMainActivityIntent(Context context) {
            Context appContext = context.getApplicationContext();
            PackageManager packageManager = appContext.getPackageManager();
            Intent intent = packageManager.getLaunchIntentForPackage(appContext.getPackageName());
            if (intent == null) {
                intent = new Intent("android.intent.action.MAIN", null);
                intent.addCategory("android.intent.category.LAUNCHER");
                intent.setPackage(appContext.getPackageName());
            }
            return intent;
        }

        public void postNotificationOnDevice(Context context, IterableNotificationBuilder iterableNotificationBuilder) {
            if (!iterableNotificationBuilder.isGhostPush()) {
                NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
                mNotificationManager.notify(iterableNotificationBuilder.requestCode, iterableNotificationBuilder.build());
            }
        }

        private void registerChannelIfEmpty(Context context, String channelId, String channelName, String channelDescription) {
            NotificationChannel existingChannel;
            NotificationManager mNotificationManager = (NotificationManager)context.getApplicationContext().getSystemService("notification");
            if (!(Build.VERSION.SDK_INT < 26 || mNotificationManager == null || (existingChannel = mNotificationManager.getNotificationChannel(channelId)) != null && existingChannel.getName().equals(channelName))) {
                IterableLogger.d("IterableNotification", "Creating notification: channelId = " + channelId + " channelName = " + channelName + " channelDescription = " + channelDescription);
                mNotificationManager.createNotificationChannel(this.createNotificationChannel(channelId, channelName, channelDescription));
            }
        }

        private NotificationChannel createNotificationChannel(String channelId, String channelName, String channelDescription) {
            NotificationChannel notificationChannel = null;
            if (Build.VERSION.SDK_INT >= 26) {
                notificationChannel = new NotificationChannel(channelId, (CharSequence)channelName, 4);
                notificationChannel.setDescription(channelDescription);
                notificationChannel.enableLights(true);
            }
            return notificationChannel;
        }

        private String getChannelName(Context context) {
            String channelName = null;
            try {
                ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                if (info.metaData != null) {
                    int stringId;
                    Object channelNameMetaData = info.metaData.get("iterable_notification_channel_name");
                    if (channelNameMetaData instanceof String) {
                        channelName = (String)channelNameMetaData;
                    } else if (channelNameMetaData instanceof Integer && (stringId = ((Integer)channelNameMetaData).intValue()) != 0) {
                        channelName = context.getString(stringId);
                    }
                    IterableLogger.d("IterableNotification", "channel name: " + channelName);
                }
            }
            catch (Exception e) {
                IterableLogger.e("IterableNotification", "Error while retrieving channel name", e);
            }
            if (channelName != null) {
                return channelName;
            }
            return IterableNotificationHelper.DEFAULT_CHANNEL_NAME;
        }

        private int getIconId(Context context) {
            int iconId = 0;
            if (iconId == 0) {
                try {
                    ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                    if (info.metaData != null) {
                        iconId = info.metaData.getInt("iterable_notification_icon", 0);
                        IterableLogger.d("IterableNotification", "iconID: " + info.metaData.get("iterable_notification_icon"));
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (iconId == 0) {
                iconId = context.getResources().getIdentifier(IterableApi.getNotificationIcon(context), "drawable", context.getPackageName());
            }
            if (iconId == 0) {
                if (context.getApplicationInfo().icon != 0) {
                    IterableLogger.d("IterableNotification", "No Notification Icon defined - defaulting to app icon");
                    iconId = context.getApplicationInfo().icon;
                } else {
                    IterableLogger.w("IterableNotification", "No Notification Icon defined - push notifications will not be displayed");
                }
            }
            return iconId;
        }

        boolean isIterablePush(Bundle extras) {
            return extras != null && extras.containsKey("itbl");
        }

        boolean isGhostPush(Bundle extras) {
            boolean isGhostPush = false;
            if (extras.containsKey("itbl")) {
                String iterableData = extras.getString("itbl");
                IterableNotificationData data = new IterableNotificationData(iterableData);
                isGhostPush = data.getIsGhostPush();
            }
            return isGhostPush;
        }

        boolean isEmptyBody(Bundle extras) {
            String notificationBody = "";
            if (extras.containsKey("itbl")) {
                notificationBody = extras.getString("body", "");
            }
            return notificationBody.isEmpty();
        }
    }
}

