/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.iterable.iterableapi.IterableAction;
import com.iterable.iterableapi.IterableLogger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class IterableNotificationData {
    static final String TAG = "IterableNoticationData";
    private int campaignId;
    private int templateId;
    private String messageId;
    private boolean isGhostPush;
    private IterableAction defaultAction;
    private List<Button> actionButtons;

    IterableNotificationData(@Nullable String data) {
        try {
            JSONObject iterableJson = new JSONObject(data);
            this.campaignId = iterableJson.optInt("campaignId");
            this.templateId = iterableJson.optInt("templateId");
            this.messageId = iterableJson.optString("messageId");
            this.isGhostPush = iterableJson.optBoolean("isGhostPush");
            this.defaultAction = IterableAction.from(iterableJson.optJSONObject("defaultAction"));
            JSONArray actionButtonsJson = iterableJson.optJSONArray("actionButtons");
            if (actionButtonsJson != null) {
                this.actionButtons = new ArrayList<Button>();
                for (int i = 0; i < actionButtonsJson.length(); ++i) {
                    JSONObject button = actionButtonsJson.getJSONObject(i);
                    this.actionButtons.add(new Button(button));
                }
            }
        }
        catch (JSONException e) {
            IterableLogger.e(TAG, e.toString());
        }
    }

    IterableNotificationData(@NonNull Bundle extras) {
        this(extras.getString("itbl"));
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public boolean getIsGhostPush() {
        return this.isGhostPush;
    }

    @Nullable
    public IterableAction getDefaultAction() {
        return this.defaultAction;
    }

    @Nullable
    public List<Button> getActionButtons() {
        return this.actionButtons;
    }

    @Nullable
    public Button getActionButton(String actionIdentifier) {
        for (Button button : this.actionButtons) {
            if (!button.identifier.equals(actionIdentifier)) continue;
            return button;
        }
        return null;
    }

    public static class Button {
        public static final String BUTTON_TYPE_DEFAULT = "default";
        public static final String BUTTON_TYPE_DESTRUCTIVE = "destructive";
        public static final String BUTTON_TYPE_TEXT_INPUT = "textInput";
        public final String identifier;
        public final String title;
        public final String buttonType;
        public final boolean openApp;
        public final boolean requiresUnlock;
        public final int buttonIcon;
        public final String inputPlaceholder;
        public final String inputTitle;
        public final IterableAction action;

        Button(@NonNull JSONObject buttonData) {
            this.identifier = buttonData.optString("identifier");
            this.title = buttonData.optString("title");
            this.buttonType = buttonData.optString("buttonType", BUTTON_TYPE_DEFAULT);
            this.openApp = buttonData.optBoolean("openApp", true);
            this.requiresUnlock = buttonData.optBoolean("requiresUnlock", true);
            this.buttonIcon = buttonData.optInt("icon", 0);
            this.inputPlaceholder = buttonData.optString("inputPlaceholder");
            this.inputTitle = buttonData.optString("inputTitle");
            this.action = IterableAction.from(buttonData.optJSONObject("action"));
        }
    }
}

