/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import androidx.core.app.NotificationCompat;
import androidx.core.app.RemoteInput;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableNotificationData;
import com.iterable.iterableapi.IterableNotificationHelper;
import com.iterable.iterableapi.IterablePushActionReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class IterableNotificationBuilder
extends NotificationCompat.Builder {
    static final String TAG = "IterableNotification";
    final Context context;
    private boolean isGhostPush;
    private String imageUrl;
    private String expandedContent;
    int requestCode;
    IterableNotificationData iterableNotificationData;

    protected IterableNotificationBuilder(Context context, String channelId) {
        super(context, channelId);
        this.context = context;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setExpandedContent(String content) {
        this.expandedContent = content;
    }

    public void setIsGhostPush(boolean ghostPush) {
        this.isGhostPush = ghostPush;
    }

    public boolean isGhostPush() {
        return this.isGhostPush;
    }

    public Notification build() {
        NotificationCompat.BigTextStyle style2 = null;
        if (this.imageUrl != null) {
            try {
                URL url = new URL(this.imageUrl);
                URLConnection connection = url.openConnection();
                connection.setDoInput(true);
                connection.connect();
                Bitmap notificationImage = BitmapFactory.decodeStream((InputStream)connection.getInputStream());
                if (notificationImage != null) {
                    style2 = new NotificationCompat.BigPictureStyle().bigPicture(notificationImage).bigLargeIcon(null).setSummaryText((CharSequence)this.expandedContent);
                    this.setLargeIcon(notificationImage);
                } else {
                    IterableLogger.e(TAG, "Notification image could not be loaded from url: " + this.imageUrl);
                }
            }
            catch (MalformedURLException e) {
                IterableLogger.e(TAG, e.toString());
            }
            catch (IOException e) {
                IterableLogger.e(TAG, e.toString());
            }
        }
        if (style2 == null) {
            style2 = new NotificationCompat.BigTextStyle().bigText((CharSequence)this.expandedContent);
        }
        this.setStyle((NotificationCompat.Style)style2);
        return super.build();
    }

    public void createNotificationActionButton(Context context, IterableNotificationData.Button button, Bundle extras) {
        Intent buttonIntent = new Intent("com.iterable.push.ACTION_PUSH_ACTION");
        buttonIntent.setClass(context, IterablePushActionReceiver.class);
        buttonIntent.putExtras(extras);
        buttonIntent.putExtra("requestCode", this.requestCode);
        buttonIntent.putExtra("actionIdentifier", button.identifier);
        buttonIntent.putExtra("actionIdentifier", button.identifier);
        PendingIntent pendingButtonIntent = PendingIntent.getBroadcast((Context)context, (int)buttonIntent.hashCode(), (Intent)buttonIntent, (int)0x8000000);
        NotificationCompat.Action.Builder actionBuilder = new NotificationCompat.Action.Builder(0, (CharSequence)button.title, pendingButtonIntent);
        if (button.buttonType.equals("textInput")) {
            actionBuilder.addRemoteInput(new RemoteInput.Builder("userInput").setLabel((CharSequence)button.inputPlaceholder).build());
        }
        this.addAction(actionBuilder.build());
    }

    public static IterableNotificationBuilder createNotification(Context context, Bundle extras) {
        return IterableNotificationHelper.createNotification(context, extras);
    }

    public static void postNotificationOnDevice(Context context, IterableNotificationBuilder iterableNotificationBuilder) {
        IterableNotificationHelper.postNotificationOnDevice(context, iterableNotificationBuilder);
    }
}

