/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.iterable.iterableapi.IterableLogger;
import java.util.ArrayList;

class IterableNetworkConnectivityManager {
    private static final String TAG = "NetworkConnectivityManager";
    private boolean isConnected;
    private static IterableNetworkConnectivityManager sharedInstance;
    private ArrayList<IterableNetworkMonitorListener> networkMonitorListeners = new ArrayList();

    static IterableNetworkConnectivityManager sharedInstance(Context context) {
        if (sharedInstance == null) {
            sharedInstance = new IterableNetworkConnectivityManager(context);
        }
        return sharedInstance;
    }

    private IterableNetworkConnectivityManager(Context context) {
        if (context == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.startNetworkCallback(context);
        }
    }

    @RequiresApi(api=21)
    private void startNetworkCallback(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkRequest.Builder networkBuilder = new NetworkRequest.Builder();
        if (connectivityManager != null) {
            connectivityManager.registerNetworkCallback(networkBuilder.build(), new ConnectivityManager.NetworkCallback(){

                public void onAvailable(@NonNull Network network) {
                    super.onAvailable(network);
                    IterableLogger.v(IterableNetworkConnectivityManager.TAG, "Network Connected");
                    IterableNetworkConnectivityManager.this.isConnected = true;
                    ArrayList networkListenersCopy = new ArrayList(IterableNetworkConnectivityManager.this.networkMonitorListeners);
                    for (IterableNetworkMonitorListener listener : networkListenersCopy) {
                        listener.onNetworkConnected();
                    }
                }

                public void onLost(@NonNull Network network) {
                    super.onLost(network);
                    IterableLogger.v(IterableNetworkConnectivityManager.TAG, "Network Disconnected");
                    IterableNetworkConnectivityManager.this.isConnected = false;
                    ArrayList networkListenersCopy = new ArrayList(IterableNetworkConnectivityManager.this.networkMonitorListeners);
                    for (IterableNetworkMonitorListener listener : networkListenersCopy) {
                        listener.onNetworkDisconnected();
                    }
                }
            });
        }
    }

    synchronized void addNetworkListener(IterableNetworkMonitorListener listener) {
        this.networkMonitorListeners.add(listener);
    }

    synchronized void removeNetworkListener(IterableNetworkMonitorListener listener) {
        this.networkMonitorListeners.remove(listener);
    }

    boolean isConnected() {
        return this.isConnected;
    }

    public static interface IterableNetworkMonitorListener {
        public void onNetworkConnected();

        public void onNetworkDisconnected();
    }
}

