/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.ObjectsCompat;
import com.iterable.iterableapi.IterableInAppStorage;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableUtil;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class IterableInAppMessage {
    private static final String TAG = "IterableInAppMessage";
    @NonNull
    private final String messageId;
    @NonNull
    private final Content content;
    @NonNull
    private final JSONObject customPayload;
    @NonNull
    private final Date createdAt;
    @NonNull
    private final Date expiresAt;
    @NonNull
    private final Trigger trigger;
    @NonNull
    private final double priorityLevel;
    @Nullable
    private final Boolean saveToInbox;
    @Nullable
    private final InboxMetadata inboxMetadata;
    @Nullable
    private final Long campaignId;
    private boolean processed = false;
    private boolean consumed = false;
    private boolean read = false;
    private boolean loadedHtmlFromJson = false;
    private boolean markedForDeletion = false;
    @Nullable
    private IterableInAppStorage inAppStorageInterface;
    private OnChangeListener onChangeListener;

    IterableInAppMessage(@NonNull String messageId, @NonNull Content content, @NonNull JSONObject customPayload, @NonNull Date createdAt, @NonNull Date expiresAt, @NonNull Trigger trigger, @NonNull Double priorityLevel, @Nullable Boolean saveToInbox, @Nullable InboxMetadata inboxMetadata, @Nullable Long campaignId) {
        this.messageId = messageId;
        this.content = content;
        this.customPayload = customPayload;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
        this.trigger = trigger;
        this.priorityLevel = priorityLevel;
        this.saveToInbox = saveToInbox;
        this.inboxMetadata = inboxMetadata;
        this.campaignId = campaignId;
    }

    @NonNull
    public String getMessageId() {
        return this.messageId;
    }

    @Nullable
    public Long getCampaignId() {
        return this.campaignId;
    }

    @NonNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @NonNull
    public Date getExpiresAt() {
        return this.expiresAt;
    }

    @NonNull
    public Content getContent() {
        if (this.content.html == null) {
            this.content.html = this.inAppStorageInterface.getHTML(this.messageId);
        }
        return this.content;
    }

    @NonNull
    public JSONObject getCustomPayload() {
        return this.customPayload;
    }

    boolean isProcessed() {
        return this.processed;
    }

    void setProcessed(boolean processed) {
        this.processed = processed;
        this.onChanged();
    }

    boolean isConsumed() {
        return this.consumed;
    }

    void setConsumed(boolean consumed) {
        this.consumed = consumed;
        this.onChanged();
    }

    Trigger.TriggerType getTriggerType() {
        return this.trigger.type;
    }

    public double getPriorityLevel() {
        return this.priorityLevel;
    }

    public boolean isInboxMessage() {
        return this.saveToInbox != null ? this.saveToInbox : false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isSilentInboxMessage() {
        return this.isInboxMessage() && this.getTriggerType() == Trigger.TriggerType.NEVER;
    }

    @Nullable
    public InboxMetadata getInboxMetadata() {
        return this.inboxMetadata;
    }

    public boolean isRead() {
        return this.read;
    }

    void setRead(boolean read) {
        this.read = read;
        this.onChanged();
    }

    boolean hasLoadedHtmlFromJson() {
        return this.loadedHtmlFromJson;
    }

    void setLoadedHtmlFromJson(boolean loadedHtmlFromJson) {
        this.loadedHtmlFromJson = loadedHtmlFromJson;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public void markForDeletion(boolean delete) {
        this.markedForDeletion = delete;
    }

    static IterableInAppMessage fromJSONObject(@NonNull JSONObject messageJson, @Nullable IterableInAppStorage storageInterface) {
        if (messageJson == null) {
            return null;
        }
        JSONObject contentJson = messageJson.optJSONObject("content");
        if (contentJson == null) {
            return null;
        }
        String messageId = messageJson.optString("messageId");
        Long campaignId = IterableUtil.retrieveValidCampaignIdOrNull(messageJson, "campaignId");
        long createdAtLong = messageJson.optLong("createdAt");
        Date createdAt = createdAtLong != 0L ? new Date(createdAtLong) : null;
        long expiresAtLong = messageJson.optLong("expiresAt");
        Date expiresAt = expiresAtLong != 0L ? new Date(expiresAtLong) : null;
        String html = contentJson.optString("html", null);
        JSONObject inAppDisplaySettingsJson = contentJson.optJSONObject("inAppDisplaySettings");
        Rect padding = IterableInAppMessage.getPaddingFromPayload(inAppDisplaySettingsJson);
        double backgroundAlpha = contentJson.optDouble("backgroundAlpha", 0.0);
        boolean shouldAnimate = inAppDisplaySettingsJson.optBoolean("shouldAnimate", false);
        JSONObject bgColorJson = inAppDisplaySettingsJson.optJSONObject("bgColor");
        String bgColorInHex = null;
        double bgAlpha = 0.0;
        if (bgColorJson != null) {
            bgColorInHex = bgColorJson.optString("hex");
            bgAlpha = bgColorJson.optDouble("alpha");
        }
        InAppDisplaySettings inAppDisplaySettings = new InAppDisplaySettings(shouldAnimate, new InAppBgColor(bgColorInHex, bgAlpha));
        JSONObject triggerJson = messageJson.optJSONObject("trigger");
        Trigger trigger = Trigger.fromJSONObject(triggerJson);
        JSONObject customPayload = messageJson.optJSONObject("customPayload");
        if (customPayload == null) {
            customPayload = contentJson.optJSONObject("payload");
        }
        if (customPayload == null) {
            customPayload = new JSONObject();
        }
        double priorityLevel = messageJson.optDouble("priorityLevel", 300.5);
        Boolean saveToInbox = messageJson.has("saveToInbox") ? Boolean.valueOf(messageJson.optBoolean("saveToInbox")) : null;
        JSONObject inboxPayloadJson = messageJson.optJSONObject("inboxMetadata");
        InboxMetadata inboxMetadata = InboxMetadata.fromJSONObject(inboxPayloadJson);
        IterableInAppMessage message = new IterableInAppMessage(messageId, new Content(html, padding, backgroundAlpha, shouldAnimate, inAppDisplaySettings), customPayload, createdAt, expiresAt, trigger, priorityLevel, saveToInbox, inboxMetadata, campaignId);
        message.inAppStorageInterface = storageInterface;
        if (html != null) {
            message.setLoadedHtmlFromJson(true);
        }
        message.processed = messageJson.optBoolean("processed", false);
        message.consumed = messageJson.optBoolean("consumed", false);
        message.read = messageJson.optBoolean("read", false);
        return message;
    }

    @NonNull
    JSONObject toJSONObject() {
        JSONObject messageJson = new JSONObject();
        JSONObject contentJson = new JSONObject();
        try {
            messageJson.putOpt("messageId", (Object)this.messageId);
            if (this.campaignId != null && IterableUtil.isValidCampaignId(this.campaignId)) {
                messageJson.put("campaignId", (Object)this.campaignId);
            }
            if (this.createdAt != null) {
                messageJson.putOpt("createdAt", (Object)this.createdAt.getTime());
            }
            if (this.expiresAt != null) {
                messageJson.putOpt("expiresAt", (Object)this.expiresAt.getTime());
            }
            messageJson.putOpt("trigger", (Object)this.trigger.toJSONObject());
            messageJson.putOpt("priorityLevel", (Object)this.priorityLevel);
            JSONObject inAppDisplaySettingsJson = IterableInAppMessage.encodePaddingRectToJson(this.content.padding);
            inAppDisplaySettingsJson.put("shouldAnimate", this.content.inAppDisplaySettings.shouldAnimate);
            if (this.content.inAppDisplaySettings.inAppBgColor != null && this.content.inAppDisplaySettings.inAppBgColor.bgHexColor != null) {
                JSONObject bgColorJson = new JSONObject();
                bgColorJson.put("alpha", this.content.inAppDisplaySettings.inAppBgColor.bgAlpha);
                bgColorJson.putOpt("hex", (Object)this.content.inAppDisplaySettings.inAppBgColor.bgHexColor);
                inAppDisplaySettingsJson.put("bgColor", (Object)bgColorJson);
            }
            contentJson.putOpt("inAppDisplaySettings", (Object)inAppDisplaySettingsJson);
            if (this.content.backgroundAlpha != 0.0) {
                contentJson.putOpt("backgroundAlpha", (Object)this.content.backgroundAlpha);
            }
            messageJson.putOpt("content", (Object)contentJson);
            messageJson.putOpt("customPayload", (Object)this.customPayload);
            if (this.saveToInbox != null) {
                messageJson.putOpt("saveToInbox", (Object)this.saveToInbox);
            }
            if (this.inboxMetadata != null) {
                messageJson.putOpt("inboxMetadata", (Object)this.inboxMetadata.toJSONObject());
            }
            messageJson.putOpt("processed", (Object)this.processed);
            messageJson.putOpt("consumed", (Object)this.consumed);
            messageJson.putOpt("read", (Object)this.read);
        }
        catch (JSONException e) {
            IterableLogger.e(TAG, "Error while serializing an in-app message", e);
        }
        return messageJson;
    }

    void setOnChangeListener(OnChangeListener listener) {
        this.onChangeListener = listener;
    }

    private void onChanged() {
        if (this.onChangeListener != null) {
            this.onChangeListener.onInAppMessageChanged(this);
        }
    }

    static Rect getPaddingFromPayload(JSONObject paddingOptions) {
        Rect rect = new Rect();
        rect.top = IterableInAppMessage.decodePadding(paddingOptions.optJSONObject("top"));
        rect.left = IterableInAppMessage.decodePadding(paddingOptions.optJSONObject("left"));
        rect.bottom = IterableInAppMessage.decodePadding(paddingOptions.optJSONObject("bottom"));
        rect.right = IterableInAppMessage.decodePadding(paddingOptions.optJSONObject("right"));
        return rect;
    }

    static JSONObject encodePaddingRectToJson(Rect rect) throws JSONException {
        JSONObject paddingJson = new JSONObject();
        paddingJson.putOpt("top", (Object)IterableInAppMessage.encodePadding(rect.top));
        paddingJson.putOpt("left", (Object)IterableInAppMessage.encodePadding(rect.left));
        paddingJson.putOpt("bottom", (Object)IterableInAppMessage.encodePadding(rect.bottom));
        paddingJson.putOpt("right", (Object)IterableInAppMessage.encodePadding(rect.right));
        return paddingJson;
    }

    static int decodePadding(JSONObject jsonObject) {
        int returnPadding = 0;
        if (jsonObject != null) {
            returnPadding = "AutoExpand".equalsIgnoreCase(jsonObject.optString("displayOption")) ? -1 : jsonObject.optInt("percentage", 0);
        }
        return returnPadding;
    }

    static JSONObject encodePadding(int padding) throws JSONException {
        JSONObject paddingJson = new JSONObject();
        if (padding == -1) {
            paddingJson.putOpt("displayOption", (Object)"AutoExpand");
        } else {
            paddingJson.putOpt("percentage", (Object)padding);
        }
        return paddingJson;
    }

    public static class Content {
        public String html;
        public final Rect padding;
        public final double backgroundAlpha;
        public final InAppDisplaySettings inAppDisplaySettings;

        Content(String html, Rect padding, double backgroundAlpha, boolean shouldAnimate, InAppDisplaySettings inAppDisplaySettings) {
            this.html = html;
            this.padding = padding;
            this.backgroundAlpha = backgroundAlpha;
            this.inAppDisplaySettings = inAppDisplaySettings;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Content)) {
                return false;
            }
            Content content = (Content)obj;
            return ObjectsCompat.equals((Object)this.html, (Object)content.html) && ObjectsCompat.equals((Object)this.padding, (Object)content.padding) && this.backgroundAlpha == content.backgroundAlpha;
        }

        public int hashCode() {
            return ObjectsCompat.hash((Object[])new Object[]{this.html, this.padding, this.backgroundAlpha});
        }
    }

    static class Trigger {
        @Nullable
        final JSONObject triggerJson;
        @NonNull
        final TriggerType type;

        private Trigger(JSONObject triggerJson) {
            String typeString;
            this.triggerJson = triggerJson;
            switch (typeString = triggerJson.optString("type")) {
                case "immediate": {
                    this.type = TriggerType.IMMEDIATE;
                    break;
                }
                case "never": {
                    this.type = TriggerType.NEVER;
                    break;
                }
                default: {
                    this.type = TriggerType.NEVER;
                }
            }
        }

        Trigger(@NonNull TriggerType triggerType) {
            this.triggerJson = null;
            this.type = triggerType;
        }

        @NonNull
        static Trigger fromJSONObject(JSONObject triggerJson) {
            if (triggerJson == null) {
                return new Trigger(TriggerType.IMMEDIATE);
            }
            return new Trigger(triggerJson);
        }

        @Nullable
        JSONObject toJSONObject() {
            return this.triggerJson;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Trigger)) {
                return false;
            }
            Trigger trigger = (Trigger)obj;
            return ObjectsCompat.equals((Object)this.triggerJson, (Object)trigger.triggerJson);
        }

        public int hashCode() {
            return ObjectsCompat.hash((Object[])new Object[]{this.triggerJson});
        }

        static enum TriggerType {
            IMMEDIATE,
            EVENT,
            NEVER;

        }
    }

    public static class InboxMetadata {
        @Nullable
        public final String title;
        @Nullable
        public final String subtitle;
        @Nullable
        public final String icon;

        public InboxMetadata(@Nullable String title, @Nullable String subtitle, @Nullable String icon) {
            this.title = title;
            this.subtitle = subtitle;
            this.icon = icon;
        }

        @Nullable
        static InboxMetadata fromJSONObject(@Nullable JSONObject inboxMetadataJson) {
            if (inboxMetadataJson == null) {
                return null;
            }
            String title = inboxMetadataJson.optString("title");
            String subtitle = inboxMetadataJson.optString("subtitle");
            String icon = inboxMetadataJson.optString("icon");
            return new InboxMetadata(title, subtitle, icon);
        }

        @NonNull
        JSONObject toJSONObject() {
            JSONObject inboxMetadataJson = new JSONObject();
            try {
                inboxMetadataJson.putOpt("title", (Object)this.title);
                inboxMetadataJson.putOpt("subtitle", (Object)this.subtitle);
                inboxMetadataJson.putOpt("icon", (Object)this.icon);
            }
            catch (JSONException e) {
                IterableLogger.e(IterableInAppMessage.TAG, "Error while serializing inbox metadata", e);
            }
            return inboxMetadataJson;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof InboxMetadata)) {
                return false;
            }
            InboxMetadata inboxMetadata = (InboxMetadata)obj;
            return ObjectsCompat.equals((Object)this.title, (Object)inboxMetadata.title) && ObjectsCompat.equals((Object)this.subtitle, (Object)inboxMetadata.subtitle) && ObjectsCompat.equals((Object)this.icon, (Object)inboxMetadata.icon);
        }

        public int hashCode() {
            return ObjectsCompat.hash((Object[])new Object[]{this.title, this.subtitle, this.icon});
        }
    }

    public static class InAppDisplaySettings {
        boolean shouldAnimate;
        InAppBgColor inAppBgColor;

        public InAppDisplaySettings(boolean shouldAnimate, InAppBgColor inAppBgColor) {
            this.shouldAnimate = shouldAnimate;
            this.inAppBgColor = inAppBgColor;
        }
    }

    public static class InAppBgColor {
        String bgHexColor;
        double bgAlpha;

        public InAppBgColor(String bgHexColor, double bgAlpha) {
            this.bgHexColor = bgHexColor;
            this.bgAlpha = bgAlpha;
        }
    }

    static interface OnChangeListener {
        public void onInAppMessageChanged(IterableInAppMessage var1);
    }
}

