/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.iterable.iterableapi.IterableAction;
import com.iterable.iterableapi.IterableActionRunner;
import com.iterable.iterableapi.IterableActionSource;
import com.iterable.iterableapi.IterableActivityMonitor;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableHelper;
import com.iterable.iterableapi.IterableInAppDeleteActionType;
import com.iterable.iterableapi.IterableInAppDisplayer;
import com.iterable.iterableapi.IterableInAppFileStorage;
import com.iterable.iterableapi.IterableInAppHandler;
import com.iterable.iterableapi.IterableInAppLocation;
import com.iterable.iterableapi.IterableInAppMessage;
import com.iterable.iterableapi.IterableInAppStorage;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IterableInAppManager
implements IterableActivityMonitor.AppStateCallback {
    static final String TAG = "IterableInAppManager";
    static final long MOVE_TO_FOREGROUND_SYNC_INTERVAL_MS = 60000L;
    static final int MESSAGES_TO_FETCH = 100;
    private final IterableApi api;
    private final Context context;
    private final IterableInAppStorage storage;
    private final IterableInAppHandler handler;
    private final IterableInAppDisplayer displayer;
    private final IterableActivityMonitor activityMonitor;
    private final double inAppDisplayInterval;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private long lastSyncTime = 0L;
    private long lastInAppShown = 0L;
    private boolean autoDisplayPaused = false;

    IterableInAppManager(IterableApi iterableApi, IterableInAppHandler handler, double inAppDisplayInterval) {
        this(iterableApi, handler, inAppDisplayInterval, new IterableInAppFileStorage(iterableApi.getMainActivityContext()), IterableActivityMonitor.getInstance(), new IterableInAppDisplayer(IterableActivityMonitor.getInstance()));
    }

    @VisibleForTesting
    IterableInAppManager(IterableApi iterableApi, IterableInAppHandler handler, double inAppDisplayInterval, IterableInAppStorage storage, IterableActivityMonitor activityMonitor, IterableInAppDisplayer displayer) {
        this.api = iterableApi;
        this.context = iterableApi.getMainActivityContext();
        this.handler = handler;
        this.inAppDisplayInterval = inAppDisplayInterval;
        this.storage = storage;
        this.displayer = displayer;
        this.activityMonitor = activityMonitor;
        this.activityMonitor.addCallback(this);
        this.syncInApp();
    }

    @NonNull
    public synchronized List<IterableInAppMessage> getMessages() {
        ArrayList<IterableInAppMessage> filteredList = new ArrayList<IterableInAppMessage>();
        for (IterableInAppMessage message : this.storage.getMessages()) {
            if (message.isConsumed() || this.isMessageExpired(message)) continue;
            filteredList.add(message);
        }
        return filteredList;
    }

    synchronized IterableInAppMessage getMessageById(String messageId) {
        return this.storage.getMessage(messageId);
    }

    @NonNull
    public synchronized List<IterableInAppMessage> getInboxMessages() {
        ArrayList<IterableInAppMessage> filteredList = new ArrayList<IterableInAppMessage>();
        for (IterableInAppMessage message : this.storage.getMessages()) {
            if (message.isConsumed() || this.isMessageExpired(message) || !message.isInboxMessage()) continue;
            filteredList.add(message);
        }
        return filteredList;
    }

    public synchronized int getUnreadInboxMessagesCount() {
        int unreadInboxMessageCount = 0;
        for (IterableInAppMessage message : this.getInboxMessages()) {
            if (message.isRead()) continue;
            ++unreadInboxMessageCount;
        }
        return unreadInboxMessageCount;
    }

    public synchronized void setRead(@NonNull IterableInAppMessage message, boolean read) {
        message.setRead(read);
        this.notifyOnChange();
    }

    boolean isAutoDisplayPaused() {
        return this.autoDisplayPaused;
    }

    public void setAutoDisplayPaused(boolean paused) {
        this.autoDisplayPaused = paused;
        if (!paused) {
            this.scheduleProcessing();
        }
    }

    void syncInApp() {
        IterableLogger.printInfo();
        this.api.getInAppMessages(100, new IterableHelper.IterableActionHandler(){

            @Override
            public void execute(String payload) {
                if (payload != null && !payload.isEmpty()) {
                    try {
                        ArrayList<IterableInAppMessage> messages = new ArrayList<IterableInAppMessage>();
                        JSONObject mainObject = new JSONObject(payload);
                        JSONArray jsonArray = mainObject.optJSONArray("inAppMessages");
                        if (jsonArray != null) {
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                JSONObject messageJson = jsonArray.optJSONObject(i);
                                IterableInAppMessage message = IterableInAppMessage.fromJSONObject(messageJson, null);
                                if (message == null) continue;
                                messages.add(message);
                            }
                            IterableInAppManager.this.syncWithRemoteQueue(messages);
                            IterableInAppManager.this.lastSyncTime = IterableUtil.currentTimeMillis();
                        }
                    }
                    catch (JSONException e) {
                        IterableLogger.e(IterableInAppManager.TAG, e.toString());
                    }
                } else {
                    IterableInAppManager.this.scheduleProcessing();
                }
            }
        });
    }

    void reset() {
        IterableLogger.printInfo();
        for (IterableInAppMessage message : this.storage.getMessages()) {
            this.storage.removeMessage(message);
        }
        this.notifyOnChange();
    }

    public void showMessage(@NonNull IterableInAppMessage message) {
        this.showMessage(message, true, null);
    }

    public void showMessage(@NonNull IterableInAppMessage message, @NonNull IterableInAppLocation location) {
        this.showMessage(message, location == IterableInAppLocation.IN_APP, null, location);
    }

    public void showMessage(@NonNull IterableInAppMessage message, boolean consume, @Nullable IterableHelper.IterableUrlCallback clickCallback) {
        this.showMessage(message, consume, clickCallback, IterableInAppLocation.IN_APP);
    }

    public void showMessage(final @NonNull IterableInAppMessage message, boolean consume, final @Nullable IterableHelper.IterableUrlCallback clickCallback, @NonNull IterableInAppLocation inAppLocation) {
        if (this.displayer.showMessage(message, inAppLocation, new IterableHelper.IterableUrlCallback(){

            @Override
            public void execute(Uri url) {
                if (clickCallback != null) {
                    clickCallback.execute(url);
                }
                IterableInAppManager.this.handleInAppClick(message, url);
                IterableInAppManager.this.lastInAppShown = IterableUtil.currentTimeMillis();
                IterableInAppManager.this.scheduleProcessing();
            }
        })) {
            this.setRead(message, true);
            if (consume) {
                message.markForDeletion(true);
            }
        }
    }

    public synchronized void removeMessage(@NonNull IterableInAppMessage message) {
        message.setConsumed(true);
        this.api.inAppConsume(message.getMessageId());
        this.notifyOnChange();
    }

    public synchronized void removeMessage(@NonNull IterableInAppMessage message, @NonNull IterableInAppDeleteActionType source, @NonNull IterableInAppLocation clickLocation) {
        IterableLogger.printInfo();
        message.setConsumed(true);
        this.api.inAppConsume(message, source, clickLocation);
        this.notifyOnChange();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void handleInAppClick(@NonNull IterableInAppMessage message, @Nullable Uri url) {
        IterableLogger.printInfo();
        if (url != null && !url.toString().isEmpty()) {
            String urlString = url.toString();
            if (urlString.startsWith("action://")) {
                String actionName = urlString.replace("action://", "");
                IterableActionRunner.executeAction(this.context, IterableAction.actionCustomAction(actionName), IterableActionSource.IN_APP);
            } else if (urlString.startsWith("itbl://")) {
                String actionName = urlString.replace("itbl://", "");
                IterableActionRunner.executeAction(this.context, IterableAction.actionCustomAction(actionName), IterableActionSource.IN_APP);
            } else if (urlString.startsWith("iterable://")) {
                String actionName = urlString.replace("iterable://", "");
                this.handleIterableCustomAction(actionName, message);
            } else {
                IterableActionRunner.executeAction(this.context, IterableAction.actionOpenUrl(urlString), IterableActionSource.IN_APP);
            }
        }
    }

    synchronized void removeMessage(String messageId) {
        IterableInAppMessage message = this.storage.getMessage(messageId);
        if (message != null) {
            this.storage.removeMessage(message);
        }
        this.notifyOnChange();
    }

    private boolean isMessageExpired(IterableInAppMessage message) {
        if (message.getExpiresAt() != null) {
            return IterableUtil.currentTimeMillis() > message.getExpiresAt().getTime();
        }
        return false;
    }

    private void syncWithRemoteQueue(List<IterableInAppMessage> remoteQueue) {
        boolean changed = false;
        HashMap<String, IterableInAppMessage> remoteQueueMap = new HashMap<String, IterableInAppMessage>();
        for (IterableInAppMessage message : remoteQueue) {
            IterableInAppMessage localMessage;
            boolean shouldOverwriteInApp;
            boolean isInAppStored;
            remoteQueueMap.put(message.getMessageId(), message);
            boolean bl = isInAppStored = this.storage.getMessage(message.getMessageId()) != null;
            if (!isInAppStored) {
                this.storage.addMessage(message);
                this.onMessageAdded(message);
                changed = true;
            }
            if (!isInAppStored || !(shouldOverwriteInApp = !(localMessage = this.storage.getMessage(message.getMessageId())).isRead() && message.isRead())) continue;
            localMessage.setRead(message.isRead());
            changed = true;
        }
        for (IterableInAppMessage localMessage : this.storage.getMessages()) {
            if (remoteQueueMap.containsKey(localMessage.getMessageId())) continue;
            this.storage.removeMessage(localMessage);
            changed = true;
        }
        this.scheduleProcessing();
        if (changed) {
            this.notifyOnChange();
        }
    }

    private List<IterableInAppMessage> getMessagesSortedByPriorityLevel(List<IterableInAppMessage> messages) {
        List<IterableInAppMessage> messagesByPriorityLevel = messages;
        Collections.sort(messagesByPriorityLevel, new Comparator<IterableInAppMessage>(){

            @Override
            public int compare(IterableInAppMessage message1, IterableInAppMessage message2) {
                if (message1.getPriorityLevel() < message2.getPriorityLevel()) {
                    return -1;
                }
                if (message1.getPriorityLevel() == message2.getPriorityLevel()) {
                    return 0;
                }
                return 1;
            }
        });
        return messagesByPriorityLevel;
    }

    private void processMessages() {
        if (!this.activityMonitor.isInForeground() || this.isShowingInApp() || !this.canShowInAppAfterPrevious() || this.isAutoDisplayPaused()) {
            return;
        }
        IterableLogger.printInfo();
        List<IterableInAppMessage> messages = this.getMessages();
        List<IterableInAppMessage> messagesByPriorityLevel = this.getMessagesSortedByPriorityLevel(messages);
        for (IterableInAppMessage message : messagesByPriorityLevel) {
            if (message.isProcessed() || message.isConsumed() || message.getTriggerType() != IterableInAppMessage.Trigger.TriggerType.IMMEDIATE || message.isRead()) continue;
            IterableLogger.d(TAG, "Calling onNewInApp on " + message.getMessageId());
            IterableInAppHandler.InAppResponse response = this.handler.onNewInApp(message);
            IterableLogger.d(TAG, "Response: " + (Object)((Object)response));
            message.setProcessed(true);
            if (response != IterableInAppHandler.InAppResponse.SHOW) continue;
            boolean consume = !message.isInboxMessage();
            this.showMessage(message, consume, null);
            return;
        }
    }

    void scheduleProcessing() {
        IterableLogger.printInfo();
        if (this.canShowInAppAfterPrevious()) {
            this.processMessages();
        } else {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    IterableInAppManager.this.processMessages();
                }
            }, (long)((this.inAppDisplayInterval - this.getSecondsSinceLastInApp() + 2.0) * 1000.0));
        }
    }

    private void onMessageAdded(IterableInAppMessage message) {
        if (!message.isRead()) {
            this.api.trackInAppDelivery(message);
        }
    }

    private boolean isShowingInApp() {
        return this.displayer.isShowingInApp();
    }

    private double getSecondsSinceLastInApp() {
        return (double)(IterableUtil.currentTimeMillis() - this.lastInAppShown) / 1000.0;
    }

    private boolean canShowInAppAfterPrevious() {
        return this.getSecondsSinceLastInApp() >= this.inAppDisplayInterval;
    }

    private void handleIterableCustomAction(String actionName, IterableInAppMessage message) {
        if ("delete".equals(actionName)) {
            this.removeMessage(message, IterableInAppDeleteActionType.DELETE_BUTTON, IterableInAppLocation.IN_APP);
        }
    }

    @Override
    public void onSwitchToForeground() {
        if (IterableUtil.currentTimeMillis() - this.lastSyncTime > 60000L) {
            this.syncInApp();
        } else {
            this.scheduleProcessing();
        }
    }

    @Override
    public void onSwitchToBackground() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NonNull Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NonNull Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void notifyOnChange() {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = IterableInAppManager.this.listeners;
                synchronized (list) {
                    for (Listener listener : IterableInAppManager.this.listeners) {
                        listener.onInboxUpdated();
                    }
                }
            }
        });
    }

    public static interface Listener {
        public void onInboxUpdated();
    }
}

