/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.JavascriptInterface;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.ColorUtils;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.iterable.iterableapi.InAppLayout;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableHelper;
import com.iterable.iterableapi.IterableInAppCloseAction;
import com.iterable.iterableapi.IterableInAppLocation;
import com.iterable.iterableapi.IterableInAppMessage;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableWebView;
import com.iterable.iterableapi.IterableWebViewClient;
import com.iterable.iterableapi.R;

public class IterableInAppFragmentHTMLNotification
extends DialogFragment
implements IterableWebViewClient.HTMLNotificationCallbacks {
    private static final String BACK_BUTTON = "itbl://backButton";
    private static final String JAVASCRIPT_INTERFACE = "ITBL";
    private static final String TAG = "IterableInAppFragmentHTMLNotification";
    private static final String HTML_STRING = "HTML";
    private static final String BACKGROUND_ALPHA = "BackgroundAlpha";
    private static final String INSET_PADDING = "InsetPadding";
    private static final String CALLBACK_ON_CANCEL = "CallbackOnCancel";
    private static final String MESSAGE_ID = "MessageId";
    private static final String INAPP_OPEN_TRACKED = "InAppOpenTracked";
    private static final String INAPP_BGALPHA = "InAppBgAlpha";
    private static final String INAPP_BGCOLOR = "InAppBgColor";
    private static final String INAPP_SHOULD_ANIMATE = "ShouldAnimate";
    private static final int DELAY_THRESHOLD_MS = 500;
    @Nullable
    static IterableInAppFragmentHTMLNotification notification;
    @Nullable
    static IterableHelper.IterableUrlCallback clickCallback;
    @Nullable
    static IterableInAppLocation location;
    private IterableWebView webView;
    private boolean loaded = false;
    private OrientationEventListener orientationListener;
    private boolean callbackOnCancel = false;
    private String htmlString;
    private String messageId = "";
    private double backgroundAlpha = 0.0;
    private Rect insetPadding = new Rect();
    private boolean shouldAnimate;
    private double inAppBackgroundAlpha;
    private String inAppBackgroundColor;

    public static IterableInAppFragmentHTMLNotification createInstance(@NonNull String htmlString, boolean callbackOnCancel, @NonNull IterableHelper.IterableUrlCallback clickCallback, @NonNull IterableInAppLocation location, @NonNull String messageId, @NonNull Double backgroundAlpha, @NonNull Rect padding) {
        return IterableInAppFragmentHTMLNotification.createInstance(htmlString, callbackOnCancel, clickCallback, location, messageId, backgroundAlpha, padding, false, new IterableInAppMessage.InAppBgColor(null, 0.0));
    }

    public static IterableInAppFragmentHTMLNotification createInstance(@NonNull String htmlString, boolean callbackOnCancel, @NonNull IterableHelper.IterableUrlCallback clickCallback, @NonNull IterableInAppLocation location, @NonNull String messageId, @NonNull Double backgroundAlpha, @NonNull Rect padding, @NonNull boolean shouldAnimate, IterableInAppMessage.InAppBgColor inAppBgColor) {
        notification = new IterableInAppFragmentHTMLNotification();
        Bundle args = new Bundle();
        args.putString(HTML_STRING, htmlString);
        args.putBoolean(CALLBACK_ON_CANCEL, callbackOnCancel);
        args.putString(MESSAGE_ID, messageId);
        args.putDouble(BACKGROUND_ALPHA, backgroundAlpha.doubleValue());
        args.putParcelable(INSET_PADDING, (Parcelable)padding);
        args.putString(INAPP_BGCOLOR, inAppBgColor.bgHexColor);
        args.putDouble(INAPP_BGALPHA, inAppBgColor.bgAlpha);
        args.putBoolean(INAPP_SHOULD_ANIMATE, shouldAnimate);
        IterableInAppFragmentHTMLNotification.clickCallback = clickCallback;
        IterableInAppFragmentHTMLNotification.location = location;
        notification.setArguments(args);
        return notification;
    }

    public static IterableInAppFragmentHTMLNotification getInstance() {
        return notification;
    }

    public IterableInAppFragmentHTMLNotification() {
        this.setStyle(2, R.style.Theme_AppCompat_NoActionBar);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.htmlString = args.getString(HTML_STRING, null);
            this.callbackOnCancel = args.getBoolean(CALLBACK_ON_CANCEL, false);
            this.messageId = args.getString(MESSAGE_ID);
            this.backgroundAlpha = args.getDouble(BACKGROUND_ALPHA);
            this.insetPadding = (Rect)args.getParcelable(INSET_PADDING);
            this.inAppBackgroundAlpha = args.getDouble(INAPP_BGALPHA);
            this.inAppBackgroundColor = args.getString(INAPP_BGCOLOR, null);
            this.shouldAnimate = args.getBoolean(INAPP_SHOULD_ANIMATE);
        }
        notification = this;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = new Dialog((Context)this.getActivity(), this.getTheme()){

            public void onBackPressed() {
                IterableInAppFragmentHTMLNotification.this.onBackPressed();
                IterableInAppFragmentHTMLNotification.this.hideWebView();
            }
        };
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (IterableInAppFragmentHTMLNotification.this.callbackOnCancel && clickCallback != null) {
                    clickCallback.execute(null);
                }
            }
        });
        dialog.requestWindowFeature(1);
        if (this.getInAppLayout(this.insetPadding) == InAppLayout.FULLSCREEN) {
            dialog.getWindow().setFlags(1024, 1024);
        } else if (this.getInAppLayout(this.insetPadding) != InAppLayout.TOP) {
            dialog.getWindow().setFlags(0x4000000, 0x4000000);
        }
        return dialog;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        if (this.getInAppLayout(this.insetPadding) == InAppLayout.FULLSCREEN) {
            this.getDialog().getWindow().setFlags(1024, 1024);
        }
        this.webView = new IterableWebView(this.getContext());
        this.webView.setId(R.id.webView);
        this.webView.createWithHtml(this, this.htmlString);
        this.webView.addJavascriptInterface(this, JAVASCRIPT_INTERFACE);
        if (this.orientationListener == null) {
            this.orientationListener = new OrientationEventListener(this.getContext(), 3){

                public void onOrientationChanged(int orientation) {
                    if (IterableInAppFragmentHTMLNotification.this.loaded) {
                        Handler handler = new Handler();
                        handler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                IterableInAppFragmentHTMLNotification.this.webView.loadUrl("javascript:ITBL.resize(document.body.getBoundingClientRect().height)");
                            }
                        }, 1000L);
                    }
                }
            };
        }
        this.orientationListener.enable();
        RelativeLayout relativeLayout = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        relativeLayout.setVerticalGravity(this.getVerticalLocation(this.insetPadding));
        relativeLayout.addView((View)this.webView, (ViewGroup.LayoutParams)layoutParams);
        if (savedInstanceState == null || !savedInstanceState.getBoolean(INAPP_OPEN_TRACKED, false)) {
            IterableApi.sharedInstance.trackInAppOpen(this.messageId, location);
        }
        this.prepareToShowWebView();
        return relativeLayout;
    }

    @Override
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(INAPP_OPEN_TRACKED, true);
    }

    public void onStop() {
        this.orientationListener.disable();
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.getActivity() != null && this.getActivity().isChangingConfigurations()) {
            return;
        }
        notification = null;
        clickCallback = null;
        location = null;
    }

    @Override
    public void onUrlClicked(String url) {
        IterableApi.sharedInstance.trackInAppClick(this.messageId, url, location);
        IterableApi.sharedInstance.trackInAppClose(this.messageId, url, IterableInAppCloseAction.LINK, location);
        if (clickCallback != null) {
            clickCallback.execute(Uri.parse((String)url));
        }
        this.processMessageRemoval();
        this.hideWebView();
    }

    public void onBackPressed() {
        IterableApi.sharedInstance.trackInAppClick(this.messageId, BACK_BUTTON);
        IterableApi.sharedInstance.trackInAppClose(this.messageId, BACK_BUTTON, IterableInAppCloseAction.BACK, location);
        this.processMessageRemoval();
    }

    private void prepareToShowWebView() {
        try {
            this.webView.setAlpha(0.0f);
            this.webView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (IterableInAppFragmentHTMLNotification.this.getContext() != null && IterableInAppFragmentHTMLNotification.this.getDialog() != null && IterableInAppFragmentHTMLNotification.this.getDialog().getWindow() != null) {
                        IterableInAppFragmentHTMLNotification.this.showInAppBackground();
                        IterableInAppFragmentHTMLNotification.this.showAndAnimateWebView();
                    }
                }
            }, 500L);
        }
        catch (NullPointerException e) {
            IterableLogger.e(TAG, "View not present. Failed to hide before resizing inapp");
        }
    }

    private void showInAppBackground() {
        this.animateBackground((Drawable)new ColorDrawable(0), (Drawable)this.getInAppBackgroundDrawable());
    }

    private void hideInAppBackground() {
        this.animateBackground((Drawable)this.getInAppBackgroundDrawable(), (Drawable)new ColorDrawable(0));
    }

    private void animateBackground(Drawable from, Drawable to) {
        if (from == null || to == null) {
            return;
        }
        if (this.getDialog() == null || this.getDialog().getWindow() == null) {
            IterableLogger.e(TAG, "Dialog or Window not present. Skipping background animation");
            return;
        }
        Drawable[] layers = new Drawable[]{from, to};
        TransitionDrawable transitionDrawable = new TransitionDrawable(layers);
        transitionDrawable.setCrossFadeEnabled(true);
        this.getDialog().getWindow().setBackgroundDrawable((Drawable)transitionDrawable);
        transitionDrawable.startTransition(300);
    }

    private ColorDrawable getInAppBackgroundDrawable() {
        int backgroundColorWithAlpha;
        if (this.inAppBackgroundColor == null) {
            IterableLogger.d(TAG, "Background Color does not exist. In App background animation will not be performed");
            return null;
        }
        try {
            backgroundColorWithAlpha = ColorUtils.setAlphaComponent((int)Color.parseColor((String)this.inAppBackgroundColor), (int)((int)(this.inAppBackgroundAlpha * 255.0)));
        }
        catch (IllegalArgumentException e) {
            IterableLogger.e(TAG, "Background color could not be identified for input string \"" + this.inAppBackgroundColor + "\". Failed to load in-app background.");
            return null;
        }
        ColorDrawable backgroundColorDrawable = new ColorDrawable(backgroundColorWithAlpha);
        return backgroundColorDrawable;
    }

    private void showAndAnimateWebView() {
        this.webView.setAlpha(1.0f);
        this.webView.setVisibility(0);
        if (this.shouldAnimate) {
            int animationResource;
            InAppLayout inAppLayout = this.getInAppLayout(this.insetPadding);
            switch (inAppLayout) {
                case TOP: {
                    animationResource = R.anim.slide_down_custom;
                    break;
                }
                case CENTER: 
                case FULLSCREEN: {
                    animationResource = R.anim.fade_in_custom;
                    break;
                }
                case BOTTOM: {
                    animationResource = R.anim.slide_up_custom;
                    break;
                }
                default: {
                    animationResource = R.anim.fade_in_custom;
                }
            }
            Animation anim2 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)animationResource);
            anim2.setDuration(500L);
            this.webView.startAnimation(anim2);
        }
    }

    private void hideWebView() {
        if (this.shouldAnimate) {
            int animationResource;
            InAppLayout inAppLayout = this.getInAppLayout(this.insetPadding);
            switch (inAppLayout) {
                case TOP: {
                    animationResource = R.anim.top_exit;
                    break;
                }
                case CENTER: 
                case FULLSCREEN: {
                    animationResource = R.anim.fade_out_custom;
                    break;
                }
                case BOTTOM: {
                    animationResource = R.anim.bottom_exit;
                    break;
                }
                default: {
                    animationResource = R.anim.fade_out_custom;
                }
            }
            Animation anim2 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)animationResource);
            anim2.setDuration(500L);
            this.webView.startAnimation(anim2);
        }
        this.hideInAppBackground();
        Runnable dismissWebviewRunnable = new Runnable(){

            @Override
            public void run() {
                if (IterableInAppFragmentHTMLNotification.this.getContext() != null && IterableInAppFragmentHTMLNotification.this.getDialog() != null && IterableInAppFragmentHTMLNotification.this.getDialog().getWindow() != null) {
                    IterableInAppFragmentHTMLNotification.this.dismissAllowingStateLoss();
                }
            }
        };
        if (Build.VERSION.SDK_INT >= 16) {
            this.webView.postOnAnimationDelayed(dismissWebviewRunnable, 400L);
        } else {
            this.webView.postDelayed(dismissWebviewRunnable, 400L);
        }
    }

    private void processMessageRemoval() {
        IterableInAppMessage message = IterableApi.sharedInstance.getInAppManager().getMessageById(this.messageId);
        if (message == null) {
            IterableLogger.e(TAG, "Message with id " + this.messageId + " does not exist");
            return;
        }
        if (message.isMarkedForDeletion() && !message.isConsumed()) {
            IterableApi.sharedInstance.getInAppManager().removeMessage(message);
        }
    }

    @JavascriptInterface
    public void resize(float height) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        activity.runOnUiThread(new Runnable((Activity)activity, height){
            final /* synthetic */ Activity val$activity;
            final /* synthetic */ float val$height;
            {
                this.val$activity = activity;
                this.val$height = f;
            }

            @Override
            public void run() {
                try {
                    if (IterableInAppFragmentHTMLNotification.this.getContext() == null || notification == null || notification.getDialog() == null || notification.getDialog().getWindow() == null || !notification.getDialog().isShowing()) {
                        return;
                    }
                    DisplayMetrics displayMetrics = this.val$activity.getResources().getDisplayMetrics();
                    Window window = notification.getDialog().getWindow();
                    Rect insetPadding = notification.insetPadding;
                    WindowManager wm = (WindowManager)IterableInAppFragmentHTMLNotification.this.getContext().getSystemService("window");
                    Display display = wm.getDefaultDisplay();
                    Point size = new Point();
                    if (Build.VERSION.SDK_INT >= 17) {
                        display.getRealSize(size);
                    } else {
                        display.getSize(size);
                    }
                    int webViewWidth = size.x;
                    int webViewHeight = size.y;
                    if (insetPadding.bottom == 0 && insetPadding.top == 0) {
                        window.setLayout(webViewWidth, webViewHeight);
                        IterableInAppFragmentHTMLNotification.this.getDialog().getWindow().setFlags(1024, 1024);
                    } else {
                        RelativeLayout.LayoutParams webViewLayout = new RelativeLayout.LayoutParams(IterableInAppFragmentHTMLNotification.this.getResources().getDisplayMetrics().widthPixels, (int)(this.val$height * IterableInAppFragmentHTMLNotification.this.getResources().getDisplayMetrics().density));
                        IterableInAppFragmentHTMLNotification.this.webView.setLayoutParams((ViewGroup.LayoutParams)webViewLayout);
                    }
                }
                catch (IllegalArgumentException e) {
                    IterableLogger.e(IterableInAppFragmentHTMLNotification.TAG, "Exception while trying to resize an in-app message", e);
                }
            }
        });
    }

    int getVerticalLocation(Rect padding) {
        int gravity = 16;
        if (padding.top == 0 && padding.bottom < 0) {
            gravity = 48;
        } else if (padding.top < 0 && padding.bottom == 0) {
            gravity = 80;
        }
        return gravity;
    }

    InAppLayout getInAppLayout(Rect padding) {
        if (padding.top == 0 && padding.bottom == 0) {
            return InAppLayout.FULLSCREEN;
        }
        if (padding.top == 0 && padding.bottom < 0) {
            return InAppLayout.TOP;
        }
        if (padding.top < 0 && padding.bottom == 0) {
            return InAppLayout.BOTTOM;
        }
        return InAppLayout.CENTER;
    }
}

