/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.iterable.iterableapi.IterableInAppMessage;
import com.iterable.iterableapi.IterableInAppStorage;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IterableInAppFileStorage
implements IterableInAppStorage,
IterableInAppMessage.OnChangeListener {
    private static final String TAG = "IterableInAppFileStorage";
    private static final String FOLDER_PATH = "IterableInAppFileStorage";
    private static final String INDEX_FILE = "index.html";
    private static final int OPERATION_SAVE = 100;
    private final Context context;
    private Map<String, IterableInAppMessage> messages = Collections.synchronizedMap(new LinkedHashMap());
    private final HandlerThread fileOperationThread = new HandlerThread("FileOperationThread");
    @VisibleForTesting
    FileOperationHandler fileOperationHandler;

    IterableInAppFileStorage(Context context) {
        this.context = context;
        this.fileOperationThread.start();
        this.fileOperationHandler = new FileOperationHandler(this.fileOperationThread.getLooper());
        this.load();
    }

    @Override
    @NonNull
    public synchronized List<IterableInAppMessage> getMessages() {
        return new ArrayList<IterableInAppMessage>(this.messages.values());
    }

    @Override
    @Nullable
    public synchronized IterableInAppMessage getMessage(@NonNull String messageId) {
        return this.messages.get(messageId);
    }

    @Override
    public synchronized void addMessage(@NonNull IterableInAppMessage message) {
        this.messages.put(message.getMessageId(), message);
        message.setOnChangeListener(this);
        this.saveMessagesInBackground();
    }

    @Override
    public synchronized void removeMessage(@NonNull IterableInAppMessage message) {
        message.setOnChangeListener(null);
        this.removeHTML(message.getMessageId());
        this.messages.remove(message.getMessageId());
        this.saveMessagesInBackground();
    }

    @Override
    public void onInAppMessageChanged(@NonNull IterableInAppMessage message) {
        this.saveMessagesInBackground();
    }

    private synchronized void clearMessages() {
        for (Map.Entry<String, IterableInAppMessage> entry : this.messages.entrySet()) {
            IterableInAppMessage message = entry.getValue();
            message.setOnChangeListener(null);
        }
        this.messages.clear();
    }

    @NonNull
    private JSONObject serializeMessages() {
        JSONObject jsonData = new JSONObject();
        JSONArray messagesJson = new JSONArray();
        try {
            for (Map.Entry<String, IterableInAppMessage> entry : this.messages.entrySet()) {
                IterableInAppMessage message = entry.getValue();
                messagesJson.put((Object)message.toJSONObject());
            }
            jsonData.putOpt("inAppMessages", (Object)messagesJson);
        }
        catch (JSONException e) {
            IterableLogger.e("IterableInAppFileStorage", "Error while serializing messages", e);
        }
        return jsonData;
    }

    private void loadMessagesFromJson(JSONObject jsonData) {
        this.clearMessages();
        JSONArray messagesJson = jsonData.optJSONArray("inAppMessages");
        if (messagesJson != null) {
            for (int i = 0; i < messagesJson.length(); ++i) {
                IterableInAppMessage message;
                JSONObject messageJson = messagesJson.optJSONObject(i);
                if (messageJson == null || (message = IterableInAppMessage.fromJSONObject(messageJson, this)) == null) continue;
                message.setOnChangeListener(this);
                this.messages.put(message.getMessageId(), message);
            }
        }
    }

    private File getInAppStorageFile() {
        return new File(this.getInAppContentFolder(), "itbl_inapp.json");
    }

    private File getInAppCacheStorageFile() {
        return new File(IterableUtil.getSdkCacheDir(this.context), "itbl_inapp.json");
    }

    private void load() {
        try {
            File inAppStorageFile = this.getInAppStorageFile();
            if (inAppStorageFile.exists()) {
                JSONObject jsonData = new JSONObject(IterableUtil.readFile(inAppStorageFile));
                this.loadMessagesFromJson(jsonData);
            } else if (this.getInAppCacheStorageFile().exists()) {
                JSONObject jsonData = new JSONObject(IterableUtil.readFile(this.getInAppCacheStorageFile()));
                this.loadMessagesFromJson(jsonData);
            }
        }
        catch (Exception e) {
            IterableLogger.e("IterableInAppFileStorage", "Error while loading in-app messages from file", e);
        }
    }

    private void saveMessagesInBackground() {
        if (!this.fileOperationHandler.hasMessages(100)) {
            this.fileOperationHandler.sendEmptyMessageDelayed(100, 100L);
        }
    }

    private synchronized void saveMessages() {
        this.saveHTMLContent();
        this.saveMetadata();
    }

    private synchronized void saveHTMLContent() {
        for (IterableInAppMessage message : this.messages.values()) {
            if (!message.hasLoadedHtmlFromJson()) continue;
            this.saveHTML(message.getMessageId(), message.getContent().html);
            message.setLoadedHtmlFromJson(false);
        }
    }

    private synchronized void saveMetadata() {
        try {
            File inAppStorageFile = this.getInAppStorageFile();
            JSONObject jsonData = this.serializeMessages();
            IterableUtil.writeFile(inAppStorageFile, jsonData.toString());
        }
        catch (Exception e) {
            IterableLogger.e("IterableInAppFileStorage", "Error while saving in-app messages to file", e);
        }
    }

    @Override
    public void saveHTML(@NonNull String messageID, @NonNull String contentHTML) {
        File folder = this.createFolderForMessage(messageID);
        if (folder == null) {
            IterableLogger.e("IterableInAppFileStorage", "Failed to create folder for HTML content");
            return;
        }
        File file = new File(folder, INDEX_FILE);
        boolean result = IterableUtil.writeFile(file, contentHTML);
        if (!result) {
            IterableLogger.e("IterableInAppFileStorage", "Failed to store HTML content");
        }
    }

    @Nullable
    private File createFolderForMessage(String messageID) {
        File folder = this.getFolderForMessage(messageID);
        if (folder.isDirectory() && new File(folder, INDEX_FILE).exists()) {
            IterableLogger.v("IterableInAppFileStorage", "Directory with file already exists. No need to store again");
            return null;
        }
        boolean result = folder.mkdir();
        if (result) {
            return folder;
        }
        return null;
    }

    private File getInAppContentFolder() {
        File sdkFilesDirectory = IterableUtil.getSDKFilesDirectory(this.context);
        return IterableUtil.getDirectory(sdkFilesDirectory, "IterableInAppFileStorage");
    }

    @NonNull
    private File getFolderForMessage(String messageID) {
        return new File(this.getInAppContentFolder(), messageID);
    }

    @NonNull
    private File getFileForContent(String messageID) {
        File folder = this.getFolderForMessage(messageID);
        return new File(folder, INDEX_FILE);
    }

    @Override
    @Nullable
    public String getHTML(@NonNull String messageID) {
        File file = this.getFileForContent(messageID);
        return IterableUtil.readFile(file);
    }

    @Override
    public void removeHTML(@NonNull String messageID) {
        File folder = this.getFolderForMessage(messageID);
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            file.delete();
        }
        folder.delete();
    }

    class FileOperationHandler
    extends Handler {
        FileOperationHandler(Looper threadLooper) {
            super(threadLooper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 100) {
                IterableInAppFileStorage.this.saveMessages();
            }
        }
    }
}

