/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableNotificationBuilder;
import com.iterable.iterableapi.IterableNotificationHelper;
import com.iterable.iterableapi.IterableNotificationManager;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class IterableFirebaseMessagingService
extends FirebaseMessagingService {
    static final String TAG = "itblFCMMessagingService";

    public void onMessageReceived(RemoteMessage remoteMessage) {
        IterableFirebaseMessagingService.handleMessageReceived((Context)this, remoteMessage);
    }

    public void onNewToken(String s) {
        IterableFirebaseMessagingService.handleTokenRefresh();
    }

    public static boolean handleMessageReceived(@NonNull Context context, @NonNull RemoteMessage remoteMessage) {
        Bundle extras;
        Map messageData = remoteMessage.getData();
        if (messageData == null || messageData.size() == 0) {
            return false;
        }
        IterableLogger.d(TAG, "Message data payload: " + remoteMessage.getData());
        if (remoteMessage.getNotification() != null) {
            IterableLogger.d(TAG, "Message Notification Body: " + remoteMessage.getNotification().getBody());
        }
        if (!IterableNotificationHelper.isIterablePush(extras = IterableNotificationHelper.mapToBundle(messageData))) {
            IterableLogger.d(TAG, "Not an Iterable push message");
            return false;
        }
        if (!IterableNotificationHelper.isGhostPush(extras)) {
            if (!IterableNotificationHelper.isEmptyBody(extras)) {
                IterableLogger.d(TAG, "Iterable push received " + messageData);
                IterableNotificationBuilder notificationBuilder = IterableNotificationHelper.createNotification(context.getApplicationContext(), extras);
                new IterableNotificationManager().execute((Object[])new IterableNotificationBuilder[]{notificationBuilder});
            } else {
                IterableLogger.d(TAG, "Iterable OS notification push received");
            }
        } else {
            IterableLogger.d(TAG, "Iterable ghost silent push received");
            String notificationType = extras.getString("notificationType");
            if (notificationType != null && IterableApi.getInstance().getMainActivityContext() != null) {
                String messageId;
                if (notificationType.equals("InAppUpdate")) {
                    IterableApi.getInstance().getInAppManager().syncInApp();
                } else if (notificationType.equals("InAppRemove") && (messageId = extras.getString("messageId")) != null) {
                    IterableApi.getInstance().getInAppManager().removeMessage(messageId);
                }
            }
        }
        return true;
    }

    public static void handleTokenRefresh() {
        String registrationToken = IterableFirebaseMessagingService.getFirebaseToken();
        IterableLogger.d(TAG, "New Firebase Token generated: " + registrationToken);
        IterableApi.getInstance().registerForPush();
    }

    public static String getFirebaseToken() {
        String registrationToken = null;
        try {
            registrationToken = (String)Tasks.await((Task)FirebaseMessaging.getInstance().getToken());
        }
        catch (ExecutionException e) {
            IterableLogger.e(TAG, e.getLocalizedMessage());
        }
        catch (InterruptedException e) {
            IterableLogger.e(TAG, e.getLocalizedMessage());
        }
        catch (Exception e) {
            IterableLogger.e(TAG, "Failed to fetch firebase token");
        }
        return registrationToken;
    }

    public static boolean isGhostPush(RemoteMessage remoteMessage) {
        Map messageData = remoteMessage.getData();
        if (messageData == null || messageData.isEmpty()) {
            return false;
        }
        Bundle extras = IterableNotificationHelper.mapToBundle(messageData);
        return IterableNotificationHelper.isGhostPush(extras);
    }
}

