/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.os.AsyncTask;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableAttributionInfo;
import com.iterable.iterableapi.IterableHelper;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableUtil;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class IterableDeeplinkManager {
    private static Pattern deeplinkPattern = Pattern.compile("/a/[A-Za-z0-9]+");

    IterableDeeplinkManager() {
    }

    static void getAndTrackDeeplink(@Nullable String url, @NonNull IterableHelper.IterableActionHandler callback) {
        if (url != null) {
            if (!IterableUtil.isUrlOpenAllowed(url)) {
                return;
            }
            if (IterableDeeplinkManager.isIterableDeeplink(url)) {
                new RedirectTask(callback).execute(new String[]{url});
            } else {
                callback.execute(url);
            }
        } else {
            callback.execute(null);
        }
    }

    static boolean isIterableDeeplink(@Nullable String url) {
        Matcher m;
        return url != null && (m = deeplinkPattern.matcher(url)).find();
    }

    private static class RedirectTask
    extends AsyncTask<String, Void, String> {
        static final String TAG = "RedirectTask";
        static final int DEFAULT_TIMEOUT_MS = 3000;
        private IterableHelper.IterableActionHandler callback;
        public int campaignId;
        public int templateId;
        public String messageId;

        RedirectTask(IterableHelper.IterableActionHandler callback) {
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String doInBackground(String ... params) {
            String urlString;
            block15: {
                if (params == null || params.length == 0) {
                    return null;
                }
                urlString = params[0];
                HttpURLConnection urlConnection = null;
                try {
                    URL url = new URL(urlString);
                    urlConnection = (HttpURLConnection)url.openConnection();
                    urlConnection.setReadTimeout(3000);
                    urlConnection.setInstanceFollowRedirects(false);
                    int responseCode = urlConnection.getResponseCode();
                    if (responseCode >= 400) {
                        IterableLogger.d(TAG, "Invalid Request for: " + urlString + ", returned code " + responseCode);
                        break block15;
                    }
                    if (responseCode < 300) break block15;
                    urlString = urlConnection.getHeaderField("Location");
                    try {
                        List<String> cookieHeaders = urlConnection.getHeaderFields().get("Set-Cookie");
                        if (cookieHeaders != null) {
                            ArrayList<HttpCookie> httpCookies = new ArrayList<HttpCookie>(cookieHeaders.size());
                            for (String cookieString : cookieHeaders) {
                                List<HttpCookie> cookies = HttpCookie.parse(cookieString);
                                if (cookies == null) continue;
                                httpCookies.addAll(cookies);
                            }
                            for (HttpCookie cookie : httpCookies) {
                                if (cookie.getName().equals("iterableEmailCampaignId")) {
                                    this.campaignId = Integer.parseInt(cookie.getValue());
                                    continue;
                                }
                                if (cookie.getName().equals("iterableTemplateId")) {
                                    this.templateId = Integer.parseInt(cookie.getValue());
                                    continue;
                                }
                                if (!cookie.getName().equals("iterableMessageId")) continue;
                                this.messageId = cookie.getValue();
                            }
                        }
                    }
                    catch (Exception e) {
                        IterableLogger.e(TAG, "Error while parsing cookies: " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    IterableLogger.e(TAG, e.getMessage());
                }
                finally {
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                }
            }
            return urlString;
        }

        protected void onPostExecute(String s) {
            if (this.callback != null) {
                this.callback.execute(s);
            }
            if (this.campaignId != 0) {
                IterableAttributionInfo attributionInfo = new IterableAttributionInfo(this.campaignId, this.templateId, this.messageId);
                IterableApi.sharedInstance.setAttributionInfo(attributionInfo);
            }
        }
    }
}

