/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import androidx.annotation.NonNull;
import com.iterable.iterableapi.IterableAuthHandler;
import com.iterable.iterableapi.IterableCustomActionHandler;
import com.iterable.iterableapi.IterableDefaultInAppHandler;
import com.iterable.iterableapi.IterableInAppHandler;
import com.iterable.iterableapi.IterableUrlHandler;

public class IterableConfig {
    final String pushIntegrationName;
    final IterableUrlHandler urlHandler;
    final IterableCustomActionHandler customActionHandler;
    final boolean autoPushRegistration;
    final boolean checkForDeferredDeeplink;
    final int logLevel;
    final IterableInAppHandler inAppHandler;
    final double inAppDisplayInterval;
    final IterableAuthHandler authHandler;
    final long expiringAuthTokenRefreshPeriod;
    final String[] allowedProtocols;

    private IterableConfig(Builder builder) {
        this.pushIntegrationName = builder.pushIntegrationName;
        this.urlHandler = builder.urlHandler;
        this.customActionHandler = builder.customActionHandler;
        this.autoPushRegistration = builder.autoPushRegistration;
        this.checkForDeferredDeeplink = builder.checkForDeferredDeeplink;
        this.logLevel = builder.logLevel;
        this.inAppHandler = builder.inAppHandler;
        this.inAppDisplayInterval = builder.inAppDisplayInterval;
        this.authHandler = builder.authHandler;
        this.expiringAuthTokenRefreshPeriod = builder.expiringAuthTokenRefreshPeriod;
        this.allowedProtocols = builder.allowedProtocols;
    }

    public static class Builder {
        private String pushIntegrationName;
        private IterableUrlHandler urlHandler;
        private IterableCustomActionHandler customActionHandler;
        private boolean autoPushRegistration = true;
        private boolean checkForDeferredDeeplink;
        private int logLevel = 6;
        private IterableInAppHandler inAppHandler = new IterableDefaultInAppHandler();
        private double inAppDisplayInterval = 30.0;
        private IterableAuthHandler authHandler;
        private long expiringAuthTokenRefreshPeriod = 60000L;
        private String[] allowedProtocols = new String[0];

        @NonNull
        public Builder setPushIntegrationName(@NonNull String pushIntegrationName) {
            this.pushIntegrationName = pushIntegrationName;
            return this;
        }

        @NonNull
        public Builder setUrlHandler(@NonNull IterableUrlHandler urlHandler) {
            this.urlHandler = urlHandler;
            return this;
        }

        @NonNull
        public Builder setCustomActionHandler(@NonNull IterableCustomActionHandler customActionHandler) {
            this.customActionHandler = customActionHandler;
            return this;
        }

        @NonNull
        public Builder setAutoPushRegistration(boolean enabled) {
            this.autoPushRegistration = enabled;
            return this;
        }

        @NonNull
        public Builder setCheckForDeferredDeeplink(boolean checkForDeferredDeeplink) {
            this.checkForDeferredDeeplink = checkForDeferredDeeplink;
            return this;
        }

        @NonNull
        public Builder setLogLevel(int logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @NonNull
        public Builder setInAppHandler(@NonNull IterableInAppHandler inAppHandler) {
            this.inAppHandler = inAppHandler;
            return this;
        }

        @NonNull
        public Builder setInAppDisplayInterval(double inAppDisplayInterval) {
            this.inAppDisplayInterval = inAppDisplayInterval;
            return this;
        }

        @NonNull
        public Builder setAuthHandler(@NonNull IterableAuthHandler authHandler) {
            this.authHandler = authHandler;
            return this;
        }

        @NonNull
        public Builder setExpiringAuthTokenRefreshPeriod(@NonNull Long period) {
            this.expiringAuthTokenRefreshPeriod = period * 1000L;
            return this;
        }

        @NonNull
        public Builder setAllowedProtocols(@NonNull String[] allowedProtocols) {
            this.allowedProtocols = allowedProtocols;
            return this;
        }

        @NonNull
        public IterableConfig build() {
            return new IterableConfig(this);
        }
    }
}

