/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.util.Base64;
import androidx.annotation.VisibleForTesting;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableAuthHandler;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableUtil;
import com.iterable.iterableapi.util.Future;
import java.io.UnsupportedEncodingException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import org.json.JSONObject;

public class IterableAuthManager {
    private static final String TAG = "IterableAuth";
    private static final String expirationString = "exp";
    private final IterableApi api;
    private final IterableAuthHandler authHandler;
    private final long expiringAuthTokenRefreshPeriod;
    @VisibleForTesting
    Timer timer;
    private boolean hasFailedPriorAuth;
    private boolean pendingAuth;
    private boolean requiresAuthRefresh;

    IterableAuthManager(IterableApi api, IterableAuthHandler authHandler, long expiringAuthTokenRefreshPeriod) {
        this.api = api;
        this.authHandler = authHandler;
        this.expiringAuthTokenRefreshPeriod = expiringAuthTokenRefreshPeriod;
    }

    public synchronized void requestNewAuthToken(boolean hasFailedPriorAuth) {
        if (this.authHandler != null) {
            if (!this.pendingAuth) {
                if (!this.hasFailedPriorAuth || !hasFailedPriorAuth) {
                    this.hasFailedPriorAuth = hasFailedPriorAuth;
                    this.pendingAuth = true;
                    Future.runAsync(new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return IterableAuthManager.this.authHandler.onAuthTokenRequested();
                        }
                    }).onSuccess(new Future.SuccessCallback<String>(){

                        @Override
                        public void onSuccess(String authToken) {
                            if (authToken != null) {
                                IterableAuthManager.this.queueExpirationRefresh(authToken);
                            }
                            IterableApi.getInstance().setAuthToken(authToken);
                            IterableAuthManager.this.pendingAuth = false;
                            IterableAuthManager.this.reSyncAuth();
                        }
                    }).onFailure(new Future.FailureCallback(){

                        @Override
                        public void onFailure(Throwable throwable) {
                            IterableLogger.e(IterableAuthManager.TAG, "Error while requesting Auth Token", throwable);
                            IterableAuthManager.this.pendingAuth = false;
                            IterableAuthManager.this.reSyncAuth();
                        }
                    });
                }
            } else if (!hasFailedPriorAuth) {
                this.requiresAuthRefresh = true;
            }
        } else {
            IterableApi.getInstance().setAuthToken(null, true);
        }
    }

    public void queueExpirationRefresh(String encodedJWT) {
        this.clearRefreshTimer();
        try {
            long expirationTimeSeconds = IterableAuthManager.decodedExpiration(encodedJWT);
            long triggerExpirationRefreshTime = expirationTimeSeconds * 1000L - this.expiringAuthTokenRefreshPeriod - IterableUtil.currentTimeMillis();
            if (triggerExpirationRefreshTime > 0L) {
                this.scheduleAuthTokenRefresh(triggerExpirationRefreshTime);
            } else {
                IterableLogger.w(TAG, "The expiringAuthTokenRefreshPeriod has already passed for the current JWT");
            }
        }
        catch (Exception e) {
            IterableLogger.e(TAG, "Error while parsing JWT for the expiration", e);
        }
    }

    void resetFailedAuth() {
        this.hasFailedPriorAuth = false;
    }

    void reSyncAuth() {
        if (this.requiresAuthRefresh) {
            this.requiresAuthRefresh = false;
            this.requestNewAuthToken(false);
        }
    }

    private void scheduleAuthTokenRefresh(long timeDuration) {
        this.timer = new Timer(true);
        try {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    IterableAuthManager.this.api.getAuthManager().requestNewAuthToken(false);
                }
            }, timeDuration);
        }
        catch (Exception e) {
            IterableLogger.e(TAG, "timer exception: " + this.timer, e);
        }
    }

    private static long decodedExpiration(String encodedJWT) throws Exception {
        long exp = 0L;
        String[] split = encodedJWT.split("\\.");
        String body = IterableAuthManager.getJson(split[1]);
        JSONObject jObj = new JSONObject(body);
        exp = jObj.getLong(expirationString);
        return exp;
    }

    private static String getJson(String strEncoded) throws UnsupportedEncodingException {
        byte[] decodedBytes = Base64.decode((String)strEncoded, (int)8);
        return new String(decodedBytes, "UTF-8");
    }

    void clearRefreshTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

