/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.iterable.iterableapi.IterableHelper;
import com.iterable.iterableapi.IterableLogger;
import org.json.JSONException;
import org.json.JSONObject;

class IterableApiRequest {
    private static final String TAG = "IterableApiRequest";
    static final String GET = "GET";
    static final String POST = "POST";
    final String apiKey;
    final String baseUrl;
    final String resourcePath;
    final JSONObject json;
    final String requestType;
    final String authToken;
    private ProcessorType processorType = ProcessorType.ONLINE;
    IterableHelper.IterableActionHandler legacyCallback;
    IterableHelper.SuccessHandler successCallback;
    IterableHelper.FailureHandler failureCallback;

    public ProcessorType getProcessorType() {
        return this.processorType;
    }

    void setProcessorType(ProcessorType processorType) {
        this.processorType = processorType;
    }

    IterableApiRequest(String apiKey, String baseUrl, String resourcePath, JSONObject json, String requestType, String authToken, IterableHelper.SuccessHandler onSuccess, IterableHelper.FailureHandler onFailure) {
        this.apiKey = apiKey;
        this.baseUrl = baseUrl;
        this.resourcePath = resourcePath;
        this.json = json;
        this.requestType = requestType;
        this.authToken = authToken;
        this.successCallback = onSuccess;
        this.failureCallback = onFailure;
    }

    IterableApiRequest(String apiKey, String resourcePath, JSONObject json, String requestType, String authToken, IterableHelper.SuccessHandler onSuccess, IterableHelper.FailureHandler onFailure) {
        this.apiKey = apiKey;
        this.baseUrl = null;
        this.resourcePath = resourcePath;
        this.json = json;
        this.requestType = requestType;
        this.authToken = authToken;
        this.successCallback = onSuccess;
        this.failureCallback = onFailure;
    }

    IterableApiRequest(String apiKey, String resourcePath, JSONObject json, String requestType, String authToken, IterableHelper.IterableActionHandler callback) {
        this.apiKey = apiKey;
        this.baseUrl = null;
        this.resourcePath = resourcePath;
        this.json = json;
        this.requestType = requestType;
        this.authToken = authToken;
        this.legacyCallback = callback;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("apiKey", (Object)this.apiKey);
        jsonObject.put("resourcePath", (Object)this.resourcePath);
        jsonObject.put("authToken", (Object)this.authToken);
        jsonObject.put("requestType", (Object)this.requestType);
        jsonObject.put("data", (Object)this.json);
        return jsonObject;
    }

    static IterableApiRequest fromJSON(JSONObject jsonData, @Nullable IterableHelper.SuccessHandler onSuccess, @Nullable IterableHelper.FailureHandler onFailure) {
        try {
            String apikey = jsonData.getString("apiKey");
            String resourcePath = jsonData.getString("resourcePath");
            String requestType = jsonData.getString("requestType");
            String authToken = "";
            if (jsonData.has("authToken")) {
                authToken = jsonData.getString("authToken");
            }
            JSONObject json = jsonData.getJSONObject("data");
            return new IterableApiRequest(apikey, resourcePath, json, requestType, authToken, onSuccess, onFailure);
        }
        catch (JSONException e) {
            IterableLogger.e(TAG, "Failed to create Iterable request from JSON");
            return null;
        }
    }

    static enum ProcessorType {
        ONLINE{

            @NonNull
            public String toString() {
                return "Online";
            }
        }
        ,
        OFFLINE{

            @NonNull
            public String toString() {
                return "Offline";
            }
        };

    }
}

