/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationManagerCompat;
import com.iterable.iterableapi.CommerceItem;
import com.iterable.iterableapi.IterableHelper;
import com.iterable.iterableapi.IterableInAppCloseAction;
import com.iterable.iterableapi.IterableInAppDeleteActionType;
import com.iterable.iterableapi.IterableInAppLocation;
import com.iterable.iterableapi.IterableInAppMessage;
import com.iterable.iterableapi.IterableInboxSession;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableUtil;
import com.iterable.iterableapi.OfflineRequestProcessor;
import com.iterable.iterableapi.OnlineRequestProcessor;
import com.iterable.iterableapi.RequestProcessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class IterableApiClient {
    private static final String TAG = "IterableApiClient";
    @NonNull
    private final AuthProvider authProvider;
    private RequestProcessor requestProcessor;

    IterableApiClient(@NonNull AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    private RequestProcessor getRequestProcessor() {
        if (this.requestProcessor == null) {
            this.requestProcessor = new OnlineRequestProcessor();
        }
        return this.requestProcessor;
    }

    void setOfflineProcessingEnabled(boolean offlineMode) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (offlineMode) {
                if (this.requestProcessor == null || this.requestProcessor.getClass() != OfflineRequestProcessor.class) {
                    this.requestProcessor = new OfflineRequestProcessor(this.authProvider.getContext());
                }
            } else if (this.requestProcessor == null || this.requestProcessor.getClass() != OnlineRequestProcessor.class) {
                this.requestProcessor = new OnlineRequestProcessor();
            }
        }
    }

    void getRemoteConfiguration(IterableHelper.IterableActionHandler actionHandler) {
        JSONObject requestJSON = new JSONObject();
        try {
            requestJSON.putOpt("platform", (Object)"Android");
            requestJSON.putOpt("appPackageName", (Object)this.authProvider.getContext().getPackageName());
            requestJSON.put("SDKVersion", (Object)"3.4.0");
            requestJSON.put("systemVersion", (Object)Build.VERSION.RELEASE);
            this.sendGetRequest("mobile/getRemoteConfiguration", requestJSON, actionHandler);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void track(@NonNull String eventName, int campaignId, int templateId, @Nullable JSONObject dataFields) {
        JSONObject requestJSON = new JSONObject();
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            requestJSON.put("eventName", (Object)eventName);
            if (campaignId != 0) {
                requestJSON.put("campaignId", campaignId);
            }
            if (templateId != 0) {
                requestJSON.put("templateId", templateId);
            }
            requestJSON.put("dataFields", (Object)dataFields);
            this.sendPostRequest("events/track", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateCart(@NonNull List<CommerceItem> items) {
        JSONObject requestJSON = new JSONObject();
        try {
            JSONArray itemsArray = new JSONArray();
            for (CommerceItem item : items) {
                itemsArray.put((Object)item.toJSONObject());
            }
            JSONObject userObject = new JSONObject();
            this.addEmailOrUserIdToJson(userObject);
            requestJSON.put("user", (Object)userObject);
            requestJSON.put("items", (Object)itemsArray);
            this.sendPostRequest("commerce/updateCart", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void trackPurchase(double total, @NonNull List<CommerceItem> items, @Nullable JSONObject dataFields) {
        JSONObject requestJSON = new JSONObject();
        try {
            JSONArray itemsArray = new JSONArray();
            for (CommerceItem item : items) {
                itemsArray.put((Object)item.toJSONObject());
            }
            JSONObject userObject = new JSONObject();
            this.addEmailOrUserIdToJson(userObject);
            requestJSON.put("user", (Object)userObject);
            requestJSON.put("items", (Object)itemsArray);
            requestJSON.put("total", total);
            if (dataFields != null) {
                requestJSON.put("dataFields", (Object)dataFields);
            }
            this.sendPostRequest("commerce/trackPurchase", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateEmail(@NonNull String newEmail, @Nullable IterableHelper.SuccessHandler successHandler, @Nullable IterableHelper.FailureHandler failureHandler) {
        JSONObject requestJSON = new JSONObject();
        try {
            if (this.authProvider.getEmail() != null) {
                requestJSON.put("currentEmail", (Object)this.authProvider.getEmail());
            } else {
                requestJSON.put("currentUserId", (Object)this.authProvider.getUserId());
            }
            requestJSON.put("newEmail", (Object)newEmail);
            this.sendPostRequest("users/updateEmail", requestJSON, successHandler, failureHandler);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateUser(@NonNull JSONObject dataFields, Boolean mergeNestedObjects) {
        JSONObject requestJSON = new JSONObject();
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            if (this.authProvider.getEmail() == null && this.authProvider.getUserId() != null) {
                requestJSON.put("preferUserId", true);
            }
            requestJSON.put("dataFields", (Object)dataFields);
            requestJSON.put("mergeNestedObjects", (Object)mergeNestedObjects);
            this.sendPostRequest("users/update", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateSubscriptions(@Nullable Integer[] emailListIds, @Nullable Integer[] unsubscribedChannelIds, @Nullable Integer[] unsubscribedMessageTypeIds, @Nullable Integer[] subscribedMessageTypeIDs, Integer campaignId, Integer templateId) {
        JSONObject requestJSON = new JSONObject();
        this.addEmailOrUserIdToJson(requestJSON);
        this.tryAddArrayToJSON(requestJSON, "emailListIds", emailListIds);
        this.tryAddArrayToJSON(requestJSON, "unsubscribedChannelIds", unsubscribedChannelIds);
        this.tryAddArrayToJSON(requestJSON, "unsubscribedMessageTypeIds", unsubscribedMessageTypeIds);
        this.tryAddArrayToJSON(requestJSON, "subscribedMessageTypeIds", subscribedMessageTypeIDs);
        try {
            if (campaignId != null && campaignId != 0) {
                requestJSON.putOpt("campaignId", (Object)campaignId);
            }
            if (templateId != null && templateId != 0) {
                requestJSON.putOpt("templateId", (Object)templateId);
            }
        }
        catch (JSONException e) {
            IterableLogger.e(TAG, e.toString());
        }
        this.sendPostRequest("users/updateSubscriptions", requestJSON);
    }

    public void getInAppMessages(int count, @NonNull IterableHelper.IterableActionHandler onCallback) {
        JSONObject requestJSON = new JSONObject();
        this.addEmailOrUserIdToJson(requestJSON);
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            requestJSON.put("count", count);
            requestJSON.put("platform", (Object)"Android");
            requestJSON.put("SDKVersion", (Object)"3.4.0");
            requestJSON.put("systemVersion", (Object)Build.VERSION.RELEASE);
            requestJSON.put("packageName", (Object)this.authProvider.getContext().getPackageName());
            this.sendGetRequest("inApp/getMessages", requestJSON, onCallback);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void trackInAppOpen(@NonNull String messageId) {
        JSONObject requestJSON = new JSONObject();
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            requestJSON.put("messageId", (Object)messageId);
            this.sendPostRequest("events/trackInAppOpen", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void trackInAppOpen(@NonNull IterableInAppMessage message, @NonNull IterableInAppLocation location, @Nullable String inboxSessionId) {
        JSONObject requestJSON = new JSONObject();
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            requestJSON.put("messageId", (Object)message.getMessageId());
            requestJSON.put("messageContext", (Object)this.getInAppMessageContext(message, location));
            requestJSON.put("deviceInfo", (Object)this.getDeviceInfoJson());
            if (location == IterableInAppLocation.INBOX) {
                this.addInboxSessionID(requestJSON, inboxSessionId);
            }
            this.sendPostRequest("events/trackInAppOpen", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void trackInAppClick(@NonNull String messageId, @NonNull String clickedUrl) {
        JSONObject requestJSON = new JSONObject();
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            requestJSON.put("messageId", (Object)messageId);
            requestJSON.put("clickedUrl", (Object)clickedUrl);
            this.sendPostRequest("events/trackInAppClick", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void trackInAppClick(@NonNull IterableInAppMessage message, @NonNull String clickedUrl, @NonNull IterableInAppLocation clickLocation, @Nullable String inboxSessionId) {
        JSONObject requestJSON = new JSONObject();
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            requestJSON.put("messageId", (Object)message.getMessageId());
            requestJSON.put("clickedUrl", (Object)clickedUrl);
            requestJSON.put("messageContext", (Object)this.getInAppMessageContext(message, clickLocation));
            requestJSON.put("deviceInfo", (Object)this.getDeviceInfoJson());
            if (clickLocation == IterableInAppLocation.INBOX) {
                this.addInboxSessionID(requestJSON, inboxSessionId);
            }
            this.sendPostRequest("events/trackInAppClick", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    void trackInAppClose(@NonNull IterableInAppMessage message, @Nullable String clickedURL, @NonNull IterableInAppCloseAction closeAction, @NonNull IterableInAppLocation clickLocation, @Nullable String inboxSessionId) {
        JSONObject requestJSON = new JSONObject();
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            requestJSON.put("messageId", (Object)message.getMessageId());
            requestJSON.putOpt("clickedUrl", (Object)clickedURL);
            requestJSON.put("closeAction", (Object)closeAction.toString());
            requestJSON.put("messageContext", (Object)this.getInAppMessageContext(message, clickLocation));
            requestJSON.put("deviceInfo", (Object)this.getDeviceInfoJson());
            if (clickLocation == IterableInAppLocation.INBOX) {
                this.addInboxSessionID(requestJSON, inboxSessionId);
            }
            this.sendPostRequest("events/trackInAppClose", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    void trackInAppDelivery(@NonNull IterableInAppMessage message) {
        JSONObject requestJSON = new JSONObject();
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            requestJSON.put("messageId", (Object)message.getMessageId());
            requestJSON.put("messageContext", (Object)this.getInAppMessageContext(message, null));
            requestJSON.put("deviceInfo", (Object)this.getDeviceInfoJson());
            this.sendPostRequest("events/trackInAppDelivery", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void inAppConsume(@NonNull IterableInAppMessage message, @Nullable IterableInAppDeleteActionType source, @Nullable IterableInAppLocation clickLocation, @Nullable String inboxSessionId) {
        JSONObject requestJSON = new JSONObject();
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            requestJSON.put("messageId", (Object)message.getMessageId());
            if (source != null) {
                requestJSON.put("deleteAction", (Object)source.toString());
            }
            if (clickLocation != null) {
                requestJSON.put("messageContext", (Object)this.getInAppMessageContext(message, clickLocation));
                requestJSON.put("deviceInfo", (Object)this.getDeviceInfoJson());
            }
            if (clickLocation == IterableInAppLocation.INBOX) {
                this.addInboxSessionID(requestJSON, inboxSessionId);
            }
            this.sendPostRequest("events/inAppConsume", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void trackInboxSession(@NonNull IterableInboxSession session, @Nullable String inboxSessionId) {
        JSONObject requestJSON = new JSONObject();
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            requestJSON.put("inboxSessionStart", session.sessionStartTime.getTime());
            requestJSON.put("inboxSessionEnd", session.sessionEndTime.getTime());
            requestJSON.put("startTotalMessageCount", session.startTotalMessageCount);
            requestJSON.put("startUnreadMessageCount", session.startUnreadMessageCount);
            requestJSON.put("endTotalMessageCount", session.endTotalMessageCount);
            requestJSON.put("endUnreadMessageCount", session.endUnreadMessageCount);
            if (session.impressions != null) {
                JSONArray impressionsJsonArray = new JSONArray();
                for (IterableInboxSession.Impression impression : session.impressions) {
                    JSONObject impressionJson = new JSONObject();
                    impressionJson.put("messageId", (Object)impression.messageId);
                    impressionJson.put("silentInbox", impression.silentInbox);
                    impressionJson.put("displayCount", impression.displayCount);
                    impressionJson.put("displayDuration", (double)impression.duration);
                    impressionsJsonArray.put((Object)impressionJson);
                }
                requestJSON.put("impressions", (Object)impressionsJsonArray);
            }
            requestJSON.putOpt("deviceInfo", (Object)this.getDeviceInfoJson());
            this.addInboxSessionID(requestJSON, inboxSessionId);
            this.sendPostRequest("events/trackInboxSession", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    protected void trackPushOpen(int campaignId, int templateId, @NonNull String messageId, @Nullable JSONObject dataFields) {
        JSONObject requestJSON = new JSONObject();
        try {
            if (dataFields == null) {
                dataFields = new JSONObject();
            }
            this.addEmailOrUserIdToJson(requestJSON);
            requestJSON.put("campaignId", campaignId);
            requestJSON.put("templateId", templateId);
            requestJSON.put("messageId", (Object)messageId);
            requestJSON.putOpt("dataFields", (Object)dataFields);
            this.sendPostRequest("events/trackPushOpen", requestJSON);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    protected void disableToken(@Nullable String email, @Nullable String userId, @Nullable String authToken, @NonNull String deviceToken, @Nullable IterableHelper.SuccessHandler onSuccess, @Nullable IterableHelper.FailureHandler onFailure) {
        JSONObject requestJSON = new JSONObject();
        try {
            requestJSON.put("token", (Object)deviceToken);
            if (email != null) {
                requestJSON.put("email", (Object)email);
            } else if (userId != null) {
                requestJSON.put("userId", (Object)userId);
            }
            this.sendPostRequest("users/disableDevice", requestJSON, authToken, onSuccess, onFailure);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    protected void registerDeviceToken(@Nullable String email, @Nullable String userId, @Nullable String authToken, @NonNull String applicationName, @NonNull String deviceToken, @Nullable JSONObject dataFields, HashMap<String, String> deviceAttributes) {
        Context context = this.authProvider.getContext();
        JSONObject requestJSON = new JSONObject();
        try {
            this.addEmailOrUserIdToJson(requestJSON);
            if (dataFields == null) {
                dataFields = new JSONObject();
            }
            for (Map.Entry<String, String> entry : deviceAttributes.entrySet()) {
                dataFields.put(entry.getKey(), (Object)entry.getValue());
            }
            dataFields.put("tokenRegistrationType", (Object)"FCM");
            dataFields.put("firebaseCompatible", true);
            dataFields.put("brand", (Object)Build.BRAND);
            dataFields.put("manufacturer", (Object)Build.MANUFACTURER);
            dataFields.putOpt("advertisingId", (Object)IterableUtil.getAdvertisingId(this.authProvider.getContext()));
            dataFields.put("systemName", (Object)Build.DEVICE);
            dataFields.put("systemVersion", (Object)Build.VERSION.RELEASE);
            dataFields.put("model", (Object)Build.MODEL);
            dataFields.put("sdkVersion", Build.VERSION.SDK_INT);
            dataFields.put("deviceId", (Object)this.authProvider.getDeviceId());
            dataFields.put("appPackageName", (Object)context.getPackageName());
            dataFields.put("appVersion", (Object)IterableUtil.getAppVersion(context));
            dataFields.put("appBuild", (Object)IterableUtil.getAppVersionCode(context));
            dataFields.put("iterableSdkVersion", (Object)"3.4.0");
            dataFields.put("notificationsEnabled", NotificationManagerCompat.from((Context)context).areNotificationsEnabled());
            JSONObject device = new JSONObject();
            device.put("token", (Object)deviceToken);
            device.put("platform", (Object)"GCM");
            device.put("applicationName", (Object)applicationName);
            device.putOpt("dataFields", (Object)dataFields);
            requestJSON.put("device", (Object)device);
            if (email == null && userId != null) {
                requestJSON.put("preferUserId", true);
            }
            this.sendPostRequest("users/registerDeviceToken", requestJSON, authToken);
        }
        catch (JSONException e) {
            IterableLogger.e(TAG, "registerDeviceToken: exception", e);
        }
    }

    private void addEmailOrUserIdToJson(JSONObject requestJSON) {
        try {
            if (this.authProvider.getEmail() != null) {
                requestJSON.put("email", (Object)this.authProvider.getEmail());
            } else {
                requestJSON.put("userId", (Object)this.authProvider.getUserId());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void addInboxSessionID(@NonNull JSONObject requestJSON, @Nullable String inboxSessionId) throws JSONException {
        if (inboxSessionId != null) {
            requestJSON.put("inboxSessionId", (Object)inboxSessionId);
        }
    }

    private JSONObject getInAppMessageContext(@NonNull IterableInAppMessage message, @Nullable IterableInAppLocation location) {
        JSONObject messageContext = new JSONObject();
        try {
            boolean isSilentInbox = message.isSilentInboxMessage();
            messageContext.putOpt("saveToInbox", (Object)message.isInboxMessage());
            messageContext.putOpt("silentInbox", (Object)isSilentInbox);
            if (location != null) {
                messageContext.putOpt("location", (Object)location.toString());
            }
        }
        catch (Exception e) {
            IterableLogger.e(TAG, "Could not populate messageContext JSON", e);
        }
        return messageContext;
    }

    @NonNull
    private JSONObject getDeviceInfoJson() {
        JSONObject deviceInfo = new JSONObject();
        try {
            deviceInfo.putOpt("deviceId", (Object)this.authProvider.getDeviceId());
            deviceInfo.putOpt("platform", (Object)"Android");
            deviceInfo.putOpt("appPackageName", (Object)this.authProvider.getContext().getPackageName());
        }
        catch (Exception e) {
            IterableLogger.e(TAG, "Could not populate deviceInfo JSON", e);
        }
        return deviceInfo;
    }

    void tryAddArrayToJSON(JSONObject requestJSON, String key, Object[] value) {
        if (requestJSON != null && key != null && value != null) {
            try {
                JSONArray mJSONArray = new JSONArray(Arrays.asList(value));
                requestJSON.put(key, (Object)mJSONArray);
            }
            catch (JSONException e) {
                IterableLogger.e(TAG, e.toString());
            }
        }
    }

    void sendPostRequest(@NonNull String resourcePath, @NonNull JSONObject json) {
        this.sendPostRequest(resourcePath, json, this.authProvider.getAuthToken());
    }

    void sendPostRequest(@NonNull String resourcePath, @NonNull JSONObject json, @Nullable String authToken) {
        this.sendPostRequest(resourcePath, json, authToken, null, null);
    }

    void sendPostRequest(@NonNull String resourcePath, @NonNull JSONObject json, @Nullable IterableHelper.SuccessHandler onSuccess, @Nullable IterableHelper.FailureHandler onFailure) {
        this.sendPostRequest(resourcePath, json, this.authProvider.getAuthToken(), onSuccess, onFailure);
    }

    void sendPostRequest(@NonNull String resourcePath, @NonNull JSONObject json, @Nullable String authToken, @Nullable IterableHelper.SuccessHandler onSuccess, @Nullable IterableHelper.FailureHandler onFailure) {
        this.getRequestProcessor().processPostRequest(this.authProvider.getApiKey(), resourcePath, json, authToken, onSuccess, onFailure);
    }

    void sendGetRequest(@NonNull String resourcePath, @NonNull JSONObject json, @Nullable IterableHelper.IterableActionHandler onCallback) {
        this.getRequestProcessor().processGetRequest(this.authProvider.getApiKey(), resourcePath, json, this.authProvider.getAuthToken(), onCallback);
    }

    void onLogout() {
        this.getRequestProcessor().onLogout(this.authProvider.getContext());
    }

    static interface AuthProvider {
        @Nullable
        public String getEmail();

        @Nullable
        public String getUserId();

        @Nullable
        public String getAuthToken();

        @Nullable
        public String getApiKey();

        @Nullable
        public String getDeviceId();

        @Nullable
        public Context getContext();
    }
}

