/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.iterable.iterableapi.CommerceItem;
import com.iterable.iterableapi.IterableAction;
import com.iterable.iterableapi.IterableActionRunner;
import com.iterable.iterableapi.IterableActionSource;
import com.iterable.iterableapi.IterableActivityMonitor;
import com.iterable.iterableapi.IterableApiClient;
import com.iterable.iterableapi.IterableAttributionInfo;
import com.iterable.iterableapi.IterableAuthManager;
import com.iterable.iterableapi.IterableConfig;
import com.iterable.iterableapi.IterableDeeplinkManager;
import com.iterable.iterableapi.IterableHelper;
import com.iterable.iterableapi.IterableInAppCloseAction;
import com.iterable.iterableapi.IterableInAppDeleteActionType;
import com.iterable.iterableapi.IterableInAppLocation;
import com.iterable.iterableapi.IterableInAppManager;
import com.iterable.iterableapi.IterableInAppMessage;
import com.iterable.iterableapi.IterableInboxSession;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableNotificationData;
import com.iterable.iterableapi.IterableNotificationHelper;
import com.iterable.iterableapi.IterablePushActionReceiver;
import com.iterable.iterableapi.IterablePushRegistration;
import com.iterable.iterableapi.IterablePushRegistrationData;
import com.iterable.iterableapi.IterableRequestTask;
import com.iterable.iterableapi.IterableUtil;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class IterableApi {
    private static final String TAG = "IterableApi";
    static volatile IterableApi sharedInstance = new IterableApi();
    private Context _applicationContext;
    IterableConfig config;
    private String _apiKey;
    private String _email;
    private String _userId;
    private String _authToken;
    private boolean _debugMode;
    private Bundle _payloadData;
    private IterableNotificationData _notificationData;
    private String _deviceId;
    private boolean _firstForegroundHandled;
    IterableApiClient apiClient = new IterableApiClient(new IterableApiAuthProvider());
    @Nullable
    private IterableInAppManager inAppManager;
    private String inboxSessionId;
    private IterableAuthManager authManager;
    private HashMap<String, String> deviceAttributes = new HashMap();
    private final IterableActivityMonitor.AppStateCallback activityMonitorListener = new IterableActivityMonitor.AppStateCallback(){

        @Override
        public void onSwitchToForeground() {
            IterableApi.this.onForeground();
        }

        @Override
        public void onSwitchToBackground() {
        }
    };

    IterableApi() {
        this.config = new IterableConfig.Builder().build();
    }

    @VisibleForTesting
    IterableApi(IterableInAppManager inAppManager) {
        this.config = new IterableConfig.Builder().build();
        this.inAppManager = inAppManager;
    }

    @VisibleForTesting
    IterableApi(IterableApiClient apiClient, IterableInAppManager inAppManager) {
        this.config = new IterableConfig.Builder().build();
        this.apiClient = apiClient;
        this.inAppManager = inAppManager;
    }

    public void setNotificationIcon(@Nullable String iconName) {
        IterableApi.setNotificationIcon(this._applicationContext, iconName);
    }

    @Nullable
    public String getPayloadData(@NonNull String key) {
        return this._payloadData != null ? this._payloadData.getString(key, null) : null;
    }

    @Nullable
    public Bundle getPayloadData() {
        return this._payloadData;
    }

    @NonNull
    public IterableInAppManager getInAppManager() {
        if (this.inAppManager == null) {
            throw new RuntimeException("IterableApi must be initialized before calling getInAppManager(). Make sure you call IterableApi#initialize() in Application#onCreate");
        }
        return this.inAppManager;
    }

    @NonNull
    IterableAuthManager getAuthManager() {
        if (this.authManager == null) {
            this.authManager = new IterableAuthManager(this, this.config.authHandler, this.config.expiringAuthTokenRefreshPeriod);
        }
        return this.authManager;
    }

    @Nullable
    public IterableAttributionInfo getAttributionInfo() {
        return IterableAttributionInfo.fromJSONObject(IterableUtil.retrieveExpirableJsonObject(this.getPreferences(), "itbl_attribution_info"));
    }

    void setAttributionInfo(IterableAttributionInfo attributionInfo) {
        if (this._applicationContext == null) {
            IterableLogger.e(TAG, "setAttributionInfo: Iterable SDK is not initialized with a context.");
            return;
        }
        IterableUtil.saveExpirableJsonObject(this.getPreferences(), "itbl_attribution_info", attributionInfo.toJSONObject(), 86400000L);
    }

    Context getMainActivityContext() {
        return this._applicationContext;
    }

    void setDebugMode(boolean debugMode) {
        this._debugMode = debugMode;
    }

    boolean getDebugMode() {
        return this._debugMode;
    }

    void setPayloadData(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras != null && extras.containsKey("itbl") && !IterableNotificationHelper.isGhostPush(extras)) {
            this.setPayloadData(extras);
        }
    }

    void setPayloadData(Bundle bundle) {
        this._payloadData = bundle;
    }

    void setNotificationData(IterableNotificationData data) {
        this._notificationData = data;
        if (data != null) {
            this.setAttributionInfo(new IterableAttributionInfo(data.getCampaignId(), data.getTemplateId(), data.getMessageId()));
        }
    }

    void setAuthToken(String authToken) {
        this.setAuthToken(authToken, false);
    }

    void setAuthToken(String authToken, boolean bypassAuth) {
        if (this.isInitialized()) {
            if (authToken != null && !authToken.equalsIgnoreCase(this._authToken) || this._authToken != null && !this._authToken.equalsIgnoreCase(authToken)) {
                this._authToken = authToken;
                this.storeAuthData();
                this.onLogIn();
            } else if (bypassAuth) {
                this.onLogIn();
            }
        }
    }

    HashMap getDeviceAttributes() {
        return this.deviceAttributes;
    }

    public void setDeviceAttribute(String key, String value) {
        this.deviceAttributes.put(key, value);
    }

    public void removeDeviceAttribute(String key) {
        this.deviceAttributes.remove(key);
    }

    @NonNull
    public static IterableApi getInstance() {
        return sharedInstance;
    }

    public static void initialize(@NonNull Context context, @NonNull String apiKey) {
        IterableApi.initialize(context, apiKey, null);
    }

    public static void initialize(@NonNull Context context, @NonNull String apiKey, @Nullable IterableConfig config) {
        IterableApi.sharedInstance._applicationContext = context.getApplicationContext();
        IterableApi.sharedInstance._apiKey = apiKey;
        IterableApi.sharedInstance.config = config;
        if (IterableApi.sharedInstance.config == null) {
            IterableApi.sharedInstance.config = new IterableConfig.Builder().build();
        }
        sharedInstance.retrieveEmailAndUserId();
        IterableActivityMonitor.getInstance().registerLifecycleCallbacks(context);
        IterableActivityMonitor.getInstance().addCallback(IterableApi.sharedInstance.activityMonitorListener);
        if (IterableApi.sharedInstance.inAppManager == null) {
            IterableApi.sharedInstance.inAppManager = new IterableInAppManager(sharedInstance, IterableApi.sharedInstance.config.inAppHandler, IterableApi.sharedInstance.config.inAppDisplayInterval);
        }
        IterableApi.loadLastSavedConfiguration(context);
        IterablePushActionReceiver.processPendingAction(context);
    }

    public static void setContext(Context context) {
        IterableActivityMonitor.getInstance().registerLifecycleCallbacks(context);
    }

    static void loadLastSavedConfiguration(Context context) {
        SharedPreferences sharedPref = context.getSharedPreferences("itbl_saved_configuration", 0);
        boolean offlineMode = sharedPref.getBoolean("offlineModeBeta", false);
        IterableApi.sharedInstance.apiClient.setOfflineProcessingEnabled(offlineMode);
    }

    void fetchRemoteConfiguration() {
        this.apiClient.getRemoteConfiguration(new IterableHelper.IterableActionHandler(){

            @Override
            public void execute(@Nullable String data) {
                if (data == null) {
                    IterableLogger.e(IterableApi.TAG, "Remote configuration returned null");
                    return;
                }
                try {
                    JSONObject jsonData = new JSONObject(data);
                    boolean offlineConfiguration = jsonData.getBoolean("offlineModeBeta");
                    IterableApi.sharedInstance.apiClient.setOfflineProcessingEnabled(offlineConfiguration);
                    SharedPreferences sharedPref = sharedInstance.getMainActivityContext().getSharedPreferences("itbl_saved_configuration", 0);
                    SharedPreferences.Editor editor = sharedPref.edit();
                    editor.putBoolean("offlineModeBeta", offlineConfiguration);
                    editor.apply();
                }
                catch (JSONException e) {
                    IterableLogger.e(IterableApi.TAG, "Failed to read remote configuration");
                }
            }
        });
    }

    public void setEmail(@Nullable String email) {
        if (this._email != null && this._email.equals(email)) {
            return;
        }
        if (this._email == null && this._userId == null && email == null) {
            return;
        }
        this.onLogOut();
        this._email = email;
        this._userId = null;
        this.storeAuthData();
        if (email != null) {
            this.getAuthManager().requestNewAuthToken(false);
        } else {
            this.setAuthToken(null);
        }
    }

    public void setUserId(@Nullable String userId) {
        if (this._userId != null && this._userId.equals(userId)) {
            return;
        }
        if (this._email == null && this._userId == null && userId == null) {
            return;
        }
        this.onLogOut();
        this._email = null;
        this._userId = userId;
        this.storeAuthData();
        if (userId != null) {
            this.getAuthManager().requestNewAuthToken(false);
        } else {
            this.setAuthToken(null);
        }
    }

    public void getAndTrackDeepLink(@NonNull String uri, @NonNull IterableHelper.IterableActionHandler onCallback) {
        IterableDeeplinkManager.getAndTrackDeeplink(uri, onCallback);
    }

    public boolean handleAppLink(@NonNull String uri) {
        IterableLogger.printInfo();
        if (IterableDeeplinkManager.isIterableDeeplink(uri)) {
            IterableDeeplinkManager.getAndTrackDeeplink(uri, new IterableHelper.IterableActionHandler(){

                @Override
                public void execute(String originalUrl) {
                    IterableAction action = IterableAction.actionOpenUrl(originalUrl);
                    IterableActionRunner.executeAction(IterableApi.getInstance().getMainActivityContext(), action, IterableActionSource.APP_LINK);
                }
            });
            return true;
        }
        IterableAction action = IterableAction.actionOpenUrl(uri);
        return IterableActionRunner.executeAction(IterableApi.getInstance().getMainActivityContext(), action, IterableActionSource.APP_LINK);
    }

    public static void overrideURLEndpointPath(@NonNull String url) {
        IterableRequestTask.overrideUrl = url;
    }

    public boolean isIterableIntent(@Nullable Intent intent) {
        if (intent != null) {
            Bundle extras = intent.getExtras();
            return extras != null && extras.containsKey("itbl");
        }
        return false;
    }

    public void registerDeviceToken(@NonNull String deviceToken) {
        this.registerDeviceToken(this._email, this._userId, this._authToken, this.getPushIntegrationName(), deviceToken, this.deviceAttributes);
    }

    protected void registerDeviceToken(final @Nullable String email, final @Nullable String userId, final @Nullable String authToken, final @NonNull String applicationName, final @NonNull String deviceToken, final HashMap<String, String> deviceAttributes) {
        if (deviceToken != null) {
            Thread registrationThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    IterableApi.this.registerDeviceToken(email, userId, authToken, applicationName, deviceToken, null, deviceAttributes);
                }
            });
            registrationThread.start();
        }
    }

    public void track(@NonNull String eventName) {
        this.track(eventName, 0, 0, null);
    }

    public void track(@NonNull String eventName, @Nullable JSONObject dataFields) {
        this.track(eventName, 0, 0, dataFields);
    }

    public void track(@NonNull String eventName, int campaignId, int templateId) {
        this.track(eventName, campaignId, templateId, null);
    }

    public void track(@NonNull String eventName, int campaignId, int templateId, @Nullable JSONObject dataFields) {
        IterableLogger.printInfo();
        if (!this.checkSDKInitialization()) {
            return;
        }
        this.apiClient.track(eventName, campaignId, templateId, dataFields);
    }

    public void updateCart(@NonNull List<CommerceItem> items) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        this.apiClient.updateCart(items);
    }

    public void trackPurchase(double total, @NonNull List<CommerceItem> items) {
        this.trackPurchase(total, items, null);
    }

    public void trackPurchase(double total, @NonNull List<CommerceItem> items, @Nullable JSONObject dataFields) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        this.apiClient.trackPurchase(total, items, dataFields);
    }

    public void updateEmail(@NonNull String newEmail) {
        this.updateEmail(newEmail, null, null);
    }

    public void updateEmail(final @NonNull String newEmail, final @Nullable IterableHelper.SuccessHandler successHandler, @Nullable IterableHelper.FailureHandler failureHandler) {
        if (!this.checkSDKInitialization()) {
            IterableLogger.e(TAG, "The Iterable SDK must be initialized with email or userId before calling updateEmail");
            if (failureHandler != null) {
                failureHandler.onFailure("The Iterable SDK must be initialized with email or userId before calling updateEmail", null);
            }
            return;
        }
        this.apiClient.updateEmail(newEmail, new IterableHelper.SuccessHandler(){

            @Override
            public void onSuccess(@NonNull JSONObject data) {
                if (IterableApi.this._email != null) {
                    IterableApi.this._email = newEmail;
                }
                IterableApi.this.storeAuthData();
                IterableApi.this.getAuthManager().requestNewAuthToken(false);
                if (successHandler != null) {
                    successHandler.onSuccess(data);
                }
            }
        }, failureHandler);
    }

    public void updateUser(@NonNull JSONObject dataFields) {
        this.updateUser(dataFields, false);
    }

    public void updateUser(@NonNull JSONObject dataFields, Boolean mergeNestedObjects) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        this.apiClient.updateUser(dataFields, mergeNestedObjects);
    }

    private String getPushIntegrationName() {
        if (this.config.pushIntegrationName != null) {
            return this.config.pushIntegrationName;
        }
        return this._applicationContext.getPackageName();
    }

    public void registerForPush() {
        if (!this.checkSDKInitialization()) {
            return;
        }
        IterablePushRegistrationData data = new IterablePushRegistrationData(this._email, this._userId, this._authToken, this.getPushIntegrationName(), IterablePushRegistrationData.PushRegistrationAction.ENABLE);
        IterablePushRegistration.executePushRegistrationTask(data);
    }

    public void disablePush() {
        IterablePushRegistrationData data = new IterablePushRegistrationData(this._email, this._userId, this._authToken, this.getPushIntegrationName(), IterablePushRegistrationData.PushRegistrationAction.DISABLE);
        IterablePushRegistration.executePushRegistrationTask(data);
    }

    public void updateSubscriptions(@Nullable Integer[] emailListIds, @Nullable Integer[] unsubscribedChannelIds, @Nullable Integer[] unsubscribedMessageTypeIds) {
        this.updateSubscriptions(emailListIds, unsubscribedChannelIds, unsubscribedMessageTypeIds, null, null, null);
    }

    public void updateSubscriptions(@Nullable Integer[] emailListIds, @Nullable Integer[] unsubscribedChannelIds, @Nullable Integer[] unsubscribedMessageTypeIds, @Nullable Integer[] subscribedMessageTypeIDs, Integer campaignId, Integer templateId) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        this.apiClient.updateSubscriptions(emailListIds, unsubscribedChannelIds, unsubscribedMessageTypeIds, subscribedMessageTypeIDs, campaignId, templateId);
    }

    void getInAppMessages(int count, @NonNull IterableHelper.IterableActionHandler onCallback) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        this.apiClient.getInAppMessages(count, onCallback);
    }

    public void trackInAppOpen(@NonNull IterableInAppMessage message, @NonNull IterableInAppLocation location) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        if (message == null) {
            IterableLogger.e(TAG, "trackInAppOpen: message is null");
            return;
        }
        this.apiClient.trackInAppOpen(message, location, this.inboxSessionId);
    }

    public void trackInAppClick(@NonNull IterableInAppMessage message, @NonNull String clickedUrl, @NonNull IterableInAppLocation clickLocation) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        if (message == null) {
            IterableLogger.e(TAG, "trackInAppClick: message is null");
            return;
        }
        this.apiClient.trackInAppClick(message, clickedUrl, clickLocation, this.inboxSessionId);
    }

    public void trackInAppClose(@NonNull IterableInAppMessage message, @Nullable String clickedURL, @NonNull IterableInAppCloseAction closeAction, @NonNull IterableInAppLocation clickLocation) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        if (message == null) {
            IterableLogger.e(TAG, "trackInAppClose: message is null");
            return;
        }
        this.apiClient.trackInAppClose(message, clickedURL, closeAction, clickLocation, this.inboxSessionId);
    }

    void trackInAppDelivery(@NonNull IterableInAppMessage message) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        if (message == null) {
            IterableLogger.e(TAG, "trackInAppDelivery: message is null");
            return;
        }
        this.apiClient.trackInAppDelivery(message);
    }

    public void inAppConsume(@NonNull String messageId) {
        IterableInAppMessage message = this.getInAppManager().getMessageById(messageId);
        if (message == null) {
            IterableLogger.e(TAG, "inAppConsume: message is null");
            return;
        }
        this.inAppConsume(message, null, null);
        IterableLogger.printInfo();
    }

    public void inAppConsume(@NonNull IterableInAppMessage message, @Nullable IterableInAppDeleteActionType source, @Nullable IterableInAppLocation clickLocation) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        this.apiClient.inAppConsume(message, source, clickLocation, this.inboxSessionId);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void trackInboxSession(@NonNull IterableInboxSession session) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        if (session == null) {
            IterableLogger.e(TAG, "trackInboxSession: session is null");
            return;
        }
        if (session.sessionStartTime == null || session.sessionEndTime == null) {
            IterableLogger.e(TAG, "trackInboxSession: sessionStartTime and sessionEndTime must be set");
            return;
        }
        this.apiClient.trackInboxSession(session, this.inboxSessionId);
    }

    public void trackInAppOpen(@NonNull String messageId) {
        IterableLogger.printInfo();
        if (!this.checkSDKInitialization()) {
            return;
        }
        this.apiClient.trackInAppOpen(messageId);
    }

    void trackInAppOpen(@NonNull String messageId, @NonNull IterableInAppLocation location) {
        IterableLogger.printInfo();
        IterableInAppMessage message = this.getInAppManager().getMessageById(messageId);
        if (message != null) {
            this.trackInAppOpen(message, location);
        } else {
            IterableLogger.w(TAG, "trackInAppOpen: could not find an in-app message with ID: " + messageId);
        }
    }

    void trackInAppClick(@NonNull String messageId, @NonNull String clickedUrl, @NonNull IterableInAppLocation location) {
        IterableLogger.printInfo();
        IterableInAppMessage message = this.getInAppManager().getMessageById(messageId);
        if (message != null) {
            this.trackInAppClick(message, clickedUrl, location);
        } else {
            this.trackInAppClick(messageId, clickedUrl);
        }
    }

    public void trackInAppClick(@NonNull String messageId, @NonNull String clickedUrl) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        this.apiClient.trackInAppClick(messageId, clickedUrl);
    }

    void trackInAppClose(@NonNull String messageId, @NonNull String clickedURL, @NonNull IterableInAppCloseAction closeAction, @NonNull IterableInAppLocation clickLocation) {
        IterableInAppMessage message = this.getInAppManager().getMessageById(messageId);
        if (message != null) {
            this.trackInAppClose(message, clickedURL, closeAction, clickLocation);
            IterableLogger.printInfo();
        } else {
            IterableLogger.w(TAG, "trackInAppClose: could not find an in-app message with ID: " + messageId);
        }
    }

    String getEmail() {
        return this._email;
    }

    String getUserId() {
        return this._userId;
    }

    String getAuthToken() {
        return this._authToken;
    }

    static void setNotificationIcon(Context context, String iconName) {
        SharedPreferences sharedPref = context.getSharedPreferences("iterable_notification_icon", 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString("iterable_notification_icon", iconName);
        editor.commit();
    }

    static String getNotificationIcon(Context context) {
        SharedPreferences sharedPref = context.getSharedPreferences("iterable_notification_icon", 0);
        String iconName = sharedPref.getString("iterable_notification_icon", "");
        return iconName;
    }

    protected void trackPushOpen(int campaignId, int templateId, @NonNull String messageId) {
        this.trackPushOpen(campaignId, templateId, messageId, null);
    }

    protected void trackPushOpen(int campaignId, int templateId, @NonNull String messageId, @Nullable JSONObject dataFields) {
        if (messageId == null) {
            IterableLogger.e(TAG, "messageId is null");
            return;
        }
        this.apiClient.trackPushOpen(campaignId, templateId, messageId, dataFields);
    }

    protected void disableToken(@Nullable String email, @Nullable String userId, @NonNull String token) {
        this.disableToken(email, userId, null, token, null, null);
    }

    protected void disableToken(@Nullable String email, @Nullable String userId, @Nullable String authToken, @NonNull String deviceToken, @Nullable IterableHelper.SuccessHandler onSuccess, @Nullable IterableHelper.FailureHandler onFailure) {
        this.apiClient.disableToken(email, userId, authToken, deviceToken, onSuccess, onFailure);
    }

    protected void registerDeviceToken(@Nullable String email, @Nullable String userId, @Nullable String authToken, @NonNull String applicationName, @NonNull String deviceToken, @Nullable JSONObject dataFields, HashMap<String, String> deviceAttributes) {
        if (!this.checkSDKInitialization()) {
            return;
        }
        if (deviceToken == null) {
            IterableLogger.e(TAG, "registerDeviceToken: token is null");
            return;
        }
        if (applicationName == null) {
            IterableLogger.e(TAG, "registerDeviceToken: applicationName is null, check that pushIntegrationName is set in IterableConfig");
        }
        this.apiClient.registerDeviceToken(email, userId, authToken, applicationName, deviceToken, dataFields, deviceAttributes);
    }

    private void onForeground() {
        if (!this._firstForegroundHandled) {
            this._firstForegroundHandled = true;
            if (IterableApi.sharedInstance.config.autoPushRegistration && sharedInstance.isInitialized()) {
                IterableLogger.d(TAG, "Performing automatic push registration");
                sharedInstance.registerForPush();
            }
            this.fetchRemoteConfiguration();
        }
    }

    private boolean isInitialized() {
        return this._apiKey != null && (this._email != null || this._userId != null);
    }

    private boolean checkSDKInitialization() {
        if (!this.isInitialized()) {
            IterableLogger.e(TAG, "Iterable SDK must be initialized with an API key and user email/userId before calling SDK methods");
            return false;
        }
        return true;
    }

    private SharedPreferences getPreferences() {
        return this._applicationContext.getSharedPreferences("com.iterable.iterableapi", 0);
    }

    private String getDeviceId() {
        if (this._deviceId == null) {
            this._deviceId = this.getPreferences().getString("itbl_deviceid", null);
            if (this._deviceId == null) {
                this._deviceId = UUID.randomUUID().toString();
                this.getPreferences().edit().putString("itbl_deviceid", this._deviceId).apply();
            }
        }
        return this._deviceId;
    }

    private void storeAuthData() {
        try {
            SharedPreferences.Editor editor = this.getPreferences().edit();
            editor.putString("itbl_email", this._email);
            editor.putString("itbl_userid", this._userId);
            editor.putString("itbl_authtoken", this._authToken);
            editor.commit();
        }
        catch (Exception e) {
            IterableLogger.e(TAG, "Error while persisting email/userId", e);
        }
    }

    private void retrieveEmailAndUserId() {
        try {
            SharedPreferences prefs = this.getPreferences();
            this._email = prefs.getString("itbl_email", null);
            this._userId = prefs.getString("itbl_userid", null);
            this._authToken = prefs.getString("itbl_authtoken", null);
            if (this._authToken != null) {
                this.getAuthManager().queueExpirationRefresh(this._authToken);
            }
        }
        catch (Exception e) {
            IterableLogger.e(TAG, "Error while retrieving email/userId/authToken", e);
        }
    }

    private void onLogOut() {
        if (this.config.autoPushRegistration && this.isInitialized()) {
            this.disablePush();
        }
        this.getInAppManager().reset();
        this.getAuthManager().clearRefreshTimer();
        this.apiClient.onLogout();
    }

    private void onLogIn() {
        if (!this.isInitialized()) {
            return;
        }
        if (this.config.autoPushRegistration) {
            this.registerForPush();
        }
        this.getInAppManager().syncInApp();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setInboxSessionId(@Nullable String inboxSessionId) {
        this.inboxSessionId = inboxSessionId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void clearInboxSessionId() {
        this.inboxSessionId = null;
    }

    private class IterableApiAuthProvider
    implements IterableApiClient.AuthProvider {
        private IterableApiAuthProvider() {
        }

        @Override
        @Nullable
        public String getEmail() {
            return IterableApi.this._email;
        }

        @Override
        @Nullable
        public String getUserId() {
            return IterableApi.this._userId;
        }

        @Override
        @Nullable
        public String getAuthToken() {
            return IterableApi.this._authToken;
        }

        @Override
        public String getApiKey() {
            return IterableApi.this._apiKey;
        }

        @Override
        public String getDeviceId() {
            return IterableApi.this.getDeviceId();
        }

        @Override
        public Context getContext() {
            return IterableApi.this._applicationContext;
        }
    }
}

