/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IterableActivityMonitor {
    private static boolean initialized = false;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private WeakReference<Activity> currentActivity;
    private int numStartedActivities = 0;
    private boolean inForeground = false;
    private List<WeakReference<AppStateCallback>> callbacks = new ArrayList<WeakReference<AppStateCallback>>();
    private Runnable backgroundTransitionRunnable = new Runnable(){

        @Override
        public void run() {
            IterableActivityMonitor.this.inForeground = false;
            for (WeakReference callback : IterableActivityMonitor.this.callbacks) {
                if (callback.get() == null) continue;
                ((AppStateCallback)callback.get()).onSwitchToBackground();
            }
        }
    };
    private static final int BACKGROUND_DELAY_MS = 1000;
    static IterableActivityMonitor instance = new IterableActivityMonitor();
    private Application.ActivityLifecycleCallbacks lifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
            IterableActivityMonitor.this.handler.removeCallbacks(IterableActivityMonitor.this.backgroundTransitionRunnable);
            IterableActivityMonitor.this.numStartedActivities++;
        }

        public void onActivityResumed(Activity activity) {
            IterableActivityMonitor.this.currentActivity = new WeakReference<Activity>(activity);
            if (!IterableActivityMonitor.this.inForeground) {
                IterableActivityMonitor.this.inForeground = true;
                for (WeakReference callback : IterableActivityMonitor.this.callbacks) {
                    if (callback.get() == null) continue;
                    ((AppStateCallback)callback.get()).onSwitchToForeground();
                }
            }
        }

        public void onActivityPaused(Activity activity) {
            if (IterableActivityMonitor.this.getCurrentActivity() == activity) {
                IterableActivityMonitor.this.currentActivity = null;
            }
        }

        public void onActivityStopped(Activity activity) {
            if (IterableActivityMonitor.this.numStartedActivities > 0) {
                IterableActivityMonitor.this.numStartedActivities--;
            }
            if (IterableActivityMonitor.this.numStartedActivities == 0 && IterableActivityMonitor.this.inForeground) {
                IterableActivityMonitor.this.handler.postDelayed(IterableActivityMonitor.this.backgroundTransitionRunnable, 1000L);
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };

    @NonNull
    public static IterableActivityMonitor getInstance() {
        return instance;
    }

    public void registerLifecycleCallbacks(@NonNull Context context) {
        if (!initialized) {
            initialized = true;
            ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks(this.lifecycleCallbacks);
        }
    }

    public void unregisterLifecycleCallbacks(@NonNull Context context) {
        if (initialized) {
            initialized = false;
            ((Application)context.getApplicationContext()).unregisterActivityLifecycleCallbacks(this.lifecycleCallbacks);
        }
    }

    @Nullable
    public Activity getCurrentActivity() {
        return this.currentActivity != null ? (Activity)this.currentActivity.get() : null;
    }

    public boolean isInForeground() {
        return this.getCurrentActivity() != null;
    }

    public void addCallback(@NonNull AppStateCallback callback) {
        for (WeakReference<AppStateCallback> existingCallback : this.callbacks) {
            if (existingCallback.get() != callback) continue;
            return;
        }
        this.callbacks.add(new WeakReference<AppStateCallback>(callback));
    }

    public void removeCallback(@NonNull AppStateCallback callback) {
        Iterator<WeakReference<AppStateCallback>> iterator = this.callbacks.iterator();
        while (iterator.hasNext()) {
            WeakReference<AppStateCallback> callbackRef = iterator.next();
            if (callbackRef.get() != callback) continue;
            iterator.remove();
        }
    }

    public static interface AppStateCallback {
        public void onSwitchToForeground();

        public void onSwitchToBackground();
    }
}

