/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.iterable.iterableapi.IterableAction;
import com.iterable.iterableapi.IterableActionContext;
import com.iterable.iterableapi.IterableActionSource;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.IterableUtil;
import java.util.List;

class IterableActionRunner {
    @VisibleForTesting
    static IterableActionRunnerImpl instance = new IterableActionRunnerImpl();

    IterableActionRunner() {
    }

    static boolean executeAction(@NonNull Context context, @Nullable IterableAction action, @NonNull IterableActionSource source) {
        return instance.executeAction(context, action, source);
    }

    static class IterableActionRunnerImpl {
        private static final String TAG = "IterableActionRunner";

        IterableActionRunnerImpl() {
        }

        boolean executeAction(@NonNull Context context, @Nullable IterableAction action, @NonNull IterableActionSource source) {
            if (action == null) {
                return false;
            }
            IterableActionContext actionContext = new IterableActionContext(action, source);
            if (action.isOfType("openUrl")) {
                return this.openUri(context, Uri.parse((String)action.getData()), actionContext);
            }
            return this.callCustomActionIfSpecified(action, actionContext);
        }

        private boolean openUri(@NonNull Context context, @NonNull Uri uri, @NonNull IterableActionContext actionContext) {
            if (!IterableUtil.isUrlOpenAllowed(uri.toString())) {
                return false;
            }
            if (IterableApi.sharedInstance.config.urlHandler != null && IterableApi.sharedInstance.config.urlHandler.handleIterableURL(uri, actionContext)) {
                return true;
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(uri);
            List resolveInfos = context.getPackageManager().queryIntentActivities(intent, 0);
            if (resolveInfos.size() > 1) {
                for (ResolveInfo resolveInfo : resolveInfos) {
                    if (!resolveInfo.activityInfo.packageName.equals(context.getPackageName())) continue;
                    Log.d((String)TAG, (String)("The deep link will be handled by the app: " + resolveInfo.activityInfo.packageName));
                    intent.setPackage(resolveInfo.activityInfo.packageName);
                    break;
                }
            }
            intent.setFlags(0x34000000);
            if (intent.resolveActivity(context.getPackageManager()) != null) {
                context.startActivity(intent);
                return true;
            }
            IterableLogger.e(TAG, "Could not find activities to handle deep link:" + uri);
            return false;
        }

        private boolean callCustomActionIfSpecified(@NonNull IterableAction action, @NonNull IterableActionContext actionContext) {
            if (action.getType() != null && !action.getType().isEmpty() && IterableApi.sharedInstance.config.customActionHandler != null) {
                return IterableApi.sharedInstance.config.customActionHandler.handleIterableCustomAction(action, actionContext);
            }
            return false;
        }
    }
}

