/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class IterableAction {
    public static final String ACTION_TYPE_OPEN_URL = "openUrl";
    @NonNull
    private final JSONObject config;
    @Nullable
    public String userInput;

    private IterableAction(@Nullable JSONObject config) {
        this.config = config != null ? config : new JSONObject();
    }

    @Nullable
    static IterableAction from(@Nullable JSONObject config) {
        if (config != null) {
            return new IterableAction(config);
        }
        return null;
    }

    @Nullable
    static IterableAction actionOpenUrl(@Nullable String url) {
        if (url != null) {
            try {
                JSONObject config = new JSONObject();
                config.put("type", (Object)ACTION_TYPE_OPEN_URL);
                config.put("data", (Object)url);
                return new IterableAction(config);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    static IterableAction actionCustomAction(@NonNull String customActionName) {
        try {
            JSONObject config = new JSONObject();
            config.put("type", (Object)customActionName);
            return new IterableAction(config);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Nullable
    public String getType() {
        return this.config.optString("type", null);
    }

    @Nullable
    public String getData() {
        return this.config.optString("data", null);
    }

    public boolean isOfType(@NonNull String type) {
        return this.getType() != null && this.getType().equals(type);
    }
}

