/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import androidx.annotation.RestrictTo;
import com.iterable.iterableapi.ImpressionData;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableInAppMessage;
import com.iterable.iterableapi.IterableInboxSession;
import com.iterable.iterableapi.IterableLogger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InboxSessionManager {
    private static final String TAG = "InboxSessionManager";
    IterableInboxSession session = new IterableInboxSession();
    Map<String, ImpressionData> impressions = new HashMap<String, ImpressionData>();

    public boolean isTracking() {
        return this.session.sessionStartTime != null;
    }

    public void startSession() {
        if (this.isTracking()) {
            IterableLogger.e(TAG, "Inbox session started twice");
            return;
        }
        this.session = new IterableInboxSession(new Date(), null, IterableApi.getInstance().getInAppManager().getInboxMessages().size(), IterableApi.getInstance().getInAppManager().getUnreadInboxMessagesCount(), 0, 0, null);
        IterableApi.getInstance().setInboxSessionId(this.session.sessionId);
    }

    public void startSession(List<IterableInboxSession.Impression> visibleRows) {
        this.startSession();
        this.updateVisibleRows(visibleRows);
    }

    public void endSession() {
        if (!this.isTracking()) {
            IterableLogger.e(TAG, "Inbox Session ended without start");
            return;
        }
        this.endAllImpressions();
        IterableInboxSession sessionToTrack = new IterableInboxSession(this.session.sessionStartTime, new Date(), this.session.startTotalMessageCount, this.session.startUnreadMessageCount, IterableApi.getInstance().getInAppManager().getInboxMessages().size(), IterableApi.getInstance().getInAppManager().getUnreadInboxMessagesCount(), this.getImpressionList());
        IterableApi.getInstance().trackInboxSession(sessionToTrack);
        IterableApi.getInstance().clearInboxSessionId();
        this.session = new IterableInboxSession();
        this.impressions = new HashMap<String, ImpressionData>();
    }

    public void updateVisibleRows(List<IterableInboxSession.Impression> visibleRows) {
        IterableLogger.printInfo();
        Set<String> previousImpressions = this.impressions.keySet();
        HashSet<String> visibleMessageIds = new HashSet<String>();
        for (IterableInboxSession.Impression row : visibleRows) {
            visibleMessageIds.add(row.messageId);
        }
        HashSet<String> impressionsToStart = visibleMessageIds;
        impressionsToStart.removeAll(previousImpressions);
        Set<String> impressionsToEnd = previousImpressions;
        impressionsToEnd.removeAll(visibleMessageIds);
        for (String messageId : impressionsToStart) {
            this.onMessageImpressionStarted(IterableApi.getInstance().getInAppManager().getMessageById(messageId));
        }
        for (String messageId : impressionsToEnd) {
            this.endImpression(messageId);
        }
    }

    public void onMessageImpressionStarted(IterableInAppMessage message) {
        IterableLogger.printInfo();
        String messageId = message.getMessageId();
        this.startImpression(messageId, message.isSilentInboxMessage());
    }

    public void onMessageImpressionEnded(IterableInAppMessage message) {
        IterableLogger.printInfo();
        String messageId = message.getMessageId();
        this.endImpression(messageId);
    }

    private void startImpression(String messageId, boolean silentInbox) {
        ImpressionData impressionData = this.impressions.get(messageId);
        if (impressionData == null) {
            impressionData = new ImpressionData(messageId, silentInbox);
            this.impressions.put(messageId, impressionData);
        }
        impressionData.startImpression();
    }

    private void endImpression(String messageId) {
        ImpressionData impressionData = this.impressions.get(messageId);
        if (impressionData == null) {
            IterableLogger.e(TAG, "onMessageImpressionEnded: impressionData not found");
            return;
        }
        if (impressionData.impressionStarted == null) {
            IterableLogger.e(TAG, "onMessageImpressionEnded: impressionStarted is null");
            return;
        }
        impressionData.endImpression();
    }

    private void endAllImpressions() {
        for (ImpressionData impressionData : this.impressions.values()) {
            impressionData.endImpression();
        }
    }

    private List<IterableInboxSession.Impression> getImpressionList() {
        ArrayList<IterableInboxSession.Impression> impressionList = new ArrayList<IterableInboxSession.Impression>();
        for (ImpressionData impressionData : this.impressions.values()) {
            impressionList.add(new IterableInboxSession.Impression(impressionData.messageId, impressionData.silentInbox, impressionData.displayCount, impressionData.duration));
        }
        return impressionList;
    }
}

