/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import androidx.annotation.RestrictTo;
import java.util.Date;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class ImpressionData {
    final String messageId;
    final boolean silentInbox;
    int displayCount = 0;
    float duration = 0.0f;
    Date impressionStarted = null;

    ImpressionData(String messageId, boolean silentInbox) {
        this.messageId = messageId;
        this.silentInbox = silentInbox;
    }

    void startImpression() {
        this.impressionStarted = new Date();
    }

    void endImpression() {
        if (this.impressionStarted != null) {
            ++this.displayCount;
            this.duration += (float)(new Date().getTime() - this.impressionStarted.getTime()) / 1000.0f;
            this.impressionStarted = null;
        }
    }
}

