/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommerceItem {
    public final String id;
    public final String name;
    public final double price;
    public final int quantity;
    @Nullable
    public final String sku;
    @Nullable
    public final String description;
    @Nullable
    public final String url;
    @Nullable
    public final String imageUrl;
    @Nullable
    public final String[] categories;
    @Nullable
    public final JSONObject dataFields;

    public CommerceItem(@NonNull String id2, @NonNull String name, double price, int quantity) {
        this(id2, name, price, quantity, null, null, null, null, null, null);
    }

    public CommerceItem(@NonNull String id2, @NonNull String name, double price, int quantity, @Nullable String sku, @Nullable String description, @Nullable String url, @Nullable String imageUrl, @Nullable String[] categories, @Nullable JSONObject dataFields) {
        this.id = id2;
        this.name = name;
        this.price = price;
        this.quantity = quantity;
        this.sku = sku;
        this.description = description;
        this.url = url;
        this.imageUrl = imageUrl;
        this.categories = categories;
        this.dataFields = dataFields;
    }

    @NonNull
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)this.id);
        jsonObject.put("name", (Object)this.name);
        jsonObject.put("price", this.price);
        jsonObject.put("quantity", this.quantity);
        jsonObject.putOpt("sku", (Object)this.sku);
        jsonObject.putOpt("description", (Object)this.description);
        jsonObject.putOpt("url", (Object)this.url);
        jsonObject.putOpt("imageUrl", (Object)this.imageUrl);
        jsonObject.putOpt("dataFields", (Object)this.dataFields);
        if (this.categories != null) {
            JSONArray categoriesArray = new JSONArray();
            for (String category : this.categories) {
                categoriesArray.put((Object)category);
            }
            jsonObject.put("categories", (Object)categoriesArray);
        }
        return jsonObject;
    }
}

