/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi.ui.inbox;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.iterable.iterableapi.IterableInAppDeleteActionType;
import com.iterable.iterableapi.ui.R;
import com.iterable.iterableapi.ui.inbox.IterableInboxAdapter;

public class IterableInboxTouchHelper
extends ItemTouchHelper.SimpleCallback {
    private final Drawable icon;
    private final IterableInboxAdapter adapter;
    private final ColorDrawable background;

    public IterableInboxTouchHelper(@NonNull Context context, @NonNull IterableInboxAdapter adapter) {
        super(0, 4);
        this.adapter = adapter;
        this.icon = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_delete_black_24dp);
        this.background = new ColorDrawable(-65536);
    }

    public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder target) {
        return false;
    }

    public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
        int position = viewHolder.getAdapterPosition();
        this.adapter.deleteItem(position, IterableInAppDeleteActionType.INBOX_SWIPE);
    }

    public void onChildDraw(@NonNull Canvas c, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        View itemView = viewHolder.itemView;
        this.background.setBounds(itemView.getRight() + (int)dX, itemView.getTop(), itemView.getRight(), itemView.getBottom());
        int iconTop = itemView.getTop() + (itemView.getHeight() - this.icon.getIntrinsicHeight()) / 2;
        int iconBottom = iconTop + this.icon.getIntrinsicHeight();
        int iconLeft = itemView.getRight() - this.icon.getIntrinsicWidth() * 2;
        int iconRight = itemView.getRight() - this.icon.getIntrinsicWidth();
        this.icon.setBounds(iconLeft, iconTop, iconRight, iconBottom);
        this.background.setBounds(itemView.getRight() + (int)dX, itemView.getTop(), itemView.getRight(), itemView.getBottom());
        this.background.draw(c);
        this.icon.draw(c);
    }
}

