/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi.ui.inbox;

import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableInAppLocation;
import com.iterable.iterableapi.IterableInAppMessage;
import com.iterable.iterableapi.ui.R;
import java.util.List;

public class IterableInboxMessageFragment
extends Fragment {
    public static final String ARG_MESSAGE_ID = "messageId";
    public static final String STATE_LOADED = "loaded";
    private String messageId;
    private WebView webView;
    private IterableInAppMessage message;
    private boolean loaded = false;
    private WebViewClient webViewClient = new WebViewClient(){

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            IterableApi.getInstance().trackInAppClick(IterableInboxMessageFragment.this.message, url, IterableInAppLocation.INBOX);
            IterableApi.getInstance().getInAppManager().handleInAppClick(IterableInboxMessageFragment.this.message, Uri.parse((String)url));
            if (IterableInboxMessageFragment.this.getActivity() != null) {
                IterableInboxMessageFragment.this.getActivity().finish();
            }
            return true;
        }
    };

    public static IterableInboxMessageFragment newInstance(String messageId) {
        IterableInboxMessageFragment fragment = new IterableInboxMessageFragment();
        Bundle args = new Bundle();
        args.putString(ARG_MESSAGE_ID, messageId);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.messageId = this.getArguments().getString(ARG_MESSAGE_ID);
        }
        if (savedInstanceState != null) {
            this.loaded = savedInstanceState.getBoolean(STATE_LOADED, false);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(STATE_LOADED, true);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.iterable_inbox_message_fragment, container, false);
        this.webView = (WebView)view.findViewById(R.id.webView);
        this.loadMessage();
        return view;
    }

    private IterableInAppMessage getMessageById(String messageId) {
        List messages = IterableApi.getInstance().getInAppManager().getMessages();
        for (IterableInAppMessage message : messages) {
            if (!message.getMessageId().equals(messageId)) continue;
            return message;
        }
        return null;
    }

    private void loadMessage() {
        this.message = this.getMessageById(this.messageId);
        if (this.message != null) {
            this.webView.loadDataWithBaseURL("", this.message.getContent().html, "text/html", "UTF-8", "");
            this.webView.setWebViewClient(this.webViewClient);
            if (!this.loaded) {
                IterableApi.getInstance().trackInAppOpen(this.message, IterableInAppLocation.INBOX);
                this.loaded = true;
            }
            if (this.getActivity() != null) {
                this.getActivity().setTitle((CharSequence)this.message.getInboxMetadata().title);
            }
        }
    }
}

