/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi.ui.inbox;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.iterable.iterableapi.InboxSessionManager;
import com.iterable.iterableapi.IterableActivityMonitor;
import com.iterable.iterableapi.IterableApi;
import com.iterable.iterableapi.IterableInAppDeleteActionType;
import com.iterable.iterableapi.IterableInAppLocation;
import com.iterable.iterableapi.IterableInAppManager;
import com.iterable.iterableapi.IterableInAppMessage;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.ui.R;
import com.iterable.iterableapi.ui.inbox.InboxMode;
import com.iterable.iterableapi.ui.inbox.IterableInboxAdapter;
import com.iterable.iterableapi.ui.inbox.IterableInboxAdapterExtension;
import com.iterable.iterableapi.ui.inbox.IterableInboxComparator;
import com.iterable.iterableapi.ui.inbox.IterableInboxDateMapper;
import com.iterable.iterableapi.ui.inbox.IterableInboxFilter;
import com.iterable.iterableapi.ui.inbox.IterableInboxMessageActivity;
import com.iterable.iterableapi.ui.inbox.IterableInboxTouchHelper;
import java.io.Serializable;
import java.text.DateFormat;

public class IterableInboxFragment
extends Fragment
implements IterableInAppManager.Listener,
IterableInboxAdapter.OnListInteractionListener {
    private static final String TAG = "IterableInboxFragment";
    public static final String INBOX_MODE = "inboxMode";
    public static final String ITEM_LAYOUT_ID = "itemLayoutId";
    private InboxMode inboxMode = InboxMode.POPUP;
    @LayoutRes
    private int itemLayoutId = R.layout.iterable_inbox_item;
    private String noMessagesTitle;
    private String noMessagesBody;
    TextView noMessagesTitleTextView;
    TextView noMessagesBodyTextView;
    RecyclerView recyclerView;
    private final InboxSessionManager sessionManager = new InboxSessionManager();
    private IterableInboxAdapterExtension adapterExtension = new DefaultAdapterExtension();
    private IterableInboxComparator comparator = new DefaultInboxComparator();
    private IterableInboxFilter filter = new DefaultInboxFilter();
    private IterableInboxDateMapper dateMapper = new DefaultInboxDateMapper();
    private final IterableActivityMonitor.AppStateCallback appStateCallback = new IterableActivityMonitor.AppStateCallback(){

        public void onSwitchToForeground() {
        }

        public void onSwitchToBackground() {
            IterableInboxFragment.this.sessionManager.endSession();
        }
    };

    @NonNull
    public static IterableInboxFragment newInstance() {
        return new IterableInboxFragment();
    }

    @NonNull
    public static IterableInboxFragment newInstance(@NonNull InboxMode inboxMode, @LayoutRes int itemLayoutId) {
        return IterableInboxFragment.newInstance(inboxMode, itemLayoutId, null, null);
    }

    @NonNull
    public static IterableInboxFragment newInstance(@NonNull InboxMode inboxMode, @LayoutRes int itemLayoutId, @Nullable String noMessagesTitle, @Nullable String noMessagesBody) {
        IterableInboxFragment inboxFragment = new IterableInboxFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable(INBOX_MODE, (Serializable)((Object)inboxMode));
        bundle.putInt(ITEM_LAYOUT_ID, itemLayoutId);
        bundle.putString("noMessagesTitle", noMessagesTitle);
        bundle.putString("noMessagesBody", noMessagesBody);
        inboxFragment.setArguments(bundle);
        return inboxFragment;
    }

    protected void setInboxMode(@NonNull InboxMode inboxMode) {
        this.inboxMode = inboxMode;
    }

    protected void setAdapterExtension(@NonNull IterableInboxAdapterExtension adapterExtension) {
        if (adapterExtension != null) {
            this.adapterExtension = adapterExtension;
        }
    }

    protected void setComparator(@NonNull IterableInboxComparator comparator) {
        if (comparator != null) {
            this.comparator = comparator;
        }
    }

    protected void setFilter(@NonNull IterableInboxFilter filter) {
        if (filter != null) {
            this.filter = filter;
        }
    }

    protected void setDateMapper(@NonNull IterableInboxDateMapper dateMapper) {
        if (dateMapper != null) {
            this.dateMapper = dateMapper;
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        IterableActivityMonitor.getInstance().addCallback(this.appStateCallback);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        IterableLogger.printInfo();
        Bundle arguments = this.getArguments();
        if (arguments != null) {
            if (arguments.get(INBOX_MODE) instanceof InboxMode) {
                this.inboxMode = (InboxMode)((Object)arguments.get(INBOX_MODE));
            }
            if (arguments.getInt(ITEM_LAYOUT_ID, 0) != 0) {
                this.itemLayoutId = arguments.getInt(ITEM_LAYOUT_ID);
            }
            if (arguments.getString("noMessagesTitle") != null) {
                this.noMessagesTitle = arguments.getString("noMessagesTitle");
            }
            if (arguments.getString("noMessagesBody") != null) {
                this.noMessagesBody = arguments.getString("noMessagesBody");
            }
        }
        RelativeLayout relativeLayout = (RelativeLayout)inflater.inflate(R.layout.iterable_inbox_fragment, container, false);
        this.recyclerView = (RecyclerView)relativeLayout.findViewById(R.id.list);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        IterableInboxAdapter adapter = new IterableInboxAdapter(IterableApi.getInstance().getInAppManager().getInboxMessages(), this, this.adapterExtension, this.comparator, this.filter, this.dateMapper);
        this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        this.noMessagesTitleTextView = (TextView)relativeLayout.findViewById(R.id.emptyInboxTitle);
        this.noMessagesBodyTextView = (TextView)relativeLayout.findViewById(R.id.emptyInboxMessage);
        this.noMessagesTitleTextView.setText((CharSequence)this.noMessagesTitle);
        this.noMessagesBodyTextView.setText((CharSequence)this.noMessagesBody);
        ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)new IterableInboxTouchHelper(this.getContext(), adapter));
        itemTouchHelper.attachToRecyclerView(this.recyclerView);
        return relativeLayout;
    }

    public void onResume() {
        super.onResume();
        this.updateList();
        IterableApi.getInstance().getInAppManager().addListener((IterableInAppManager.Listener)this);
        this.sessionManager.startSession();
    }

    public void onPause() {
        IterableApi.getInstance().getInAppManager().removeListener((IterableInAppManager.Listener)this);
        super.onPause();
    }

    public void onDestroy() {
        super.onDestroy();
        IterableActivityMonitor.getInstance().removeCallback(this.appStateCallback);
        if (this.getActivity() != null && !this.getActivity().isChangingConfigurations()) {
            this.sessionManager.endSession();
        }
    }

    private void updateList() {
        IterableInboxAdapter adapter = (IterableInboxAdapter)this.recyclerView.getAdapter();
        adapter.setInboxItems(IterableApi.getInstance().getInAppManager().getInboxMessages());
        this.handleEmptyInbox(adapter);
    }

    private void handleEmptyInbox(IterableInboxAdapter adapter) {
        if (adapter.getItemCount() == 0) {
            this.noMessagesTitleTextView.setVisibility(0);
            this.noMessagesBodyTextView.setVisibility(0);
            this.recyclerView.setVisibility(4);
        } else {
            this.noMessagesTitleTextView.setVisibility(4);
            this.noMessagesBodyTextView.setVisibility(4);
            this.recyclerView.setVisibility(0);
        }
    }

    public void onInboxUpdated() {
        this.updateList();
    }

    @Override
    public void onListItemTapped(@NonNull IterableInAppMessage message) {
        IterableApi.getInstance().getInAppManager().setRead(message, true);
        if (this.inboxMode == InboxMode.ACTIVITY) {
            this.startActivity(new Intent(this.getContext(), IterableInboxMessageActivity.class).putExtra("messageId", message.getMessageId()));
        } else {
            IterableApi.getInstance().getInAppManager().showMessage(message, IterableInAppLocation.INBOX);
        }
    }

    @Override
    public void onListItemDeleted(@NonNull IterableInAppMessage message, @NonNull IterableInAppDeleteActionType source) {
        IterableApi.getInstance().getInAppManager().removeMessage(message, source, IterableInAppLocation.INBOX);
    }

    @Override
    public void onListItemImpressionStarted(@NonNull IterableInAppMessage message) {
        this.sessionManager.onMessageImpressionStarted(message);
    }

    @Override
    public void onListItemImpressionEnded(@NonNull IterableInAppMessage message) {
        this.sessionManager.onMessageImpressionEnded(message);
    }

    private class DefaultAdapterExtension
    implements IterableInboxAdapterExtension<Object> {
        private DefaultAdapterExtension() {
        }

        @Override
        public int getItemViewType(@NonNull IterableInAppMessage message) {
            return 0;
        }

        @Override
        public int getLayoutForViewType(int viewType) {
            return IterableInboxFragment.this.itemLayoutId;
        }

        @Override
        @Nullable
        public Object createViewHolderExtension(@NonNull View view, int viewType) {
            return null;
        }

        @Override
        public void onBindViewHolder(@NonNull IterableInboxAdapter.ViewHolder viewHolder, @Nullable Object holderExtension, @NonNull IterableInAppMessage message) {
        }
    }

    private static class DefaultInboxComparator
    implements IterableInboxComparator {
        private DefaultInboxComparator() {
        }

        @Override
        public int compare(@NonNull IterableInAppMessage message1, @NonNull IterableInAppMessage message2) {
            return -message1.getCreatedAt().compareTo(message2.getCreatedAt());
        }
    }

    private static class DefaultInboxFilter
    implements IterableInboxFilter {
        private DefaultInboxFilter() {
        }

        @Override
        public boolean filter(@NonNull IterableInAppMessage message) {
            return true;
        }
    }

    private static class DefaultInboxDateMapper
    implements IterableInboxDateMapper {
        private DefaultInboxDateMapper() {
        }

        @Override
        @Nullable
        public CharSequence mapMessageToDateString(@NonNull IterableInAppMessage message) {
            if (message.getCreatedAt() != null) {
                DateFormat formatter = DateFormat.getDateTimeInstance(2, 3);
                return formatter.format(message.getCreatedAt());
            }
            return "";
        }
    }
}

