/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi.ui.inbox;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.ObjectsCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.iterable.iterableapi.IterableInAppDeleteActionType;
import com.iterable.iterableapi.IterableInAppMessage;
import com.iterable.iterableapi.ui.BitmapLoader;
import com.iterable.iterableapi.ui.R;
import com.iterable.iterableapi.ui.inbox.IterableInboxAdapterExtension;
import com.iterable.iterableapi.ui.inbox.IterableInboxComparator;
import com.iterable.iterableapi.ui.inbox.IterableInboxDateMapper;
import com.iterable.iterableapi.ui.inbox.IterableInboxFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class IterableInboxAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = "IterableInboxAdapter";
    @NonNull
    private final OnListInteractionListener listener;
    @NonNull
    private final IterableInboxAdapterExtension extension;
    @NonNull
    private final IterableInboxComparator comparator;
    @NonNull
    private final IterableInboxFilter filter;
    @NonNull
    private final IterableInboxDateMapper dateMapper;
    private List<InboxRow> inboxItems;
    private View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            IterableInAppMessage inboxMessage = (IterableInAppMessage)v.getTag();
            IterableInboxAdapter.this.listener.onListItemTapped(inboxMessage);
        }
    };

    IterableInboxAdapter(@NonNull List<IterableInAppMessage> values, @NonNull OnListInteractionListener listener, @NonNull IterableInboxAdapterExtension extension, @NonNull IterableInboxComparator comparator, @NonNull IterableInboxFilter filter, @NonNull IterableInboxDateMapper dateMapper) {
        this.listener = listener;
        this.extension = extension;
        this.comparator = comparator;
        this.filter = filter;
        this.inboxItems = this.inboxRowListFromInboxMessages(values);
        this.dateMapper = dateMapper;
    }

    public int getItemViewType(int position) {
        return this.extension.getItemViewType(this.inboxItems.get(position).message);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(this.extension.getLayoutForViewType(viewType), parent, false);
        return new ViewHolder(view, this.extension.createViewHolderExtension(view, viewType));
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        InboxRow inboxRow = this.inboxItems.get(position);
        IterableInAppMessage.InboxMetadata inboxMetadata = inboxRow.inboxMetadata;
        if (holder.title != null) {
            holder.title.setText((CharSequence)inboxMetadata.title);
        }
        if (holder.subtitle != null) {
            holder.subtitle.setText((CharSequence)inboxMetadata.subtitle);
        }
        if (holder.icon != null) {
            BitmapLoader.loadBitmap(holder.icon, Uri.parse((String)inboxMetadata.icon));
        }
        if (holder.unreadIndicator != null) {
            if (inboxRow.isRead) {
                holder.unreadIndicator.setVisibility(4);
            } else {
                holder.unreadIndicator.setVisibility(0);
            }
        }
        if (holder.date != null) {
            holder.date.setText(this.dateMapper.mapMessageToDateString(inboxRow.message));
        }
        holder.itemView.setTag((Object)inboxRow.message);
        holder.itemView.setOnClickListener(this.onClickListener);
        this.extension.onBindViewHolder(holder, holder.extension, inboxRow.message);
    }

    public int getItemCount() {
        return this.inboxItems.size();
    }

    public void onViewAttachedToWindow(@NonNull ViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        IterableInAppMessage message = (IterableInAppMessage)holder.itemView.getTag();
        this.listener.onListItemImpressionStarted(message);
    }

    public void onViewDetachedFromWindow(@NonNull ViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        IterableInAppMessage message = (IterableInAppMessage)holder.itemView.getTag();
        this.listener.onListItemImpressionEnded(message);
    }

    public void setInboxItems(@NonNull List<IterableInAppMessage> newValues) {
        List<InboxRow> newRowValues = this.inboxRowListFromInboxMessages(newValues);
        InAppMessageDiffCallback diffCallback = new InAppMessageDiffCallback(this.inboxItems, newRowValues);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
        this.inboxItems.clear();
        this.inboxItems.addAll(newRowValues);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    public void deleteItem(int position, @NonNull IterableInAppDeleteActionType source) {
        IterableInAppMessage deletedItem = this.inboxItems.get(position).message;
        this.inboxItems.remove(position);
        this.listener.onListItemDeleted(deletedItem, source);
        this.notifyItemRemoved(position);
    }

    private List<InboxRow> inboxRowListFromInboxMessages(List<IterableInAppMessage> messages) {
        ArrayList<InboxRow> inboxRows = new ArrayList<InboxRow>(messages.size());
        for (IterableInAppMessage message : messages) {
            if (!this.filter.filter(message)) continue;
            inboxRows.add(new InboxRow(message));
        }
        Collections.sort(inboxRows, new Comparator<InboxRow>(){

            @Override
            public int compare(InboxRow o1, InboxRow o2) {
                return IterableInboxAdapter.this.comparator.compare(o1.message, o2.message);
            }
        });
        return inboxRows;
    }

    static interface OnListInteractionListener {
        public void onListItemTapped(@NonNull IterableInAppMessage var1);

        public void onListItemDeleted(@NonNull IterableInAppMessage var1, IterableInAppDeleteActionType var2);

        public void onListItemImpressionStarted(@NonNull IterableInAppMessage var1);

        public void onListItemImpressionEnded(@NonNull IterableInAppMessage var1);
    }

    private static class InboxRow {
        private final IterableInAppMessage message;
        private final IterableInAppMessage.InboxMetadata inboxMetadata;
        private final boolean isRead;
        private final Date createdAt;

        private InboxRow(IterableInAppMessage inboxMessage) {
            this.message = inboxMessage;
            this.inboxMetadata = inboxMessage.getInboxMetadata();
            this.isRead = inboxMessage.isRead();
            this.createdAt = inboxMessage.getCreatedAt();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof InboxRow)) {
                return false;
            }
            InboxRow inboxRow = (InboxRow)obj;
            return this.message == inboxRow.message && ObjectsCompat.equals((Object)this.inboxMetadata, (Object)inboxRow.inboxMetadata) && ObjectsCompat.equals((Object)this.isRead, (Object)inboxRow.isRead) && ObjectsCompat.equals((Object)this.createdAt, (Object)inboxRow.createdAt);
        }

        public int hashCode() {
            return ObjectsCompat.hash((Object[])new Object[]{this.message, this.inboxMetadata, this.isRead, this.createdAt});
        }
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        @Nullable
        public final TextView title;
        @Nullable
        public final TextView subtitle;
        @Nullable
        public final TextView date;
        @Nullable
        public final ImageView icon;
        @Nullable
        public final ImageView unreadIndicator;
        private Object extension;

        private ViewHolder(View itemView, Object extension) {
            super(itemView);
            this.title = (TextView)itemView.findViewById(R.id.title);
            this.subtitle = (TextView)itemView.findViewById(R.id.subtitle);
            this.icon = (ImageView)itemView.findViewById(R.id.imageView);
            this.unreadIndicator = (ImageView)itemView.findViewById(R.id.unreadIndicator);
            this.date = (TextView)itemView.findViewById(R.id.date);
            this.extension = extension;
        }
    }

    private static class InAppMessageDiffCallback
    extends DiffUtil.Callback {
        private final List<InboxRow> oldList;
        private final List<InboxRow> newList;

        private InAppMessageDiffCallback(List<InboxRow> oldList, List<InboxRow> newList) {
            this.oldList = oldList;
            this.newList = newList;
        }

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            InboxRow oldItem = this.oldList.get(oldItemPosition);
            InboxRow newItem = this.newList.get(newItemPosition);
            return oldItem.message.getMessageId().equals(newItem.message.getMessageId());
        }

        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            InboxRow oldItem = this.oldList.get(oldItemPosition);
            InboxRow newItem = this.newList.get(newItemPosition);
            return oldItem.equals(newItem);
        }
    }
}

