/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.iterableapi.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.view.ViewCompat;
import com.iterable.iterableapi.IterableLogger;
import com.iterable.iterableapi.util.Future;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class BitmapLoader {
    private static final int DEFAULT_TIMEOUT_MS = 3000;

    public static void loadBitmap(final @NonNull ImageView imageView, final @Nullable Uri uri) {
        if (uri == null || uri.getPath() == null || uri.getPath().isEmpty()) {
            IterableLogger.d((String)"BitmapLoader", (String)"Empty url for Thumbnail in inbox");
            return;
        }
        Future.runAsync((Callable)new Callable<Bitmap>(){

            @Override
            public Bitmap call() throws Exception {
                return BitmapLoader.fetchBitmap(imageView.getContext(), uri);
            }
        }).onSuccess((Future.SuccessCallback)new Future.SuccessCallback<Bitmap>(){

            public void onSuccess(Bitmap result) {
                if (ViewCompat.isAttachedToWindow((View)imageView)) {
                    imageView.setImageBitmap(result);
                }
            }
        }).onFailure(new Future.FailureCallback(){

            public void onFailure(Throwable throwable) {
                IterableLogger.e((String)"BitmapLoader", (String)("Error while loading image: " + uri.toString()), (Throwable)throwable);
            }
        });
    }

    static Bitmap fetchBitmap(Context context, Uri uri) throws IOException {
        File imageFile = File.createTempFile("itbl_", ".temp", context.getCacheDir());
        if (!BitmapLoader.downloadFile(uri, imageFile)) {
            throw new RuntimeException("Failed to download image file");
        }
        return BitmapFactory.decodeFile((String)imageFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean downloadFile(Uri uri, File file) throws IOException {
        URL url = new URL(uri.toString());
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setConnectTimeout(3000);
            urlConnection.setUseCaches(true);
            inputStream = urlConnection.getInputStream();
            int responseCode = urlConnection.getResponseCode();
            if (responseCode != 200) {
                boolean bl = false;
                return bl;
            }
            if (inputStream != null) {
                int readLength;
                outputStream = new FileOutputStream(file);
                byte[] buffer = new byte[2048];
                while ((readLength = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, readLength);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }
}

