package com.invms.awprotocol;

import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewClient;

public class WebClient extends WebViewClient {
    private static final String tag = WebClient.class.getName();
    
    protected final WebActivity webActivity;

    public WebClient(WebActivity webActivity) {
        this.webActivity = webActivity;
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Log.d(tag, "urlLoading : " + url);
        try {
            Uri uri = Uri.parse(url);
            switch (uri.getScheme()) {
                case "http":
                case "https":
                    break;
                default:
                    Intent intent = new Intent(Intent.ACTION_VIEW, uri);
                    webActivity.startActivity(intent);
                    return true;
            }
        } catch (Exception e) {
            Log.e(tag, e.getLocalizedMessage(), e);
        }
        return super.shouldOverrideUrlLoading(view, url);
    }
}