/*
 * Decompiled with CFR 0.152.
 */
package com.invms.awprotocol.invoker;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSONObject;
import com.invms.awprotocol.AWRuntime;
import com.invms.awprotocol.WebResult;
import com.invms.awprotocol.invoker.BaseWebInvoker;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class GetCameraImage
extends BaseWebInvoker {
    protected String imageFormat;
    protected Integer imageQuality;

    @Override
    public boolean isCallback() {
        return true;
    }

    @Override
    public boolean invoke(String args) {
        JSONObject json = this.initCallback(args);
        this.imageFormat = json.getString("format");
        this.imageQuality = json.getInteger("quality");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.webActivity.startActivityForResult(intent, this.getRequestCode());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callbackImage(Bitmap bitmap) {
        byte[] image = null;
        if (bitmap != null) {
            Bitmap.CompressFormat format;
            if (TextUtils.isEmpty((CharSequence)this.imageFormat)) {
                format = Bitmap.CompressFormat.JPEG;
            } else {
                switch (this.imageFormat) {
                    case "png": {
                        format = Bitmap.CompressFormat.PNG;
                        break;
                    }
                    case "webp": {
                        format = Bitmap.CompressFormat.WEBP;
                        break;
                    }
                    default: {
                        format = Bitmap.CompressFormat.JPEG;
                    }
                }
            }
            int quality = this.imageQuality == null || this.imageQuality < 0 || this.imageQuality > 100 ? 100 : this.imageQuality;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                if (bitmap.compress(format, quality, (OutputStream)outputStream)) {
                    image = outputStream.toByteArray();
                }
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    Log.e((String)this.tag, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if (image == null) {
            this.doneCallback(WebResult.createFalse("\u6ca1\u6709\u56fe\u7247"));
        } else {
            this.doneCallback(WebResult.createTrue(AWRuntime.toBase64(image)));
        }
        this.imageFormat = null;
        this.imageQuality = null;
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            Bundle bundle = data.getExtras();
            this.callbackImage((Bitmap)bundle.get("data"));
        } else {
            this.callbackImage(null);
        }
        return true;
    }
}

