/*
 * Decompiled with CFR 0.152.
 */
package com.invms.awprotocol;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.invms.awprotocol.AWRuntime;
import com.invms.awprotocol.IWebInvoker;
import com.invms.awprotocol.WebChrome;
import com.invms.awprotocol.WebClient;
import com.invms.awprotocol.WebHandler;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class WebActivity
extends Activity {
    private static final String tag = WebActivity.class.getName();
    public static final int showFileResultCode = 1;
    protected long backTime;
    protected boolean webDebug;
    protected String webKey;
    protected String webUrl;
    protected String webInvokers;
    protected WebView webView;
    protected WebClient webClient;
    protected WebChrome webChrome;
    protected WebHandler webHandler;
    protected List<IWebInvoker> listWebInvokers = new CopyOnWriteArrayList<IWebInvoker>();
    protected Map<String, IWebInvoker> nameWebInvokers = new ConcurrentHashMap<String, IWebInvoker>();
    protected Map<Integer, IWebInvoker> resultCodeWebInvokers = new ConcurrentHashMap<Integer, IWebInvoker>();

    public boolean isWebDebug() {
        return this.webDebug;
    }

    public String getWebKey() {
        return this.webKey;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public String getWebInvokers() {
        return this.webInvokers;
    }

    public WebView getWebView() {
        return this.webView;
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    public WebChrome getWebChrome() {
        return this.webChrome;
    }

    public WebHandler getWebHandler() {
        return this.webHandler;
    }

    public List<IWebInvoker> getListWebInvokers() {
        return this.listWebInvokers;
    }

    public Map<String, IWebInvoker> getNameWebInvokers() {
        return this.nameWebInvokers;
    }

    public Map<Integer, IWebInvoker> getResultCodeWebInvokers() {
        return this.resultCodeWebInvokers;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 128);
            Bundle bundle = activityInfo.metaData;
            this.webDebug = AWRuntime.getConfig("webDebug", bundle.getBoolean("webDebug", false));
            Log.d((String)tag, (String)("webDebug : " + this.webDebug));
            this.webKey = AWRuntime.getConfig("webKey", bundle.getString("webKey", "awprotocol"));
            Log.d((String)tag, (String)("webKey : " + this.webKey));
            this.webUrl = AWRuntime.getConfig("webUrl", bundle.getString("webUrl", "file:///android_res/raw/index.html"));
            Log.d((String)tag, (String)("webUrl : " + this.webUrl));
            this.webInvokers = AWRuntime.getConfig("webInvokers", bundle.getString("webInvokers", ""));
            this.webInvokers = this.webInvokers.replaceAll(" ", "").replaceAll("\r", "").replaceAll("\n", "");
            Log.d((String)tag, (String)("webInvokers : " + this.webInvokers));
            WebView.setWebContentsDebuggingEnabled((boolean)this.webDebug);
            this.webView = new WebView((Context)this);
            this.setContentView((View)this.webView);
            this.webClient = new WebClient(this);
            this.webView.setWebViewClient((WebViewClient)this.webClient);
            this.webChrome = new WebChrome(this);
            this.webView.setWebChromeClient((WebChromeClient)this.webChrome);
            WebSettings webSettings = this.webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
            webSettings.setAllowFileAccessFromFileURLs(true);
            webSettings.setAllowUniversalAccessFromFileURLs(true);
            this.webHandler = new WebHandler(this);
            this.webView.addJavascriptInterface((Object)this.webHandler, this.webKey);
            this.webView.loadUrl(this.webUrl);
            String[] classNames = TextUtils.split((String)this.webInvokers, (String)",");
            for (String item : classNames) {
                if (TextUtils.isEmpty((CharSequence)item)) continue;
                try {
                    this.addWebInvoker((IWebInvoker)Class.forName(item).newInstance());
                }
                catch (Exception e) {
                    Log.e((String)tag, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            for (IWebInvoker webInvoker : this.listWebInvokers) {
                Log.d((String)tag, (String)(webInvoker.getName() + " :onCreate: " + webInvoker.onCreate(savedInstanceState)));
            }
        }
        catch (Exception e) {
            Log.e((String)tag, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void onResume() {
        super.onResume();
        for (IWebInvoker webInvoker : this.listWebInvokers) {
            Log.d((String)tag, (String)(webInvoker.getName() + " :onResume: " + webInvoker.onResume()));
        }
    }

    protected void onPause() {
        super.onPause();
        for (IWebInvoker webInvoker : this.listWebInvokers) {
            Log.d((String)tag, (String)(webInvoker.getName() + " :onPause: " + webInvoker.onPause()));
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        for (IWebInvoker webInvoker : this.listWebInvokers) {
            Log.d((String)tag, (String)(webInvoker.getName() + " :onDestroy: " + webInvoker.onDestroy()));
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean result = false;
        for (IWebInvoker webInvoker : this.listWebInvokers) {
            if (webInvoker.onKeyDown(keyCode, event)) {
                result = true;
                Log.d((String)tag, (String)(webInvoker.getName() + " :onKeyDown: true"));
                continue;
            }
            Log.d((String)tag, (String)(webInvoker.getName() + " :onKeyDown: false"));
        }
        if (!result) {
            switch (keyCode) {
                case 4: {
                    if (this.webView.canGoBack()) {
                        this.webView.goBack();
                    } else {
                        long nowTime = new Date().getTime();
                        if (nowTime - this.backTime < 2000L) {
                            this.finish();
                        } else {
                            this.backTime = nowTime;
                            Toast.makeText((Context)this, (CharSequence)"\u518d\u6309\u4e00\u6b21\u9000\u51fa", (int)0).show();
                        }
                    }
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1: {
                this.webChrome.callbackShowFile(WebChromeClient.FileChooserParams.parseResult((int)resultCode, (Intent)data));
                return;
            }
        }
        IWebInvoker webInvoker = this.resultCodeWebInvokers.get(requestCode);
        if (webInvoker != null) {
            Log.d((String)tag, (String)(webInvoker.getName() + " :onActivityResult: " + webInvoker.onActivityResult(requestCode, resultCode, data)));
            return;
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void webCallback(String callback, Object data) {
        String script = "javascript:" + callback + "(" + AWRuntime.toJson(data) + ")";
        Log.d((String)tag, (String)("webCallback : " + script));
        this.runOnUiThread(() -> this.webView.evaluateJavascript(script, null));
    }

    public void addWebInvoker(IWebInvoker webInvoker) {
        if (webInvoker.getWebActivity() == null) {
            webInvoker.setWebActivity(this);
        }
        this.listWebInvokers.add(webInvoker);
        this.nameWebInvokers.put(webInvoker.getName().toLowerCase(Locale.CHINA), webInvoker);
        this.nameWebInvokers.put(webInvoker.getClass().getName().toLowerCase(Locale.CHINA), webInvoker);
        this.resultCodeWebInvokers.put(webInvoker.getRequestCode(), webInvoker);
    }
}

