/*
 * Decompiled with CFR 0.152.
 */
package com.invms.awprotocol;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Set;

public class AWRuntime
extends Application {
    private static final String tag = AWRuntime.class.getName();
    protected static String version;
    protected static Context instance;
    protected static SharedPreferences sharedPreferences;

    public static void initialize(Context context) {
        instance = context;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            version = packageInfo.versionName;
        }
        catch (Exception e) {
            Log.e((String)tag, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        sharedPreferences = context.getSharedPreferences("awprotocol", 0);
        JSONObject.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    }

    public static String getVersion() {
        return version;
    }

    public static Context getInstance() {
        return instance;
    }

    public static SharedPreferences getSharedPreferences() {
        return sharedPreferences;
    }

    public static String getConfig(String key, String defValue) {
        return sharedPreferences.getString(key, defValue);
    }

    public static boolean getConfig(String key, boolean defValue) {
        return sharedPreferences.getBoolean(key, defValue);
    }

    public static int getConfig(String key, int defValue) {
        return sharedPreferences.getInt(key, defValue);
    }

    public static long getConfig(String key, long defValue) {
        return sharedPreferences.getLong(key, defValue);
    }

    public static float getConfig(String key, float defValue) {
        return sharedPreferences.getFloat(key, defValue);
    }

    public static Set<String> getConfig(String key, Set<String> defValue) {
        return sharedPreferences.getStringSet(key, defValue);
    }

    public static void setConfig(String key, String value) {
        Log.d((String)tag, (String)("setConfig : " + key + " = " + value));
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public static void setConfig(String key, boolean value) {
        Log.d((String)tag, (String)("setConfig : " + key + " = " + value));
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    public static void setConfig(String key, int value) {
        Log.d((String)tag, (String)("setConfig : " + key + " = " + value));
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(key, value);
        editor.apply();
    }

    public static void setConfig(String key, long value) {
        Log.d((String)tag, (String)("setConfig : " + key + " = " + value));
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(key, value);
        editor.apply();
    }

    public static void setConfig(String key, float value) {
        Log.d((String)tag, (String)("setConfig : " + key + " = " + value));
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putFloat(key, value);
        editor.apply();
    }

    public static void setConfig(String key, Set<String> value) {
        Log.d((String)tag, (String)("setConfig : " + key + " = " + TextUtils.join((CharSequence)",", value)));
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putStringSet(key, value);
        editor.apply();
    }

    public static String toJson(Object data) {
        try {
            return JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        }
        catch (Exception e) {
            Log.e((String)tag, (String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static String toBase64(byte[] data) {
        return Base64.encodeToString((byte[])data, (int)2);
    }

    public static byte[] fromBase64(String base64) {
        return Base64.decode((String)base64, (int)2);
    }

    public void onCreate() {
        super.onCreate();
        AWRuntime.initialize((Context)this);
    }
}

