/*
 * Decompiled with CFR 0.152.
 */
package com.invms.awprotocol.invoker;

import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import com.alibaba.fastjson.JSONObject;
import com.invms.awprotocol.WebResult;
import com.invms.awprotocol.invoker.BaseWebInvoker;
import com.invms.awprotocol.model.LocationModel;
import java.util.List;

public class GetUpdateLocation
extends BaseWebInvoker
implements LocationListener {
    protected Long minTime;
    protected Float minDistance;
    protected LocationManager locationManager;

    @Override
    public boolean isCallback() {
        return true;
    }

    protected void initListener() {
        String provider;
        this.locationManager.removeUpdates((LocationListener)this);
        List list = this.locationManager.getProviders(true);
        if (list.contains("gps")) {
            provider = "gps";
        } else if (list.contains("network")) {
            provider = "network";
        } else if (list.contains("passive")) {
            provider = "passive";
        } else if (list.size() > 0) {
            provider = (String)list.get(0);
        } else {
            this.doneCallback(WebResult.createFalse("\u6ca1\u6709\u5b9a\u4f4d\u9a71\u52a8"));
            provider = "gps";
        }
        this.locationManager.requestLocationUpdates(provider, this.minTime.longValue(), this.minDistance.floatValue(), (LocationListener)this);
    }

    @Override
    public boolean invoke(String args) {
        JSONObject json = this.initCallback(args);
        this.minTime = json.getLong("minTime");
        this.minDistance = json.getFloat("minDistance");
        this.minTime = this.minTime == null || this.minTime < 0L ? 1000L : this.minTime;
        this.minDistance = Float.valueOf(this.minDistance == null || this.minDistance.floatValue() < 0.0f ? 1.0f : this.minDistance.floatValue());
        this.initListener();
        return true;
    }

    @Override
    public boolean onCreate(Bundle savedInstanceState) {
        this.locationManager = (LocationManager)this.webActivity.getSystemService("location");
        return true;
    }

    public void onLocationChanged(Location location) {
        this.doneCallback(WebResult.createTrue(LocationModel.create(location)));
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
        this.initListener();
    }

    public void onProviderDisabled(String provider) {
        this.initListener();
    }
}

