package com.invms.awprotocol.invoker;

import com.alibaba.fastjson.JSONObject;
import com.invms.awprotocol.AWRuntime;
import com.invms.awprotocol.IWebInvoker;
import com.invms.awprotocol.WebActivity;
import com.invms.awprotocol.WebResult;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;

public abstract class BaseWebInvoker implements IWebInvoker {
    protected final String tag = getClass().getName();
    protected WebActivity webActivity;
    protected String callback;

    @Override
    public String getName() {
        return getClass().getSimpleName();
    }

    @Override
    public int getRequestCode() {
        return getName().hashCode();
    }

    @Override
    public boolean isCallback() {
        return false;
    }

    @Override
    public boolean isRunOnUiThread() {
        return false;
    }

    @Override
    public boolean isRunOnSynchronized() {
        return false;
    }

    @Override
    public WebActivity getWebActivity() {
        return webActivity;
    }

    @Override
    public void setWebActivity(WebActivity webActivity) {
        this.webActivity = webActivity;
    }

    protected JSONObject initCallbackDirect(String args) {
        if (!TextUtils.isEmpty(callback)) {
            webActivity.webCallback(callback, WebResult.createFalse("有新的请求"));
            callback = null;
        }
        JSONObject jsonObject = AWRuntime.fromJson(args, JSONObject.class);
        callback = jsonObject.getString("callback");
        return jsonObject;
    }

    protected JSONObject initCallback(String args) {
        if (isRunOnSynchronized()) {
            synchronized (this) {
                return initCallbackDirect(args);
            }
        } else {
            return initCallbackDirect(args);
        }
    }

    protected void doneCallbackDirect(Object data) {
        if (!TextUtils.isEmpty(callback)) {
            webActivity.webCallback(callback, data);
            callback = null;
        }
    }

    protected void doneCallback(Object data) {
        if (isRunOnSynchronized()) {
            synchronized (this) {
                doneCallbackDirect(data);
            }
        } else {
            doneCallbackDirect(data);
        }
    }

    @Override
    public boolean invoke(String args) {
        return false;
    }

    @Override
    public boolean onCreate(Bundle savedInstanceState) {
        return false;
    }

    @Override
    public boolean onResume() {
        return false;
    }

    @Override
    public boolean onPause() {
        return false;
    }

    @Override
    public boolean onDestroy() {
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        return false;
    }
}