package com.invms.awprotocol;

import android.text.TextUtils;

public class WebResult {
    public static WebResult createTrue(Object data) {
        WebResult result = new WebResult();
        result.setVersion(AWRuntime.getVersion());
        result.setSuccess(true);
        result.setData(data);
        return result;
    }

    public static WebResult createFalse(String message) {
        WebResult result = new WebResult();
        result.setVersion(AWRuntime.getVersion());
        result.setSuccess(false);
        result.setMessage(message);
        return result;
    }

    protected String version;
    protected boolean success;
    protected Object data;
    protected String message;

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean check() {
        return TextUtils.equals(version, AWRuntime.getVersion());
    }
}