package com.invms.awprotocol;

import java.util.Set;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;

public class AWRuntime extends Application {
    private static final String tag = AWRuntime.class.getName();
    protected static String version;
    protected static AWRuntime context;
    protected static SharedPreferences sharedPreferences;

    public static String getVersion() {
        return version;
    }

    public static AWRuntime getContext() {
        return context;
    }

    public static SharedPreferences getSharedPreferences() {
        return sharedPreferences;
    }

    public static String getConfig(String key, String defValue) {
        return sharedPreferences.getString(key, defValue);
    }

    public static boolean getConfig(String key, boolean defValue) {
        return sharedPreferences.getBoolean(key, defValue);
    }

    public static int getConfig(String key, int defValue) {
        return sharedPreferences.getInt(key, defValue);
    }

    public static long getConfig(String key, long defValue) {
        return sharedPreferences.getLong(key, defValue);
    }

    public static float getConfig(String key, float defValue) {
        return sharedPreferences.getFloat(key, defValue);
    }

    public static Set<String> getConfig(String key, Set<String> defValue) {
        return sharedPreferences.getStringSet(key, defValue);
    }

    public static void setConfig(String key, String value) {
        Log.d(tag, "setConfig : " + key + " = " + value);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public static void setConfig(String key, boolean value) {
        Log.d(tag, "setConfig : " + key + " = " + value);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    public static void setConfig(String key, int value) {
        Log.d(tag, "setConfig : " + key + " = " + value);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(key, value);
        editor.apply();
    }

    public static void setConfig(String key, long value) {
        Log.d(tag, "setConfig : " + key + " = " + value);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(key, value);
        editor.apply();
    }

    public static void setConfig(String key, float value) {
        Log.d(tag, "setConfig : " + key + " = " + value);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putFloat(key, value);
        editor.apply();
    }

    public static void setConfig(String key, Set<String> value) {
        Log.d(tag, "setConfig : " + key + " = " + TextUtils.join(",", value));
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putStringSet(key, value);
        editor.apply();
    }

    public static String toJson(Object data) {
        try {
            return JSON.toJSONString(data, SerializerFeature.DisableCircularReferenceDetect);
        } catch (Exception e) {
            Log.e(tag, e.getLocalizedMessage(), e);
        }
        return null;
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return JSON.parseObject(json, clazz);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        try {
            PackageManager packageManager = getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(getPackageName(), 0);
            version = packageInfo.versionName;
        } catch (Exception e) {
            Log.e(tag, e.getLocalizedMessage(), e);
        }
        context = this;
        sharedPreferences = getSharedPreferences("awprotocol", Context.MODE_PRIVATE);
        JSONObject.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    }
}