package com.invms.awprotocol.invoker;

import java.io.ByteArrayOutputStream;

import com.alibaba.fastjson.JSONObject;
import com.invms.awprotocol.AWRuntime;
import com.invms.awprotocol.WebActivity;
import com.invms.awprotocol.WebResult;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;

public class GetCameraImage extends BaseWebInvoker {
    private static final String tag = GetCameraImage.class.getName();

    private String callback;
    private String imageFormat;
    private Integer imageQuality;

    @Override
    public boolean invoke(WebActivity webActivity, String args) {
        if (callback != null) {
            webActivity.webCallback(callback, WebResult.createFalse("有新的请求"));
        }
        JSONObject json = AWRuntime.fromJson(args, JSONObject.class);
        callback = json.getString("callback");
        imageFormat = json.getString("format");
        imageQuality = json.getInteger("quality");
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        webActivity.startActivityForResult(intent, getRequestCode());
        return true;
    }

    @Override
    public boolean callback(WebActivity webActivity, int resultCode, Intent data) {
        if (resultCode == Activity.RESULT_OK) {
            Bundle bundle = data.getExtras();
            callback(webActivity, (Bitmap) bundle.get("data"));
        } else {
            callback(webActivity, null);
        }
        return true;
    }

    public void callback(WebActivity webActivity, Bitmap bitmap) {
        if (callback != null) {
            byte[] image = null;
            if (bitmap != null) {
                CompressFormat format;
                if (TextUtils.isEmpty(imageFormat)) {
                    format = CompressFormat.JPEG;
                } else {
                    switch (imageFormat) {
                        case "png":
                            format = CompressFormat.PNG;
                            break;
                        case "webp":
                            format = CompressFormat.WEBP;
                            break;
                        case "jpg":
                        case "jpeg":
                        default:
                            format = CompressFormat.JPEG;
                            break;
                    }
                }
                int quality = imageQuality == null || imageQuality < 0 || imageQuality > 100 ? 100 : imageQuality;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    if (bitmap.compress(format, quality, outputStream)) {
                        image = outputStream.toByteArray();
                    }
                } finally {
                    try {
                        outputStream.close();
                    } catch (Exception e) {
                        Log.e(tag, e.getLocalizedMessage(), e);
                    }
                }
            }
            if (image == null) {
                webActivity.webCallback(callback, WebResult.createFalse("没有图片"));
            } else {
                webActivity.webCallback(callback, WebResult.createTrue(image));
            }
            callback = null;
            imageFormat = null;
            imageQuality = null;
        }
    }
}