package com.invms.awprotocol.invoker;

import com.invms.awprotocol.IWebInvoker;
import com.invms.awprotocol.WebActivity;

import android.content.Intent;

public abstract class BaseWebInvoker implements IWebInvoker {
    protected final String tag = getClass().getName();

    @Override
    public String getName() {
        return getClass().getSimpleName();
    }

    @Override
    public int getRequestCode() {
        return getName().hashCode();
    }

    @Override
    public abstract boolean invoke(WebActivity webActivity, String args);

    @Override
    public boolean callback(WebActivity webActivity, int resultCode, Intent data) {
        return false;
    }
}