if (ext == null) {
	var ext = {};
}

if (ext.util == null) {
	ext.util = {
		mouse: {X: 0, Y: 0},
		mouseUpListener: [],
		mouseMoveListener: [],
		nodeRemoveListener: {},
		nodeInsertListener: [],
		moving: null,
			
		cancel: function(event) {
			var e = (event || window.event);
			if (typeof e.stopPropagation != 'undefined') {
				e.stopPropagation();
			} else if (typeof e.cancelBubble != 'undefined') {
				e.cancelBubble = true;
			}
		},
		
		repeat: function(element, begin, end, steps, delay, callback) {
			if (typeof element == 'string')
				element = document.getElementById(element);
			if (element.timeout) {
				window.clearInterval(element.timeout);
			} else {
				element.actual = begin;
			}
			element.timeout = window.setInterval(function() {
				var stop = end < begin ? element.actual <= end : element.actual >= end;
				if (stop) {
					window.clearInterval(element.timeout);
					element.timeout = null;
				} else {
					var step = (end - begin) / steps;
					element.actual += step;
				}
				callback(element.actual, element, stop);
			}, delay);
		},
		fade: function(element, begin, end, steps, delay, complete) {
			if (typeof element == 'string')
				element = document.getElementById(element);
			ext.util.repeat(element, begin, end, steps, delay, function(actual, element, stop) {
				ext.util.setOpacity(element, ext.util.erf(actual));
				if (stop && complete)
					complete();
			});
		},
		fadeIn: function(element, steps, delay) {
			if (typeof element == 'string')
				element = document.getElementById(element);
			if (element.actual == null)
				ext.util.setOpacity(element, 0);
			element.style.visibility = 'visible';
			ext.util.fade(element, -2, 2, steps, delay);
		},
		fadeOut: function(element, steps, delay) {
			if (typeof element == 'string')
				element = document.getElementById(element);
			element.style.visibility = 'visible';
			ext.util.fade(element, 2, -2, steps, delay, function() {
				element.style.visibility = 'hidden';
			});
		},
		setOpacity: function(element, value) {
			if (typeof element == 'string')
				element = document.getElementById(element);
			element.style.opacity = value;
			element.style.filter = 'alpha(opacity = ' + value * 100 + ')';
		},
		flash: function(element, color) {
			ext.util.repeat(element, -3, 2, 40, 50, function(actual, element, stop) {
				element.style.backgroundColor = ext.util.fadeColor(color, '#ffffff', ext.util.erf(actual));
			});
		},
		getColor: function(element, attribute) {
			if (typeof element == 'string')
				element = document.getElementById(element);
			var color = element.style['attribute'];
			if (typeof color != 'string' || color.indexOf('#') != 0 || color.length != 7)
				return '#ffffff';
			return color;
		},
		fadeColor: function(source, target, value) {
			var sourceRGB = ext.util.toRGB(source);
			if (sourceRGB == null)
				return null;
			var targetRGB = ext.util.toRGB(target);
			if (targetRGB == null)
				return null;
			var r = Math.round(sourceRGB.r + (targetRGB.r - sourceRGB.r) * value);
			var g = Math.round(sourceRGB.g + (targetRGB.g - sourceRGB.g) * value);
			var b = Math.round(sourceRGB.b + (targetRGB.b - sourceRGB.b) * value);
			return 'rgb(' + r + ', ' + g + ', ' + b + ')';
		},
		toRGB: function(color) {
			if (typeof color != 'string' || color.indexOf('#') != 0 || color.length != 7)
				return null;
			return {
				r: parseInt(color.substring(1, 3), 16),
				g: parseInt(color.substring(3, 5), 16),
				b: parseInt(color.substring(5, 7), 16),
			};
		},
		addListener: function(element, event, listener) {
			if (typeof element == 'string')
				element = document.getElementById(element);
			if (element.addEventListener) {
				element.addEventListener(event, listener, false);
			} else if (element.attachEvent) {
				element.attachEvent("on" + event, listener);
			}
		},
		
		getEventPosition: function(event) {
			var evt = event || window.event;
			return {
				X: evt.clientX,
				Y: evt.clientY
			};
		},
		getElementPosition: function(element) {
			if (typeof element == 'string')
				element = document.getElementById(element);
			return {
				left: element.offsetLeft,
				top: element.offsetTop,
				width: element.offsetWidth,
				height: element.offsetHeight
			};
		},
		setPosition: function(element, pos) {
			if (typeof element == 'string')
				element = document.getElementById(element);
			element.style.left = pos.X + "px";
			element.style.top = pos.Y + "px";
		},
		addMouseListener: function(element, mouseUpListener, mouseMoveListener) {
			ext.util.addListener(element, "mousedown", function (event) {
				ext.util.moving = event.target || event.srcElement;
			});
			if (mouseUpListener != null && !ext.util.findListener(ext.util.mouseUpListener, element)) {
				mouseUpListener.element = element;
				ext.util.mouseUpListener[ext.util.mouseUpListener.length] = mouseUpListener;
			}
			if (mouseMoveListener != null && !ext.util.findListener(ext.util.mouseMoveListener, element)) {
				mouseMoveListener.element = element;
				ext.util.mouseMoveListener[ext.util.mouseMoveListener.length] = mouseMoveListener;
			}
		},
		findListener: function(listeners, element) {
			for (var i = 0; i < listeners.length; ++i) {
				if (listeners[i].element == element) {
					return true;
				}
			}
			return false;
		},
		getRoot: function() {
			for (var i = 0; i < document.childNodes.length; ++i) {
				var element = document.childNodes[i];
				if (element.nodeName == 'HTML')
					return element;
			}
			return null;
		},
		disableButtons: function() {
			var inputs = document.getElementsByTagName("input");
			for (var i = 0; i < inputs.length; ++i) {
				var input = inputs[i];
				if (input.type === 'submit' || input.type === 'button') {
					input.disabledOrig = input.disabled;
					input.disabled = 'disabled';
				}
			}
		},
		restoreButtons: function() {
			var inputs = document.getElementsByTagName("input");
			for (var i = 0; i < inputs.length; ++i) {
				var input = inputs[i];
				if (input.type === 'submit' || input.type === 'button') {
					input.disabled = input.disabledOrig;
				}
			}
		},
		rgb: function(r, g, b) {
			var color = 0x10000 * r + 0x100 * g + 0x1000000 + b;
			return '#' + color.toString(16).substr(1);
		},
	    erf: function(x) {
			var t = 1.0 / (1.0 + 0.47047 * Math.abs(x));
			var u = t * (0.3480242 + t * (-0.0958798 + t * 0.7478556));
			var z = 0.5 * u * Math.exp(-x * x);
			return x < 0 ? z : 1 - z;
		},
		remove: function(id) {
			if (id.charAt(0) == ':')
				id = id.substr(1);
			var element = document.getElementById(id);
			if (element != null)
				element.parentNode.removeChild(element);
		},
		getInput: function(element) {
			if (element == null)
				return;
			var type = element.nodeName;
			if (type == 'INPUT' || type == 'SELECT')
				return element;
			for (var i = 0; i < element.childNodes.length; ++i) {
				var input = ext.util.getInput(element.childNodes[i]);
				if (input != null)
					return input;
			}
			return null;
		},
		clearInput: function(element) {
			if (element == null)
				return;
			var type = element.nodeName;
			if (type == 'INPUT' || type == 'SELECT') {
				element.value = '';
			} else {
				for (var i = 0; i < element.childNodes.length; ++i) {
					ext.util.clearInput(element.childNodes[i]);
				}
			}
		},
		addNodeRemoveListener: function(id, listener) {
			var listeners = ext.util.nodeRemoveListener[id];
			if (listeners == null) {
				listeners = [];
				ext.util.nodeRemoveListener[id] = listeners;
			}
			listeners.push(listener);
		},
		invokeNodeRemoved: function(event, element) {
			var id = element.id;
			if (id) {
				if (ext.util.nodeRemoveListener.hasOwnProperty(id)) {
					var listeners = ext.util.nodeRemoveListener[id];
					for (var i = 0; i < listeners.length; ++i) {
						listeners[i](event, element);
					}
					delete ext.util.nodeRemoveListener[id];
				}
			}
			for (var i = 0; i < element.childNodes.length; ++i) {
				ext.util.invokeNodeRemoved(event, element.childNodes[i]);
			}
		},
		addNodeInsertListener: function(listener) {
			ext.util.nodeInsertListener.push(listener);
		},
		invokeNodeInserted: function(element) {
			for (var i = 0; i < ext.util.nodeInsertListener.length; ++i) {
				try {
					ext.util.nodeInsertListener[i](element);
				} catch (exception) {
				}
			}
		},
		checkCharactersLeft: function(element, max) {
			if (typeof element.counter == 'undefined') {
				var position = ext.util.getOffset(element);
				element.counter = document.createElement('div');
				element.counter.id = element.id + ":count";
				element.counter.innerText = max - element.value.length;
				element.counter.style.position = 'absolute';
				element.counter.style.color = '#c0c0c0';
				element.counter.style.left = (position.left + element.clientWidth - 40) + 'px';
				element.counter.style.top = (position.top + element.clientHeight - 16) + 'px';
				element.counter.style.width = '30px';
				element.counter.style.textAlign = 'right';
				element.counter.style.fontSize = 'smaller';
				element.parentNode.appendChild(element.counter);
			}
			if (element.value.length > max)
				element.value = element.value.substring(0, max);
			var left = max - element.value.length;
			element.counter.innerText = left;
		},
		getOffset: function(element) {
			var x = 0;
			var y = 0;
			while (element && !isNaN(element.offsetLeft) && !isNaN(element.offsetTop)) {
				x += element.offsetLeft - element.scrollLeft;
				y += element.offsetTop - element.scrollTop;
				element = element.offsetParent;
			}
			return {
				top: y,
				left: x
			};
		},
		
		init: function() {
			ext.util.addListener(document, "mousemove", function(event) {
				var result = true;
				ext.util.mouse = ext.util.getEventPosition(event);
				if (ext.util.moving != null) {
					for (var i = 0; i < ext.util.mouseMoveListener.length; ++i) {
						if (ext.util.mouseMoveListener[i].element == ext.util.moving) {
							ext.util.mouseMoveListener[i](event);
							result = false;
						}
					}
				}
				return result;
			});
			ext.util.addListener(document, "mouseup", function(event) {
				if (ext.util.moving != null) {
					for (var i = 0; i < ext.util.mouseUpListener.length; ++i) {
						if (ext.util.mouseUpListener[i].element == ext.util.moving)
							ext.util.mouseUpListener[i](event);
					}
					ext.util.moving = null;
				}
			});
			ext.util.addListener(document, "DOMNodeRemoved", function(event) {
				ext.util.invokeNodeRemoved(event, event.target);
			});
			if (typeof document.body == 'undefined') {
				// TODO handle?
			} else if (document.body.addEventListener) {
				document.body.addEventListener("load", function() {
					ext.util.invokeNodeInserted(document);
				}, true);
				document.addEventListener("DOMNodeInserted", function(event) {
					ext.util.invokeNodeInserted(event.target);
				}, false);
			} else if (document.body.attachEvent) {
				window.attachEvent('onload', function() {
					ext.util.invokeNodeInserted(document);
					var proto = typeof HTMLElement == 'undefined' ? Element.prototype : HTMLElement.prototype;
					(function(replace) {
						proto.appendChild = function(newElement, element) {
							ext.util.invokeNodeInserted(newElement);
							return replace.apply(this, [newElement, element]);
						};
					})(proto.appendChild);
					(function(replace) {
						proto.insertBefore = function(newElement, element) {
							ext.util.invokeNodeInserted(newElement);
							return replace.apply(this, [newElement, element]);
						};
					})(proto.insertBefore);
					(function(replace) {
						proto.replaceChild = function(newElement, element) {
							ext.util.invokeNodeInserted(newElement);
							return replace.apply(this, [newElement, element]);
						};
					})(proto.replaceChild);
				});
			}
		}
	};
	
	ext.util.init();
}